/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPNameVerificationCheckResult
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPNameVerificationCheckResult.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "cd";
    public static final String ELM_NAME = "nv:cd";
    private static final String ELM_LABEL_NAME = "name";
    private static final String ELM_REASON = "reason";
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_RESTRICTED = "restricted";
    private static final String ATTR_LANG = "lang";
    private static final String VALUE_LANG = "en";
    private String language = "en";
    private String label;
    private boolean available = false;
    private String reason;
    private boolean restricted = false;

    public EPPNameVerificationCheckResult() {
    }

    public EPPNameVerificationCheckResult(String aName, boolean aIsAvailable) {
        this.label = aName;
        this.available = aIsAvailable;
    }

    public EPPNameVerificationCheckResult(String aName, boolean aIsAvailable, String aReason) {
        this.label = aName;
        this.available = aIsAvailable;
        this.reason = aReason;
    }

    public EPPNameVerificationCheckResult(String aName, boolean aIsAvailable, String aReason, String aLanguage, boolean aRestricted) {
        this.label = aName;
        this.available = aIsAvailable;
        this.reason = aReason;
        this.language = aLanguage;
        this.restricted = aRestricted;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setIsAvailable(boolean aIsAvailable) {
        this.available = aIsAvailable;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    public String getReason() {
        return this.reason;
    }

    public void setLanguage(String aLanguage) {
        this.language = aLanguage;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean aRestricted) {
        this.restricted = aRestricted;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.label == null) {
            throw new EPPEncodeException("label required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:name");
        root.appendChild(nameElm);
        Text textNode = aDocument.createTextNode(this.label);
        nameElm.appendChild(textNode);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_AVAIL, this.available);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_RESTRICTED, this.restricted);
        if (this.reason != null) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:reason");
            root.appendChild(reasonElm);
            if (!this.language.equals(VALUE_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_LABEL_NAME);
        this.label = theNameElm.getFirstChild().getNodeValue();
        this.available = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_AVAIL);
        this.restricted = theNameElm.getAttribute(ATTR_RESTRICTED) != null ? EPPUtil.decodeBooleanAttr(theNameElm, ATTR_RESTRICTED) : false;
        Element theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_REASON);
        if (theReasonElm != null) {
            this.reason = theReasonElm.getFirstChild().getNodeValue();
            String theLang = theReasonElm.getAttribute(ATTR_LANG);
            if (theLang.length() > 0 && !theLang.equals(VALUE_LANG)) {
                this.setLanguage(theLang);
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationCheckResult)) {
            return false;
        }
        EPPNameVerificationCheckResult other = (EPPNameVerificationCheckResult)aObject;
        if (!EqualityUtil.equals(this.label, other.label)) {
            cat.error((Object)"EPPNameVerificationCheckResult.equals(): label not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.available, other.available)) {
            cat.error((Object)"EPPNameVerificationCheckResult.equals(): available not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.restricted, other.restricted)) {
            cat.error((Object)"EPPNameVerificationCheckResult.equals(): restricted not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, other.reason)) {
            cat.error((Object)"EPPNameVerificationCheckResult.equals(): reason not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.language, other.language)) {
            cat.error((Object)"EPPNameVerificationCheckResult.equals(): language not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationCheckResult clone = null;
        clone = (EPPNameVerificationCheckResult)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

