/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameVerificationCheckCmd
extends EPPCheckCmd {
    public static final int MAX_LABELS = 99;
    public static final String ELM_LOCALNAME = "check";
    static final String ELM_NAME = "nv:check";
    private static final String ELM_LABEL_NAME = "name";
    private static Logger cat = Logger.getLogger((String)EPPNameVerificationCheckCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private List<String> labels = new ArrayList<String>();

    public EPPNameVerificationCheckCmd() {
    }

    public EPPNameVerificationCheckCmd(String aTransId) {
        super(aTransId);
    }

    public EPPNameVerificationCheckCmd(String aTransId, String aName) {
        super(aTransId);
        this.labels.add(aName);
    }

    public EPPNameVerificationCheckCmd(String aTransId, List<String> aNames) {
        super(aTransId);
        this.labels = aNames;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPNameVerificationCheckCmd other = (EPPNameVerificationCheckCmd)aObject;
        if (!EqualityUtil.equals(this.labels, other.labels)) {
            cat.error((Object)"EPPNameVerificationCheckCmd.equals(): names not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationCheckCmd clone = (EPPNameVerificationCheckCmd)super.clone();
        clone.labels = new ArrayList<String>(this.labels.size());
        for (String item : this.labels) {
            clone.labels.add(item);
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public void setLabel(String aName) {
        this.labels = new ArrayList<String>();
        this.labels.add(aName);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> aLabels) {
        this.labels = aLabels;
    }

    public void addLabel(String aLabel) {
        this.labels.add(aLabel);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.labels.size() == 0) {
            throw new EPPEncodeException("No labels specified in EPPNameVerificationCheckCmd");
        }
        if (this.labels.size() > 99) {
            throw new EPPEncodeException(this.labels.size() + " labels is greater than the maximum of " + 99);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        EPPUtil.encodeStringList(aDocument, root, this.labels, "urn:ietf:params:xml:ns:nv-1.0", "nv:name");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.labels = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_LABEL_NAME);
    }
}

