/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.lowbalancepoll;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollResponse;
import com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollThreshold;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPLowBalanceTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPLowBalanceTst(String name) {
        super(name);
    }

    public void testPoll() {
        EPPCodecTst.printStart("testPoll");
        EPPLowBalancePollResponse pollResponse = new EPPLowBalancePollResponse();
        EPPTransId respTransId = new EPPTransId("abc-123", "54321-XYZ");
        pollResponse.setTransId(respTransId);
        pollResponse.setResult(1301);
        pollResponse.setMsgQueue(new EPPMsgQueue(new Long(5L), "12345", new Date(), "Low Account Balance (SRS)"));
        pollResponse.setRegistrarName("Test Registar");
        pollResponse.setCreditLimit("1000");
        pollResponse.setCreditThreshold(new EPPLowBalancePollThreshold("FIXED", "50"));
        pollResponse.setAvailableCredit("40");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(pollResponse);
        EPPCodecTst.printEnd("testPoll");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPLowBalanceTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPLowBalanceFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPLowBalanceTst Thread " + i, EPPLowBalanceTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPLowBalanceTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

