/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPIdnTableDomainLabel
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPIdnTableDomainLabel.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "domain";
    public static final String ELM_NAME = "idnTable:domain";
    public static final String FORM_A_LABEL = "aLabel";
    public static final String FORM_U_LABEL = "uLabel";
    private static final String ATTR_FORM = "form";
    private String domain;
    private Form form = Form.A_LABEL;

    public EPPIdnTableDomainLabel() {
    }

    public EPPIdnTableDomainLabel(String aDomain) {
        this.setDomain(aDomain);
    }

    public EPPIdnTableDomainLabel(String aDomain, Form aForm) {
        this.setDomain(aDomain);
        this.setForm(aForm);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String aDomain) {
        this.domain = aDomain;
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form aForm) {
        this.form = aForm;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.domain == null) {
            throw new EPPEncodeException("Undefined domain in EPPIdnTableDomainLabel");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        root.appendChild(aDocument.createTextNode(this.domain));
        switch (this.form) {
            case A_LABEL: {
                root.setAttribute(ATTR_FORM, FORM_A_LABEL);
                break;
            }
            case U_LABEL: {
                root.setAttribute(ATTR_FORM, FORM_U_LABEL);
            }
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        if (aElement != null) {
            Node textNode = aElement.getFirstChild();
            this.domain = textNode != null ? textNode.getNodeValue() : null;
            String formAttr = aElement.getAttribute(ATTR_FORM);
            this.form = formAttr == null || formAttr.equals(FORM_A_LABEL) ? Form.A_LABEL : Form.U_LABEL;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableDomainLabel clone = (EPPIdnTableDomainLabel)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableDomainLabel)) {
            return false;
        }
        EPPIdnTableDomainLabel other = (EPPIdnTableDomainLabel)aObject;
        if (!EqualityUtil.equals(this.domain, other.domain)) {
            cat.error((Object)"EPPIdnTableDomainLabel.equals(): domain not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.form, (Object)other.form)) {
            cat.error((Object)"EPPIdnTableDomainLabel.equals(): form not equal");
            return false;
        }
        return true;
    }

    public static enum Form {
        A_LABEL,
        U_LABEL;

    }
}

