/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckDomain;
import com.verisign.epp.codec.idntable.EPPIdnTableCheckTable;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPIdnTableCheckResp
extends EPPResponse {
    private static Logger cat = Logger.getLogger((String)EPPIdnTableCheckResp.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "chkData";
    public static final String ELM_NAME = "idnTable:chkData";
    private List<EPPIdnTableCheckTable> tables = new ArrayList<EPPIdnTableCheckTable>();
    private List<EPPIdnTableCheckDomain> domains = new ArrayList<EPPIdnTableCheckDomain>();

    public EPPIdnTableCheckResp() {
    }

    public EPPIdnTableCheckResp(EPPTransId aTransId) {
        super(aTransId);
    }

    public EPPIdnTableCheckResp(EPPTransId aTransId, EPPIdnTableCheckTable aTable) {
        super(aTransId);
        this.addTable(aTable);
    }

    public EPPIdnTableCheckResp(EPPTransId aTransId, EPPIdnTableCheckDomain aDomain) {
        super(aTransId);
        this.addDomain(aDomain);
    }

    public Form getForm() {
        if (this.hasDomains() && this.hasTables() || !this.hasDomains() && !this.hasTables()) {
            return Form.UNDEFINED_FORM;
        }
        if (this.hasDomains()) {
            return Form.DOMAIN_FORM;
        }
        return Form.TABLE_FORM;
    }

    public boolean hasTables() {
        return this.tables != null && !this.tables.isEmpty();
    }

    public List<EPPIdnTableCheckTable> getTables() {
        return this.tables;
    }

    public void setTables(List<EPPIdnTableCheckTable> aTables) {
        if (aTables == null) {
            this.tables = new ArrayList<EPPIdnTableCheckTable>();
        }
        this.tables = aTables;
    }

    public void setTable(EPPIdnTableCheckTable aTable) {
        this.tables = new ArrayList<EPPIdnTableCheckTable>();
        this.tables.add(aTable);
    }

    public void addTable(EPPIdnTableCheckTable aTable) {
        this.tables.add(aTable);
    }

    public boolean hasDomains() {
        return this.domains != null && !this.domains.isEmpty();
    }

    public List<EPPIdnTableCheckDomain> getDomains() {
        return this.domains;
    }

    public void setDomains(List<EPPIdnTableCheckDomain> aDomains) {
        if (aDomains == null) {
            this.domains = new ArrayList<EPPIdnTableCheckDomain>();
        }
        this.domains = aDomains;
    }

    public void setDomain(EPPIdnTableCheckDomain aDomain) {
        this.domains = new ArrayList<EPPIdnTableCheckDomain>();
        this.domains.add(aDomain);
    }

    public void addDomain(EPPIdnTableCheckDomain aDomain) {
        this.domains.add(aDomain);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.getForm() == Form.UNDEFINED_FORM) {
            throw new EPPEncodeException("Undefined form in EPPIdnTableCheckResp");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.tables);
        EPPUtil.encodeCompList(aDocument, root, this.domains);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.tables = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:table", EPPIdnTableCheckTable.class);
        this.domains = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:domain", EPPIdnTableCheckDomain.class);
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:idnTable-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableCheckResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPIdnTableCheckResp theMap = (EPPIdnTableCheckResp)aObject;
        if (!EPPUtil.equalLists(this.tables, theMap.tables)) {
            cat.error((Object)"EPPIdnTableCheckResp.equals(): tables not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.domains, theMap.domains)) {
            cat.error((Object)"EPPIdnTableCheckResp.equals(): domains not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableCheckResp clone = (EPPIdnTableCheckResp)super.clone();
        clone.tables = (List)((ArrayList)this.tables).clone();
        clone.domains = (List)((ArrayList)this.domains).clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public static enum Form {
        UNDEFINED_FORM,
        DOMAIN_FORM,
        TABLE_FORM;

    }
}

