/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPHostCheckResult
implements EPPCodecComponent {
    static final String ELM_NAME = "host:cd";
    private static final String ELM_HOST_NAME = "host:name";
    private static final String ELM_HOST_REASON = "host:reason";
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_LANG = "lang";
    private static final String VALUE_LANG = "en";
    private String language = "en";
    private String name;
    private boolean available;
    private String reason;

    public EPPHostCheckResult() {
        this.name = null;
        this.available = true;
    }

    public EPPHostCheckResult(String aName, boolean isAvailable) {
        this.name = aName;
        this.available = isAvailable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean isKnown() {
        return !this.available;
    }

    public void setIsKnown(boolean aIsKnown) {
        this.available = !aIsKnown;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setIsAvailable(boolean aIsAvailable) {
        this.available = aIsAvailable;
    }

    public void setHostReason(String aReason) {
        this.reason = aReason;
    }

    public String getHostReason() {
        return this.reason;
    }

    public void setLanguage(String aLang) {
        this.language = aLang;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("name required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        root.appendChild(nameElm);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_AVAIL, this.available);
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        if (this.reason != null) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_HOST_REASON);
            root.appendChild(reasonElm);
            if (!this.language.equals(VALUE_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        this.available = EPPUtil.decodeBooleanAttr(currElm, ATTR_AVAIL);
        this.name = currElm.getFirstChild().getNodeValue();
        currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_REASON);
        if (currElm != null) {
            this.reason = currElm.getFirstChild().getNodeValue();
            String lang = currElm.getAttribute(ATTR_LANG);
            if (lang.length() > 0 && !lang.equals(VALUE_LANG)) {
                this.setLanguage(lang);
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostCheckResult)) {
            return false;
        }
        EPPHostCheckResult theComp = (EPPHostCheckResult)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        return this.available == theComp.available;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPHostCheckResult clone = null;
        clone = (EPPHostCheckResult)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

