/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPCredentials
implements EPPCodecComponent {
    public static final int MIN_PASSWORD_LEN = 6;
    public static final int MAX_PASSWORD_LEN = 16;
    private String clientId = null;
    private String password = null;
    private String newPassword = null;
    private String version = "1.0";
    private String lang = "en";
    static final String ELM_NAME = "creds";
    private static final String ELM_CLIENT_ID = "clID";
    private static final String ELM_PASSWORD = "pw";
    private static final String ELM_NEW_PASSWORD = "newPW";
    private static final String ELM_OPTIONS = "options";
    private final String ELM_VERSION = "version";
    private final String ELM_LANG = "lang";

    public EPPCredentials() {
    }

    public EPPCredentials(String aClientId, String aPassword) {
        this.clientId = aClientId;
        this.password = aPassword;
    }

    public EPPCredentials(String aClientId, String aPassword, String aNewPassword) {
        this.clientId = aClientId;
        this.password = aPassword;
        this.newPassword = aNewPassword;
    }

    public EPPCredentials(String aClientId, String aPassword, String aNewPassword, String aVersion, String aLang) {
        this.clientId = aClientId;
        this.password = aPassword;
        this.newPassword = aNewPassword;
        this.version = aVersion;
        this.lang = aLang;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String aClientId) {
        this.clientId = aClientId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String aNewPassword) {
        this.newPassword = aNewPassword;
    }

    public boolean hasNewPassword() {
        return this.newPassword != null;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String aVersion) {
        this.version = aVersion;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.clientId == null) {
            throw new EPPEncodeException("EPPCredentials required attribute \"client id\" is null.");
        }
        if (this.password == null) {
            throw new EPPEncodeException("EPPCredentials required attribute \"password\" is null.");
        }
        if (this.password.length() < 6 || this.password.length() > 16) {
            throw new EPPEncodeException("EPPCredentials password length of " + this.password.length() + "is out of range, must be between " + 6 + " and " + 16);
        }
        if (this.newPassword != null && (this.newPassword.length() < 6 || this.newPassword.length() > 16)) {
            throw new EPPEncodeException("EPPCredentials new password length of " + this.newPassword.length() + "is out of range, must be between " + 6 + " and " + 16);
        }
        if (this.version == null) {
            throw new EPPEncodeException("EPPCredentials required attribute \"version\" is null.");
        }
        if (this.lang == null) {
            throw new EPPEncodeException("EPPCredentials required attribute \"lang\" is null.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.clientId, "urn:ietf:params:xml:ns:epp-1.0", ELM_CLIENT_ID);
        EPPUtil.encodeString(aDocument, root, this.password, "urn:ietf:params:xml:ns:epp-1.0", ELM_PASSWORD);
        EPPUtil.encodeString(aDocument, root, this.newPassword, "urn:ietf:params:xml:ns:epp-1.0", ELM_NEW_PASSWORD);
        Element optionsElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_OPTIONS);
        root.appendChild(optionsElm);
        EPPUtil.encodeString(aDocument, optionsElm, this.version, "urn:ietf:params:xml:ns:epp-1.0", "version");
        EPPUtil.encodeString(aDocument, optionsElm, this.lang, "urn:ietf:params:xml:ns:epp-1.0", "lang");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.clientId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_CLIENT_ID);
        this.password = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_PASSWORD);
        this.newPassword = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_NEW_PASSWORD);
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_OPTIONS);
        if (currElm != null) {
            this.version = EPPUtil.decodeString(currElm, "urn:ietf:params:xml:ns:epp-1.0", "version");
            this.lang = EPPUtil.decodeString(currElm, "urn:ietf:params:xml:ns:epp-1.0", "lang");
        } else {
            this.version = null;
            this.lang = null;
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPCredentials)) {
            return false;
        }
        EPPCredentials theCred = (EPPCredentials)aObject;
        if (!(this.clientId != null ? this.clientId.equals(theCred.clientId) : theCred.clientId == null)) {
            return false;
        }
        if (!(this.password != null ? this.password.equals(theCred.password) : theCred.password == null)) {
            return false;
        }
        if (!(this.newPassword != null ? this.newPassword.equals(theCred.newPassword) : theCred.newPassword == null)) {
            return false;
        }
        if (!(this.version != null ? this.version.equals(theCred.version) : theCred.version == null)) {
            return false;
        }
        return this.lang != null ? this.lang.equals(theCred.lang) : theCred.lang == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPCredentials clone = null;
        clone = (EPPCredentials)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

