/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v11;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPFeePeriod
implements EPPCodecComponent {
    public static final String PERIOD_UNIT_MONTH = "m";
    public static final String PERIOD_UNIT_YEAR = "y";
    public static final int UNSPEC_PERIOD = -1;
    public static final int MAX_PERIOD = 99;
    public static final int MIN_PERIOD = 1;
    public static final String ELM_LOCALNAME = "period";
    private static Logger cat = Logger.getLogger((String)EPPFeePeriod.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    static final String ELM_NAME = "fee:period";
    private static final String ATTR_PERIOD_UNIT = "unit";
    private int period = 0;
    private String pUnit = "y";

    public EPPFeePeriod() {
        this.period = -1;
    }

    public EPPFeePeriod(int aPeriod) {
        this.period = aPeriod;
        this.pUnit = PERIOD_UNIT_YEAR;
    }

    public EPPFeePeriod(String aPUnit, int aPeriod) {
        this.setPUnit(aPUnit);
        this.period = aPeriod;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeePeriod clone = null;
        clone = (EPPFeePeriod)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String tempVal = null;
        tempVal = aElement.getFirstChild().getNodeValue();
        this.pUnit = aElement.getAttribute(ATTR_PERIOD_UNIT);
        this.period = tempVal == null ? -1 : Integer.parseInt(tempVal);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.11", ELM_NAME);
        if (this.pUnit == null) {
            throw new EPPEncodeException("EPPFeePeriod: Period Unit should not be null");
        }
        root.setAttribute(ATTR_PERIOD_UNIT, this.pUnit);
        Text currVal = aDocument.createTextNode(this.period + "");
        root.appendChild(currVal);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeePeriod)) {
            return false;
        }
        EPPFeePeriod theComp = (EPPFeePeriod)aObject;
        if (this.period != theComp.period) {
            return false;
        }
        return this.pUnit != null ? this.pUnit.equals(theComp.pUnit) : theComp.pUnit == null;
    }

    public int getPeriod() {
        return this.period;
    }

    public String getPUnit() {
        return this.pUnit;
    }

    public boolean isPeriodUnspec() {
        return this.period == -1;
    }

    public void setPeriod(int aPeriod) throws EPPCodecException {
        if (aPeriod != -1 && aPeriod < 1 && aPeriod > 99) {
            throw new EPPCodecException("period of " + aPeriod + " is out of range, must be between " + 1 + " and " + 99);
        }
        this.period = aPeriod;
    }

    public void setPUnit(String aPUnit) {
        if (aPUnit.equalsIgnoreCase(PERIOD_UNIT_MONTH)) {
            this.pUnit = PERIOD_UNIT_MONTH;
        } else if (this.pUnit.equalsIgnoreCase(PERIOD_UNIT_YEAR)) {
            this.pUnit = PERIOD_UNIT_YEAR;
        } else {
            cat.error((Object)("setPUnit: Invalid period unit " + aPUnit + ", setting unchanged"));
        }
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

