/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v11;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPFeeCommand
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPFeeCommand.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String PHASE_SUNRISE = "sunrise";
    public static final String PHASE_LANDRUSH = "landrush";
    public static final String PHASE_CLAIMS = "claims";
    public static final String PHASE_OPEN = "open";
    public static final String PHASE_CUSTOM = "custom";
    public static final String ELM_LOCALNAME = "command";
    public static final String ELM_NAME = "fee:command";
    public static final String ATTR_PHASE = "phase";
    public static final String ATTR_SUBPHASE = "subphase";
    private String command;
    private String phase;
    private String subphase;

    public EPPFeeCommand() {
    }

    public EPPFeeCommand(String aCommand) {
        this.command = aCommand;
    }

    public EPPFeeCommand(String aCommand, String aPhase) {
        this.command = aCommand;
        this.phase = aPhase;
    }

    public EPPFeeCommand(String aCommand, String aPhase, String aSubPhase) {
        this.command = aCommand;
        this.phase = aPhase;
        this.subphase = aSubPhase;
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String aCommand) {
        this.command = aCommand;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String aPhase) {
        this.phase = aPhase;
    }

    public boolean hasSubPhase() {
        return this.subphase != null;
    }

    public String getSubPhase() {
        return this.subphase;
    }

    public void setSubPhase(String aSubPhase) {
        this.subphase = aSubPhase;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeCommand clone = null;
        clone = (EPPFeeCommand)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String thePhase = aElement.getAttribute(ATTR_PHASE);
        this.phase = thePhase != null && !thePhase.isEmpty() ? thePhase : null;
        String theSubPhase = aElement.getAttribute(ATTR_SUBPHASE);
        this.subphase = theSubPhase != null && !theSubPhase.isEmpty() ? theSubPhase : null;
        Node textNode = aElement.getFirstChild();
        if (textNode != null) {
            this.command = textNode.getNodeValue();
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeCommand.encode(Document)");
        }
        if (this.command == null) {
            throw new EPPEncodeException("command is null on in EPPFeeCommand.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.11", ELM_NAME);
        if (this.phase != null) {
            root.setAttribute(ATTR_PHASE, this.phase);
        }
        if (this.subphase != null) {
            root.setAttribute(ATTR_SUBPHASE, this.subphase);
        }
        Text phaseText = aDocument.createTextNode(this.command);
        root.appendChild(phaseText);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeCommand)) {
            return false;
        }
        EPPFeeCommand other = (EPPFeeCommand)aObject;
        if (!EqualityUtil.equals(this.phase, other.phase)) {
            cat.error((Object)"EPPFeeCommand.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.subphase, other.subphase)) {
            cat.error((Object)"EPPFeeCommand.equals(): subphase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.command, other.command)) {
            cat.error((Object)"EPPFeeCommand.equals(): command not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

