/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v09;

import com.verisign.epp.codec.fee.v09.EPPFeeCommand;
import com.verisign.epp.codec.fee.v09.EPPFeeCredit;
import com.verisign.epp.codec.fee.v09.EPPFeePeriod;
import com.verisign.epp.codec.fee.v09.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPFeeObjectResult
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "cd";
    public static final String ELM_NAME = "fee:cd";
    public static final String DEFAULT_OBJ_ELEMENT = "name";
    private static Logger cat = Logger.getLogger((String)EPPFeeObjectResult.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_OBJ_ID = "objID";
    private static final String ELM_CURRENCY = "currency";
    private static final String ELM_CLASSIFICATION = "class";
    private static final String ATTR_OBJ_ELEMENT = "element";
    private String objID;
    private String objElement = "name";
    private String currency;
    private EPPFeeCommand command;
    private EPPFeePeriod period;
    private List<EPPFeeValue> fees = new ArrayList<EPPFeeValue>();
    private List<EPPFeeCredit> credits = new ArrayList<EPPFeeCredit>();
    private String classification;

    public EPPFeeObjectResult() {
    }

    public EPPFeeObjectResult(String aObjID, String aCurrency, EPPFeeCommand aCommand) {
        this.setObjID(aObjID);
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
    }

    public EPPFeeObjectResult(String aObjID, String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod, EPPFeeValue aFee) {
        this.setObjID(aObjID);
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
        this.addFee(aFee);
    }

    public EPPFeeObjectResult(String aObjID, String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod, List<EPPFeeValue> aFees, List<EPPFeeCredit> aCredits, String aClassification, String aObjElement) {
        this.setObjID(aObjID);
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
        this.setFees(aFees);
        this.setCredits(aCredits);
        this.setClassification(aClassification);
        this.setObjElement(aObjElement);
    }

    public String getObjID() {
        return this.objID;
    }

    public void setObjID(String aObjID) {
        this.objID = aObjID;
    }

    public String getObjElement() {
        return this.objElement;
    }

    public void setObjElement(String aObjElement) {
        this.objElement = aObjElement;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public EPPFeeCommand getCommand() {
        return this.command;
    }

    public void setCommand(EPPFeeCommand aCommand) {
        this.command = aCommand;
    }

    public boolean hasPeriod() {
        return this.period != null;
    }

    public EPPFeePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPFeePeriod aPeriod) {
        this.period = aPeriod;
    }

    public boolean hasFees() {
        return !this.fees.isEmpty();
    }

    public List<EPPFeeValue> getFees() {
        return this.fees;
    }

    public void addFee(EPPFeeValue aFee) {
        if (aFee == null) {
            return;
        }
        this.fees.add(aFee);
    }

    public void setFees(List<EPPFeeValue> aFees) {
        this.fees = aFees == null ? new ArrayList<EPPFeeValue>() : aFees;
    }

    public boolean hasCredits() {
        return !this.credits.isEmpty();
    }

    public List<EPPFeeCredit> getCredits() {
        return this.credits;
    }

    public void addCredit(EPPFeeCredit aCredit) {
        if (aCredit == null) {
            return;
        }
        this.credits.add(aCredit);
    }

    public void setCredits(List<EPPFeeCredit> aCredits) {
        this.credits = aCredits == null ? new ArrayList<EPPFeeCredit>() : aCredits;
    }

    public boolean hasClassification() {
        return this.classification != null;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String aClassification) {
        this.classification = aClassification;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeObjectResult.encode(Document)");
        }
        if (this.objID == null) {
            throw new EPPEncodeException("Required objID attribute is null in EPPFeeObjectResult.encode(Document).");
        }
        if (this.currency == null) {
            throw new EPPEncodeException("Required currency attribute is null in EPPFeeObjectResult.encode(Document).");
        }
        if (this.command == null) {
            throw new EPPEncodeException("Required command attribute is null in EPPFeeObjectResult.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.9", ELM_NAME);
        Element theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.9", "fee:objID");
        Text theVal = aDocument.createTextNode(this.objID);
        theElm.appendChild(theVal);
        root.appendChild(theElm);
        if (this.objElement != null) {
            theElm.setAttribute(ATTR_OBJ_ELEMENT, this.objElement);
        }
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.9", "fee:currency");
        EPPUtil.encodeComp(aDocument, root, this.command);
        EPPUtil.encodeComp(aDocument, root, this.period);
        EPPUtil.encodeCompList(aDocument, root, this.fees);
        EPPUtil.encodeCompList(aDocument, root, this.credits);
        EPPUtil.encodeString(aDocument, root, this.classification, "urn:ietf:params:xml:ns:fee-0.9", "fee:class");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:fee-0.9", ELM_OBJ_ID);
        if (theElm != null) {
            this.objID = EPPUtil.decodeStringValue(theElm);
            this.objElement = theElm.getAttribute(ATTR_OBJ_ELEMENT);
        }
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.9", ELM_CURRENCY);
        this.command = (EPPFeeCommand)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.9", "fee:command", EPPFeeCommand.class);
        this.period = (EPPFeePeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.9", "fee:period", EPPFeePeriod.class);
        this.fees = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.9", "fee", EPPFeeValue.class);
        this.credits = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.9", "credit", EPPFeeCredit.class);
        this.classification = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.9", ELM_CLASSIFICATION);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeObjectResult clone = (EPPFeeObjectResult)super.clone();
        clone.objID = this.objID;
        clone.objElement = this.objElement;
        clone.currency = this.currency;
        clone.command = (EPPFeeCommand)this.command.clone();
        if (this.period != null) {
            clone.period = (EPPFeePeriod)this.period.clone();
        }
        clone.fees = new ArrayList<EPPFeeValue>();
        for (EPPFeeValue fee : this.fees) {
            clone.fees.add((EPPFeeValue)fee.clone());
        }
        clone.credits = new ArrayList<EPPFeeCredit>();
        for (EPPFeeCredit credit : this.credits) {
            clone.credits.add((EPPFeeCredit)credit.clone());
        }
        clone.classification = this.classification;
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeObjectResult)) {
            cat.error((Object)("EPPFeeObjectResult.equals(): " + aObject.getClass().getName() + " not EPPFeeObjectResult instance"));
            return false;
        }
        EPPFeeObjectResult other = (EPPFeeObjectResult)aObject;
        if (!EqualityUtil.equals(this.objID, other.objID)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): objID not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.objElement, other.objElement)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): objElement not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.command, other.command)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): command not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): period not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fees, other.fees)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): fees not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.credits, other.credits)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): credits not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.classification, other.classification)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): classification not equal");
            return false;
        }
        return true;
    }
}

