/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v08;

import com.verisign.epp.codec.fee.v08.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EPPFeeTransform
implements EPPCodecComponent {
    private String ELM_NAME = "fee:" + this.getLocalName();
    private static Logger cat = Logger.getLogger((String)EPPFeeTransform.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_CURRENCY = "currency";
    private String currency;
    private List<EPPFeeValue> fees = new ArrayList<EPPFeeValue>();

    protected abstract String getLocalName();

    public EPPFeeTransform() {
    }

    public EPPFeeTransform(EPPFeeValue aFee) {
        this.addFee(aFee);
    }

    public EPPFeeTransform(List<EPPFeeValue> aFees, String aCurrency) {
        this.setFees(aFees);
        this.setCurrency(aCurrency);
    }

    public boolean hasCurrency() {
        return this.currency != null;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public boolean hasFees() {
        return !this.fees.isEmpty();
    }

    public List<EPPFeeValue> getFees() {
        return this.fees;
    }

    public void addFee(EPPFeeValue aFee) {
        if (aFee == null) {
            return;
        }
        this.fees.add(aFee);
    }

    public void setFees(List<EPPFeeValue> aFees) {
        this.fees = aFees == null ? new ArrayList<EPPFeeValue>() : aFees;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeTransform.encode(Document)");
        }
        if (this.fees.isEmpty()) {
            throw new EPPEncodeException("At least one fee is required in EPPFeeTransform.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.8", this.ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.8", "fee:currency");
        EPPUtil.encodeCompList(aDocument, root, this.fees);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.8", ELM_CURRENCY);
        if (this.currency != null && this.currency.isEmpty()) {
            this.currency = null;
        }
        this.fees = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.8", "fee", EPPFeeValue.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeTransform clone = (EPPFeeTransform)super.clone();
        clone.currency = this.currency;
        clone.fees = new ArrayList<EPPFeeValue>();
        for (EPPFeeValue fee : this.fees) {
            clone.fees.add((EPPFeeValue)fee.clone());
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeTransform)) {
            cat.error((Object)("EPPFeeTransform.equals(): " + aObject.getClass().getName() + " not EPPFeeTransform instance"));
            return false;
        }
        EPPFeeTransform other = (EPPFeeTransform)aObject;
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeTransform.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fees, other.fees)) {
            cat.error((Object)"EPPFeeTransform.equals(): fees not equal");
            return false;
        }
        return true;
    }
}

