/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v06;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeValue
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPFeeValue.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "fee";
    public static final String ELM_NAME = "fee:fee";
    public static String APPLIED_IMMEDIATE = "immediate";
    public static String APPLIED_DELAYED = "delayed";
    public static boolean DEFAULT_REDUNDABLE = true;
    public static String DEFAULT_APPLIED = APPLIED_IMMEDIATE;
    public static String GRACE_PERIOD_NONE;
    public static String DEFAULT_GRACE_PERIOD;
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_REFUNDABLE = "refundable";
    private static final String ATTR_GRACE_PERIOD = "grace-period";
    private static final String ATTR_APPLIED = "applied";
    private String description;
    private boolean refundable = DEFAULT_REDUNDABLE;
    private String gracePeriod = DEFAULT_GRACE_PERIOD;
    private String applied = DEFAULT_APPLIED;
    private BigDecimal fee;

    public EPPFeeValue() {
    }

    public EPPFeeValue(BigDecimal aFee) {
        this.setFee(aFee);
    }

    public EPPFeeValue(BigDecimal aFee, String aDescription) {
        this.setFee(aFee);
        this.setDescription(aDescription);
    }

    public EPPFeeValue(BigDecimal aFee, String aDescription, boolean aRefundable, String aGracePeriod, String aApplied) {
        this.setFee(aFee);
        this.setDescription(aDescription);
        this.setRefundable(aRefundable);
        this.setGracePeriod(aGracePeriod);
        this.setApplied(aApplied);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
        cat.debug((Object)("setDescription: description = " + this.description));
    }

    public boolean isRefundable() {
        return this.refundable;
    }

    public void setRefundable(boolean aRefundable) {
        this.refundable = aRefundable;
        cat.debug((Object)("setRefundable: refundable = " + this.refundable));
    }

    public boolean hasGracePeriod() {
        return !this.gracePeriod.equalsIgnoreCase(GRACE_PERIOD_NONE);
    }

    public String getGracePeriod() {
        return this.gracePeriod;
    }

    public void setGracePeriod(String aGracePeriod) {
        this.gracePeriod = aGracePeriod != null ? aGracePeriod : GRACE_PERIOD_NONE;
        cat.debug((Object)("setGracePeriod: gracePeriod = " + this.gracePeriod));
    }

    public String getApplied() {
        return this.applied;
    }

    public void setApplied(String aApplied) {
        this.applied = aApplied != null ? aApplied : APPLIED_IMMEDIATE;
        cat.debug((Object)("setApplied: applied = " + this.applied));
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public void setFee(BigDecimal aFee) {
        if (aFee != null) {
            this.fee = aFee;
            this.fee.setScale(2, 4);
        }
        cat.debug((Object)("setFee: fee = " + this.fee));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeValue clone = null;
        clone = (EPPFeeValue)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theDescription = aElement.getAttribute(ATTR_DESCRIPTION);
        this.description = theDescription != null && !theDescription.isEmpty() ? theDescription : null;
        this.refundable = EPPUtil.decodeBooleanAttr(aElement, ATTR_REFUNDABLE);
        String theGracePeriod = aElement.getAttribute(ATTR_GRACE_PERIOD);
        this.gracePeriod = theGracePeriod != null && !theGracePeriod.isEmpty() ? theGracePeriod : DEFAULT_GRACE_PERIOD;
        String theApplied = aElement.getAttribute(ATTR_APPLIED);
        this.applied = theApplied != null && !theApplied.isEmpty() ? theApplied : DEFAULT_APPLIED;
        this.fee = EPPUtil.decodeBigDecimal(aElement);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeValue.encode(Document)");
        }
        if (this.fee == null) {
            throw new EPPEncodeException("fee is null on in EPPFeeValue.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.6", ELM_NAME);
        if (this.description != null) {
            root.setAttribute(ATTR_DESCRIPTION, this.description);
        }
        EPPUtil.encodeBooleanAttr(root, ATTR_REFUNDABLE, this.refundable);
        if (this.gracePeriod != null) {
            root.setAttribute(ATTR_GRACE_PERIOD, this.gracePeriod);
        }
        if (this.applied != null) {
            root.setAttribute(ATTR_APPLIED, this.applied);
        }
        EPPUtil.encodeBigDecimal(aDocument, root, this.fee, null);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeValue)) {
            return false;
        }
        EPPFeeValue other = (EPPFeeValue)aObject;
        if (!EqualityUtil.equals(this.description, other.description)) {
            cat.error((Object)"EPPFeeValue.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.refundable, other.refundable)) {
            cat.error((Object)"EPPFeeValue.equals(): refundable not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.gracePeriod, other.gracePeriod)) {
            cat.error((Object)"EPPFeeValue.equals(): gracePeriod not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.applied, other.applied)) {
            cat.error((Object)"EPPFeeValue.equals(): applied not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fee, other.fee)) {
            cat.error((Object)"EPPFeeValue.equals(): fee not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    static {
        DEFAULT_GRACE_PERIOD = GRACE_PERIOD_NONE = "P0D";
    }
}

