/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPRenewCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainRenewCmd
extends EPPRenewCmd {
    static final String ELM_NAME = "domain:renew";
    private static final String ELM_DOMAIN_NAME = "domain:name";
    private static final String ELM_CURRENT_EXPIRATION_DATE = "domain:curExpDate";
    private String name = null;
    private EPPDomainPeriod period = null;
    private Date curExpDate = null;

    public EPPDomainRenewCmd() {
        this.name = null;
        this.period = new EPPDomainPeriod(1);
        this.curExpDate = null;
    }

    public EPPDomainRenewCmd(String aTransId, String aName, Date aCurExpDate) {
        super(aTransId);
        this.name = aName;
        this.curExpDate = aCurExpDate;
        this.period = new EPPDomainPeriod(1);
    }

    public EPPDomainRenewCmd(String aTransId, String aName, Date aCurExpDate, EPPDomainPeriod aPeriod) {
        super(aTransId);
        this.name = aName;
        this.curExpDate = aCurExpDate;
        this.period = aPeriod;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainRenewCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDomainRenewCmd theMap = (EPPDomainRenewCmd)aObject;
        if (!(this.name != null ? this.name.equals(theMap.name) : theMap.name == null)) {
            return false;
        }
        if (!(this.curExpDate != null ? this.curExpDate.equals(theMap.curExpDate) : theMap.curExpDate == null)) {
            return false;
        }
        return this.period != null ? this.period.equals(theMap.period) : theMap.period == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainRenewCmd clone = (EPPDomainRenewCmd)super.clone();
        if (this.period != null) {
            clone.period = (EPPDomainPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public Date getCurExpDate() {
        return this.curExpDate;
    }

    public EPPDomainPeriod getPeriod() {
        return this.period;
    }

    public void setCurExpDate(Date newCurExpDate) {
        this.curExpDate = newCurExpDate;
    }

    public void setPeriod(EPPDomainPeriod aPeriod) {
        this.period = aPeriod;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPDomainRenewCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        root.setAttribute("xmlns:domain", "urn:ietf:params:xml:ns:domain-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        EPPUtil.encodeDate(aDocument, root, this.curExpDate, "urn:ietf:params:xml:ns:domain-1.0", ELM_CURRENT_EXPIRATION_DATE);
        if (!this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.curExpDate = EPPUtil.decodeDate(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CURRENT_EXPIRATION_DATE);
        this.period = (EPPDomainPeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:period", EPPDomainPeriod.class);
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.curExpDate == null) {
            throw new EPPCodecException("currentExpirationYear required attribute is not set");
        }
    }
}

