/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainAddRemove
implements EPPCodecComponent {
    static final short MODE_NONE = 0;
    static final short MODE_ADD = 1;
    static final short MODE_REMOVE = 2;
    static final String ELM_ADD = "domain:add";
    static final String ELM_REMOVE = "domain:rem";
    static final String ELM_CHANGE = "domain:chg";
    static final short MODE_CHANGE = 3;
    private static final String ELM_SERVER = "domain:ns";
    private static final String ELM_HOST_OBJ = "domain:hostObj";
    private static final String ELM_HOST_ATTR = "domain:hostAttr";
    private static final String ELM_CONTACT = "domain:contact";
    private static final String ELM_STATUS = "domain:status";
    private static final String ELM_REGISTRANT = "domain:registrant";
    private static Logger cat = Logger.getLogger((String)EPPDomainAddRemove.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private short mode = 0;
    private Vector servers = null;
    private Vector contacts = null;
    private Vector statuses = null;
    private EPPAuthInfo authInfo = null;
    private String registrant = null;

    public EPPDomainAddRemove() {
        this.servers = null;
        this.contacts = null;
        this.statuses = null;
        this.registrant = null;
        this.authInfo = null;
    }

    public EPPDomainAddRemove(Vector someServers, Vector someContacts, Vector someStatuses) {
        this.servers = someServers;
        this.contacts = someContacts;
        this.statuses = someStatuses;
    }

    public EPPDomainAddRemove(String aRegistrant, EPPAuthInfo aAuthInfo) {
        this.registrant = aRegistrant;
        this.setAuthInfo(aAuthInfo);
    }

    public Vector getServers() {
        return this.servers;
    }

    public void setServers(Vector aServers) {
        this.servers = aServers;
    }

    public Vector getContacts() {
        return this.contacts;
    }

    public void setContacts(Vector aContacts) {
        this.contacts = aContacts;
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Vector aStatuses) {
        this.statuses = aStatuses;
    }

    public boolean contactsSupported() {
        return EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0");
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root;
        if (this.mode == 3) {
            Element root2 = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_CHANGE);
            if (this.registrant != null) {
                EPPUtil.encodeString(aDocument, root2, this.registrant, "urn:ietf:params:xml:ns:domain-1.0", ELM_REGISTRANT);
            }
            if (this.authInfo != null) {
                EPPUtil.encodeComp(aDocument, root2, this.authInfo);
            }
            return root2;
        }
        if (this.mode == 1) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_ADD);
        } else if (this.mode == 2) {
            root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_REMOVE);
        } else {
            throw new EPPEncodeException("Invalid EPPDomainAddRemove mode of " + this.mode);
        }
        if (this.servers != null && this.servers.size() > 0) {
            Element theServersElm = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_SERVER);
            root.appendChild(theServersElm);
            Object theNS = this.servers.get(0);
            if (theNS instanceof String) {
                EPPUtil.encodeVector(aDocument, theServersElm, this.servers, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_OBJ);
            } else if (theNS instanceof EPPHostAttr) {
                EPPUtil.encodeCompVector(aDocument, theServersElm, this.servers);
            } else {
                throw new EPPEncodeException("EPPDomainAddRemove.encode: Invalid NS server class " + theNS.getClass().getName());
            }
        }
        if (this.contacts != null) {
            if (this.contactsSupported()) {
                EPPUtil.encodeCompVector(aDocument, root, this.contacts);
            } else {
                throw new EPPEncodeException("Contacts specified when the Contact Mapping is not supported");
            }
        }
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_ADD))) {
            this.mode = 1;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_REMOVE))) {
            this.mode = (short)2;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_CHANGE))) {
            this.mode = (short)3;
        } else {
            throw new EPPDecodeException("Invalid EPPDomainAddRemove mode of " + aElement.getLocalName());
        }
        if (this.mode == 3) {
            this.registrant = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_REGISTRANT);
            this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo", EPPAuthInfo.class);
        } else {
            Element theServerElm;
            Element theServersElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_SERVER);
            if (theServersElm != null && (theServerElm = EPPUtil.getFirstElementChild(theServersElm)) != null) {
                if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_OBJ))) {
                    this.servers = EPPUtil.decodeVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_OBJ);
                } else if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_ATTR))) {
                    this.servers = EPPUtil.decodeCompVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_ATTR, EPPHostAttr.class);
                } else {
                    throw new EPPDecodeException("EPPDomainAddRemove.doDecode: Invalid host child element " + theServersElm.getLocalName());
                }
                if (this.servers.size() == 0) {
                    this.servers = null;
                }
            }
            this.contacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CONTACT, EPPDomainContact.class);
            if (this.contacts.size() == 0) {
                this.contacts = null;
            }
            this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_STATUS, EPPDomainStatus.class);
            if (this.statuses.size() == 0) {
                this.statuses = null;
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainAddRemove)) {
            cat.error((Object)("EPPDomainAddRemove.equals(): " + aObject.getClass().getName() + " not EPPDomainAddRemove instance"));
            return false;
        }
        EPPDomainAddRemove theComp = (EPPDomainAddRemove)aObject;
        if (this.mode != theComp.mode) {
            cat.error((Object)"EPPDomainAddRemove.equals(): mode not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.servers, theComp.servers)) {
            cat.error((Object)"EPPDomainAddRemove.equals(): servers not equal");
            return false;
        }
        if (this.contactsSupported() && !EPPUtil.equalVectors(this.contacts, theComp.contacts)) {
            cat.error((Object)"EPPDomainAddRemove.equals(): contacts not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theComp.statuses)) {
            cat.error((Object)"EPPDomainAddRemove.equals(): statuses not equal");
            return false;
        }
        if (!(this.registrant != null ? this.registrant.equals(theComp.registrant) : theComp.registrant == null)) {
            cat.error((Object)"EPPDomainAddRemove.equals(): registrant not equal");
            return false;
        }
        if (!(this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null)) {
            cat.error((Object)"EPPDomainAddRemove.equals(): authInfo not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainAddRemove clone = null;
        clone = (EPPDomainAddRemove)super.clone();
        if (this.servers != null) {
            clone.servers = (Vector)this.servers.clone();
        }
        if (this.contacts != null) {
            clone.contacts = (Vector)this.contacts.clone();
            for (int i = 0; i < this.contacts.size(); ++i) {
                clone.contacts.setElementAt(((EPPDomainContact)this.contacts.elementAt(i)).clone(), i);
            }
        }
        if (this.statuses != null) {
            clone.statuses = (Vector)this.statuses.clone();
        }
        if (this.registrant != null) {
            clone.registrant = this.registrant;
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        }
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    public boolean isEmpty() {
        return this.servers == null && this.contacts == null && this.statuses == null && this.registrant == null && this.authInfo == null;
    }

    short getMode() {
        return this.mode;
    }

    void setMode(short aMode) {
        this.mode = aMode;
    }
}

