/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPParserException;
import com.verisign.epp.util.EPPSchemaCacher;
import com.verisign.epp.util.EPPSchemaCachingEntityResolver;
import com.verisign.epp.util.EPPSchemaParsingEntityResolver;
import com.verisign.epp.util.EPPXMLErrorHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.XML11Configuration;
import org.apache.xerces.parsers.XMLGrammarCachingConfiguration;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class EPPSchemaCachingParser
extends DocumentBuilder
implements EPPSchemaCacher {
    public static final String POOL = "EPP_XML_PARSER_POOL";
    private static Logger cat = Logger.getLogger((String)EPPSchemaCachingParser.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final int BIG_PRIME = 2039;
    public static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    public static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    public static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    public static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String DEFER_NODE_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    public static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    public static final String LOAD_DTD_GRAMMAR = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    public static final String CREATE_ENTITY_REF_NODES = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    public static final String INCLUDE_IGNORABLE_WHITE_SPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    public static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    public static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    public static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    private int symbolTableSize = 2039;
    private DOMParser parserImpl = null;
    private XMLGrammarPool grammarPool = new XMLGrammarPoolImpl();

    public EPPSchemaCachingParser() {
        try {
            this.init();
        }
        catch (EPPParserException e) {
            cat.error((Object)"Couldn't instantiate parser instance", (Throwable)e);
        }
    }

    public EPPSchemaCachingParser(int aSymbolTableSize) {
        this.symbolTableSize = aSymbolTableSize;
        try {
            this.init();
        }
        catch (EPPParserException e) {
            cat.error((Object)"Couldn't instantiate parser instance", (Throwable)e);
        }
    }

    protected void init() throws EPPParserException {
        cat.debug((Object)"init() enter");
        cat.debug((Object)("Creating parser instance with symbol table size: " + this.symbolTableSize));
        if (this.symbolTableSize == 0) {
            this.parserImpl = new DOMParser((XMLParserConfiguration)new XMLGrammarCachingConfiguration());
        } else {
            SymbolTable symbolTable = new SymbolTable(this.symbolTableSize);
            this.parserImpl = new DOMParser((XMLParserConfiguration)new XML11Configuration(symbolTable));
        }
        if (EPPEnv.isUseEntityResolver()) {
            cat.debug((Object)("Setting Entity Resolver to " + EPPSchemaCachingEntityResolver.class.getName()));
            this.parserImpl.setEntityResolver((EntityResolver)new EPPSchemaCachingEntityResolver(this));
        } else {
            cat.debug((Object)"Not setting Entity Resolver");
            this.parserImpl.setEntityResolver(null);
        }
        cat.debug((Object)"Setting default parser features.");
        try {
            if (EPPEnv.getValidating()) {
                this.parserImpl.setFeature(VALIDATION_FEATURE_ID, true);
                this.parserImpl.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
                cat.debug((Object)"Schema validation enabled.");
            }
            if (EPPEnv.getFullSchemaChecking()) {
                this.parserImpl.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
                cat.debug((Object)"Full schema checking enabled.");
            }
            if (EPPEnv.getValidating() || EPPEnv.getFullSchemaChecking()) {
                this.parserImpl.setErrorHandler((ErrorHandler)new EPPXMLErrorHandler());
            }
            this.parserImpl.setFeature(LOAD_EXTERNAL_DTD, false);
            this.parserImpl.setFeature(LOAD_DTD_GRAMMAR, false);
            this.parserImpl.setFeature(CREATE_ENTITY_REF_NODES, false);
            this.parserImpl.setFeature(INCLUDE_IGNORABLE_WHITE_SPACE, false);
            this.parserImpl.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            this.parserImpl.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
            this.parserImpl.setFeature(NORMALIZE_DATA, true);
            this.parserImpl.setFeature(NAMESPACES_FEATURE_ID, true);
            this.parserImpl.setFeature(DEFER_NODE_EXPANSION, false);
        }
        catch (SAXException e) {
            cat.error((Object)"setting features of parserImpl failed", (Throwable)e);
            throw new EPPParserException(e);
        }
        Set theSchemas = EPPFactory.getInstance().getXmlSchemas();
        for (String theSchemaName : theSchemas) {
            cat.debug((Object)("init(): Pre-loading XML schema \"" + theSchemaName + "\""));
            InputStream theSchemaStream = this.getClass().getClassLoader().getResourceAsStream("schemas/" + theSchemaName);
            this.addSchemaToCache(new XMLInputSource(theSchemaName, theSchemaName, theSchemaName, theSchemaStream, null));
        }
        cat.debug((Object)"init() exit");
    }

    @Override
    public void setLockSchemaCache(boolean aBoolean) {
        cat.debug((Object)("Setting lockSchemaCache to: " + aBoolean));
        if (aBoolean) {
            this.grammarPool.lockPool();
        } else {
            this.grammarPool.unlockPool();
        }
    }

    @Override
    public void addSchemaToCache(XMLInputSource aSchema) throws EPPParserException {
        cat.debug((Object)"addSchemaToCache(XMLInputSource) enter");
        SymbolTable preparserSymTable = new SymbolTable(2039);
        XMLGrammarPreparser preparser = new XMLGrammarPreparser(preparserSymTable);
        preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        preparser.setGrammarPool(this.grammarPool);
        preparser.setEntityResolver((XMLEntityResolver)new EPPSchemaParsingEntityResolver());
        preparser.setFeature(NAMESPACES_FEATURE_ID, true);
        preparser.setFeature(VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        cat.debug((Object)("parsing schema to add it to the pool: " + aSchema.getSystemId()));
        try {
            preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", aSchema);
        }
        catch (IOException e) {
            cat.error((Object)("Error while attempting to add schema: " + aSchema.getSystemId()));
            throw new EPPParserException(e);
        }
        try {
            this.parserImpl.setProperty(XMLGRAMMAR_POOL, (Object)this.grammarPool);
        }
        catch (SAXException e) {
            cat.error((Object)"Couldn't reset grammar pool when new grammar detected");
            throw new EPPParserException(e);
        }
        cat.debug((Object)"addSchemaToCache(XMLInputSource) exit");
    }

    @Override
    public boolean isNamespaceAware() {
        try {
            return this.parserImpl.getFeature(NAMESPACES_FEATURE_ID);
        }
        catch (SAXException x) {
            throw new IllegalStateException(x.getMessage());
        }
    }

    @Override
    public void setEntityResolver(EntityResolver aEntityResolver) {
        this.parserImpl.setEntityResolver(aEntityResolver);
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    @Override
    public Document newDocument() {
        return new DocumentImpl();
    }

    @Override
    public Document parse(InputSource aXmlInstance) throws SAXException, IOException {
        if (aXmlInstance == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        this.parserImpl.parse(aXmlInstance);
        return this.parserImpl.getDocument();
    }

    @Override
    public Document parse(InputStream aInputStream, String aSystemId) throws SAXException, IOException {
        this.parserImpl.parse(new InputSource(aInputStream));
        return this.parserImpl.getDocument();
    }

    @Override
    public Document parse(String aUri) throws SAXException, IOException {
        this.parserImpl.parse(aUri);
        return this.parserImpl.getDocument();
    }

    @Override
    public Document parse(InputStream aInputStream) throws SAXException, IOException {
        this.parserImpl.parse(new InputSource(aInputStream));
        return this.parserImpl.getDocument();
    }

    @Override
    public Document parse(File aFile) throws SAXException, IOException {
        FileInputStream fileStream = new FileInputStream(aFile);
        return this.parse(fileStream);
    }

    @Override
    public void setErrorHandler(ErrorHandler aErrorHandler) {
        this.parserImpl.setErrorHandler(aErrorHandler);
    }

    @Override
    public boolean isValidating() {
        try {
            return this.parserImpl.getFeature(VALIDATION_FEATURE_ID);
        }
        catch (SAXException x) {
            throw new IllegalStateException(x.getMessage());
        }
    }

    public int getSymbolTableSize() {
        return this.symbolTableSize;
    }

    public synchronized void setSymbolTableSize(int aSymbolTableSize) throws EPPParserException {
        cat.debug((Object)"setSymbolTableSize(int symbolTableSize) enter");
        this.symbolTableSize = aSymbolTableSize;
        if (aSymbolTableSize == 0) {
            this.parserImpl = new DOMParser((XMLParserConfiguration)new XMLGrammarCachingConfiguration());
        } else {
            SymbolTable symtable = new SymbolTable(this.symbolTableSize);
            try {
                this.parserImpl.setProperty(SYMBOL_TABLE, (Object)symtable);
            }
            catch (SAXException e) {
                cat.error((Object)("Couldn't reset symbol table to size " + this.symbolTableSize));
                throw new EPPParserException(e);
            }
        }
        cat.debug((Object)"setSymbolTableSize(int symbolTableSize) exit");
    }

    public void setFeature(String aFeatureId, boolean aBoolean) throws SAXNotSupportedException, SAXNotRecognizedException {
        this.parserImpl.setFeature(aFeatureId, aBoolean);
    }

    public void setProperty(String aProperty, Object aObject) throws SAXNotSupportedException, SAXNotRecognizedException {
        this.parserImpl.setProperty(aProperty, aObject);
    }

    public boolean getFeature(String aFeatureId) throws SAXNotSupportedException, SAXNotRecognizedException {
        return this.parserImpl.getFeature(aFeatureId);
    }

    public Object getProperty(String aPropertyId) throws SAXNotSupportedException, SAXNotRecognizedException {
        return this.parserImpl.getProperty(aPropertyId);
    }
}

