/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCheckCmd;
import com.verisign.epp.codec.contact.EPPContactCheckResp;
import com.verisign.epp.codec.contact.EPPContactCheckResult;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactCreateResp;
import com.verisign.epp.codec.contact.EPPContactDeleteCmd;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactStatus;
import com.verisign.epp.codec.contact.EPPContactTransferCmd;
import com.verisign.epp.codec.contact.EPPContactTransferResp;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPContactHandler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class ContactHandler
extends EPPContactHandler {
    private static final String svrTransId = "54322-XYZ";
    private static final String roid = "NS1EXAMPLE1-VRSN";
    private static Logger cat = Logger.getLogger((String)ContactHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    @Override
    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    @Override
    protected EPPEventResponse doContactDelete(EPPEvent aEvent, Object aData) {
        EPPContactDeleteCmd theMessage = (EPPContactDeleteCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doContactCreate(EPPEvent aEvent, Object aData) {
        EPPContactCreateCmd theMessage = (EPPContactCreateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPContactCreateResp theResponse = new EPPContactCreateResp(transId, theMessage.getId(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doContactUpdate(EPPEvent aEvent, Object aData) {
        EPPContactUpdateCmd theMessage = (EPPContactUpdateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doContactInfo(EPPEvent aEvent, Object aData) {
        EPPContactInfoCmd theCommand = (EPPContactInfoCmd)aEvent.getMessage();
        EPPContactInfoResp theResponse = null;
        theResponse = theCommand.getId().contains("Minimal") ? this.getMinimalInfoResponseWithAllElements(theCommand) : (theCommand.getId().contains("Partial") ? this.getPartialInfoResponseWithAllElements(theCommand) : this.getDefaultInfoResponseWithAllElements(theCommand));
        return new EPPEventResponse(theResponse);
    }

    private EPPContactInfoResp getDefaultInfoResponseWithAllElements(EPPContactInfoCmd theCommand) {
        EPPContactInfoResp theResponse = null;
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "loc", address);
        Vector<String> i15dStreets = new Vector<String>();
        i15dStreets.addElement("i15d 123 Example Dr.");
        i15dStreets.addElement("i15d Suite 100");
        EPPContactAddress i15dAddress = new EPPContactAddress(i15dStreets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition i15dName = null;
        i15dName = new EPPContactPostalDefinition("i15d John Doe", "i15d Example Inc.", "int", i15dAddress);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("linked"));
        infoStatuses.addElement(new EPPContactStatus("clientUpdateProhibited"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), svrTransId);
        theResponse = new EPPContactInfoResp(respTransId, "SH8013-VRSN", "sh8013", infoStatuses, name, "jdoe@example.com", "ClientY", "ClientX", new Date(), new EPPAuthInfo("urn:ietf:params:xml:ns:contact-1.0", "contact:authInfo", "2fooBAR"));
        theResponse.setVoice("+1.7035555555");
        theResponse.setVoiceExt("123");
        theResponse.setFax("+1.7035555556");
        theResponse.setFaxExt("456");
        theResponse.addPostalInfo(i15dName);
        EPPContactDisclose disclose = new EPPContactDisclose(true, true, false, true, true, true, true, true, true, true);
        theResponse.setDisclose(disclose);
        theResponse.setResult(1000);
        return theResponse;
    }

    private EPPContactInfoResp getPartialInfoResponseWithAllElements(EPPContactInfoCmd theCommand) {
        EPPContactInfoResp theResponse = null;
        EPPContactPostalDefinition postalInfo = new EPPContactPostalDefinition(null, null, "int", null);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("ok"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), svrTransId);
        theResponse = new EPPContactInfoResp();
        theResponse.setTransId(respTransId);
        theResponse.setRoid("SH8013-VRSN");
        theResponse.setId(theCommand.getId());
        EPPContactAddress address = new EPPContactAddress();
        address.setCountry("US");
        postalInfo.setAddress(address);
        theResponse.addPostalInfo(postalInfo);
        theResponse.setEmail("jdoe@example.com");
        theResponse.setStatuses(infoStatuses);
        theResponse.setClientId("ClientY");
        theResponse.setCreatedBy("ClientX");
        theResponse.setCreatedDate(new Date());
        theResponse.setAuthInfo(new EPPAuthInfo("urn:ietf:params:xml:ns:contact-1.0", "contact:authInfo", "2fooBAR"));
        theResponse.setResult(1000);
        return theResponse;
    }

    private EPPContactInfoResp getMinimalInfoResponseWithAllElements(EPPContactInfoCmd theCommand) {
        EPPContactInfoResp theResponse = null;
        EPPContactPostalDefinition postalInfo = new EPPContactPostalDefinition();
        postalInfo.setType("int");
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("ok"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), svrTransId);
        theResponse = new EPPContactInfoResp();
        theResponse.setTransId(respTransId);
        theResponse.setRoid("SH8013-VRSN");
        theResponse.setId(theCommand.getId());
        theResponse.addPostalInfo(postalInfo);
        theResponse.setStatuses(infoStatuses);
        theResponse.setClientId("ClientY");
        theResponse.setCreatedBy("ClientX");
        theResponse.setCreatedDate(new Date());
        theResponse.setAuthInfo(new EPPAuthInfo("urn:ietf:params:xml:ns:contact-1.0", "contact:authInfo", "2fooBAR"));
        theResponse.setResult(1000);
        return theResponse;
    }

    @Override
    protected EPPEventResponse doContactTransfer(EPPEvent aEvent, Object aData) {
        EPPContactTransferCmd theCommand = (EPPContactTransferCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theCommand.getTransId(), svrTransId);
        if (theCommand.getOp().equals("request")) {
            EPPContactTransferResp thePollMsg = new EPPContactTransferResp();
            thePollMsg.setId("example");
            thePollMsg.setTransferStatus("pending");
            thePollMsg.setRequestClient("ClientX");
            thePollMsg.setRequestDate(new Date());
            thePollMsg.setActionClient("ClientY");
            thePollMsg.setActionDate(new Date());
            thePollMsg.setResult(1000);
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:contact-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("doContactTransfer: Error putting message [" + thePollMsg + "]"));
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(theResponse);
            }
        }
        EPPContactTransferResp theResponse = new EPPContactTransferResp(transId, "SH0000", "pending");
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setRequestDate(new Date());
        theResponse.setActionDate(new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doContactCheck(EPPEvent aEvent, Object aData) {
        EPPContactCheckCmd theMessage = (EPPContactCheckCmd)aEvent.getMessage();
        Vector vIds = theMessage.getIds();
        Enumeration eIds = vIds.elements();
        Vector<EPPContactCheckResult> vResults = new Vector<EPPContactCheckResult>();
        boolean available = true;
        while (eIds.hasMoreElements()) {
            String contactId = (String)eIds.nextElement();
            available = !available;
            vResults.addElement(new EPPContactCheckResult(contactId, available));
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPContactCheckResp theResponse = new EPPContactCheckResp(transId, vResults);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }
}

