/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.EPPClientTransIdGenerator;
import com.verisign.epp.pool.EPPSessionPoolException;
import com.verisign.epp.pool.EPPSessionPoolableFactory;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.client.EPPSSLConfig;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.transport.client.EPPSSLImpl;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSystemSessionPool {
    public static final long DEFAULT_ABSOLUTE_TIMEOUT = 86400000L;
    public static final long DEFAULT_IDLE_TIMEOUT = 600000L;
    public static final long DEFAULT_MAX_WAIT = 60000L;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = 60000L;
    public static final int DEFAULT_MAX_IDLE = 10;
    public static final int DEFAULT_MAX_ACTIVE = 10;
    public static final int DEFAULT_MIN_IDLE = 0;
    private static final boolean DEFAULT_INIT_MAX_ACTIVE = false;
    private static final int DEFAULT_BORROW_RETRIES = 0;
    private static final String PROP_PREFIX = "EPP.SessionPool";
    private static Logger log = Logger.getLogger((String)EPPSystemSessionPool.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPSSLContext sslContext = null;
    private GenericObjectPool pool = null;
    private GenericObjectPool.Config config = new GenericObjectPool.Config();
    private EPPSessionPoolableFactory factory = null;
    private boolean initMaxActive = false;
    private int borrowRetries = 0;
    private String clientId;
    private String password;
    private long idleTimeout;
    private long absoluteTimeout;
    private String system;
    private String serverName;
    private Integer serverPort;
    private String clientHost = null;

    EPPSystemSessionPool(String aSystem) {
        this.system = aSystem;
    }

    public void init(EPPSessionPoolableFactory aFactory, GenericObjectPool.Config aConfig) {
        this.pool = new GenericObjectPool((PoolableObjectFactory)aFactory, aConfig);
    }

    public void init() throws EPPSessionPoolException {
        try {
            this.clientId = this.getProperty("clientId");
            if (this.clientId == null) {
                log.error((Object)"EPPSystemSessionPool.init(): clientId not defined");
                throw new EPPSessionPoolException("clientId not defined");
            }
            this.password = this.getProperty("password");
            if (this.password == null) {
                log.error((Object)"EPPSystemSessionPool.init(): password not defined");
                throw new EPPSessionPoolException("password not defined");
            }
            String theValue = this.getProperty("absoluteTimeout");
            this.absoluteTimeout = theValue != null ? Long.parseLong(theValue) : 86400000L;
            log.info((Object)("init(): absolute timeout = " + this.absoluteTimeout + " ms"));
            theValue = this.getProperty("idleTimeout");
            this.idleTimeout = theValue != null ? Long.parseLong(theValue) : 600000L;
            log.info((Object)("init(): idle timeout = " + this.idleTimeout + " ms"));
            theValue = this.getProperty("poolableClassName");
            log.info((Object)("init(): poolable class name = " + theValue));
            try {
                this.factory = (EPPSessionPoolableFactory)Class.forName(theValue).newInstance();
            }
            catch (Exception ex) {
                log.error((Object)("EPPSystemSessionPool.init(): Exception creating instance of class " + theValue + ": " + ex));
                throw new EPPSessionPoolException("Exception creating instance of class " + theValue + ": " + ex);
            }
            theValue = this.getProperty("clientTransIdGenerator");
            log.info((Object)("init(): client trans id generator = " + theValue));
            if (theValue != null) {
                try {
                    this.factory.setClientTransIdGenerator((EPPClientTransIdGenerator)Class.forName(theValue).newInstance());
                }
                catch (Exception ex) {
                    log.error((Object)("EPPSystemSessionPool.init(): Exception creating instance of class " + theValue + ": " + ex));
                    throw new EPPSessionPoolException("Exception creating instance of class " + theValue + ": " + ex);
                }
            }
            this.serverName = this.getProperty("serverName");
            if (this.serverName == null) {
                log.error((Object)"EPPSystemSessionPool.init(): serverName not defined");
                throw new EPPSessionPoolException("serverName not defined");
            }
            log.info((Object)("init(): serverName = " + this.serverName));
            theValue = this.getProperty("serverPort");
            if (theValue != null) {
                this.serverPort = new Integer(theValue);
            }
            log.info((Object)("init(): serverPort = " + this.serverPort));
            this.clientHost = this.getProperty("clientHost");
            log.info((Object)("init(): clientHost = " + this.clientHost));
            this.config.minEvictableIdleTimeMillis = 0L;
            theValue = this.getProperty("maxIdle");
            this.config.maxIdle = theValue != null ? Integer.parseInt(theValue) : 10;
            log.info((Object)("init(): max idle = " + this.config.maxIdle));
            theValue = this.getProperty("maxActive");
            this.config.maxActive = theValue != null ? Integer.parseInt(theValue) : 10;
            log.info((Object)("init(): max active = " + this.config.maxActive));
            theValue = this.getProperty("initMaxActive");
            this.initMaxActive = theValue != null ? Boolean.valueOf(theValue) : false;
            log.info((Object)("init(): init max active = " + this.initMaxActive));
            theValue = this.getProperty("borrowRetries");
            this.borrowRetries = theValue != null ? Integer.parseInt(theValue) : 0;
            log.info((Object)("init(): borrow retries = " + this.borrowRetries));
            theValue = this.getProperty("maxWait");
            this.config.maxWait = theValue != null ? (long)Integer.parseInt(theValue) : 60000L;
            log.info((Object)("init(): max wait = " + this.config.maxWait));
            theValue = this.getProperty("minIdle");
            this.config.minIdle = theValue != null ? Integer.parseInt(theValue) : 0;
            log.info((Object)("init(): min idle = " + this.config.minIdle));
            this.config.numTestsPerEvictionRun = -1;
            this.config.testOnBorrow = false;
            this.config.testOnReturn = false;
            this.config.testWhileIdle = true;
            theValue = this.getProperty("timeBetweenEvictionRunsMillis");
            this.config.timeBetweenEvictionRunsMillis = theValue != null ? Long.parseLong(theValue) : 60000L;
            log.info((Object)("init(): time between eviction runs = " + this.config.timeBetweenEvictionRunsMillis + " ms"));
            this.config.whenExhaustedAction = 1;
        }
        catch (Exception ex) {
            log.error((Object)("EPPSystemSessionPool.init(): Exception referencing Environment property: " + ex));
            throw new EPPSessionPoolException("Exception referencing Environment property: " + ex);
        }
        this.factory.setAbsoluteTimeout(this.absoluteTimeout);
        this.factory.setIdleTimeout(this.idleTimeout);
        this.factory.setClientId(this.clientId);
        this.factory.setPassword(this.password);
        this.factory.setServerName(this.serverName);
        this.factory.setServerPort(this.serverPort);
        this.factory.setClientHost(this.clientHost);
        if (this.getProperty("SSLProtocol") != null) {
            EPPSSLConfig theConfig = new EPPSSLConfig(this.getProperty("SSLProtocol"), this.getProperty("SSLKeyStore"), this.getProperty("SSLKeyFileName"), this.getProperty("SSLPassPhrase"));
            theConfig.setIdentityKeyPassPhrase(this.getProperty("SSLKeyPassPhrase"));
            theConfig.setSslDebug(this.getProperty("SSLDebug"));
            theConfig.setTrustStore(this.getProperty("SSLTrustStore"), this.getProperty("SSLTrustStoreFileName"), this.getProperty("SSLTrustStorePassPhrase"));
            theConfig.setSSLEnabledProtocols(this.getProperty("SSLEnabledProtocols"));
            theConfig.setSSLEnabledCipherSuites(this.getProperty("SSLEnabledCipherSuites"));
            try {
                this.sslContext = EPPSSLImpl.initialize(theConfig);
            }
            catch (EPPConException ex) {
                log.error((Object)("EPPSystemSessionPool.init(): Exception initializing EPPSSLContext: " + ex));
                throw new EPPSessionPoolException("EPPSystemSessionPool.init(): Exception initializing EPPSSLContext: " + ex);
            }
            this.factory.setSSLContext(this.sslContext);
        }
        this.init(this.factory, this.config);
        if (this.initMaxActive && this.config.maxActive > 0) {
            int i;
            log.info((Object)("init(): Pre-initialize maxActive (" + this.config.maxActive + ") sessions"));
            EPPSession[] theSessions = new EPPSession[this.config.maxActive];
            for (i = 0; i < this.config.maxActive; ++i) {
                try {
                    theSessions[i] = this.borrowObject();
                    log.info((Object)("init(): Pre-initialized session #" + (i + 1)));
                    continue;
                }
                catch (EPPSessionPoolException ex) {
                    log.error((Object)("init(): Failure to pre-initialize session #" + (i + 1) + ": " + ex));
                }
            }
            for (i = 0; i < this.config.maxActive; ++i) {
                if (theSessions[i] == null) continue;
                this.returnObject(theSessions[i]);
                theSessions[i] = null;
            }
        }
    }

    public void close() {
        log.info((Object)"close(): closing pool");
        if (this.pool != null) {
            this.pool.clear();
            try {
                this.pool.close();
            }
            catch (Exception ex) {
                log.error((Object)("EPPSystemSessionPool.close(): Exception closing pool <" + this.pool + ">: " + ex));
            }
        }
        log.info((Object)"close(): pool closed");
    }

    public EPPSession borrowObject() throws EPPSessionPoolException {
        if (this.pool == null) {
            log.error((Object)"borrowObject(): pool is null");
            throw new EPPSessionPoolException("EPPSystemSessionPool: pool is null");
        }
        EPPSession theSession = null;
        for (int retries = 0; theSession == null && retries <= this.borrowRetries; ++retries) {
            try {
                theSession = (EPPSession)this.pool.borrowObject();
                log.debug((Object)("borrowObject(): Session = " + theSession + ", Active = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle()));
                continue;
            }
            catch (Exception ex) {
                if (retries >= this.borrowRetries) {
                    log.error((Object)("borrowObject(): Final exception on borrow session after " + retries + " retries: " + ex));
                    throw new EPPSessionPoolException("EPPSystemSessionPool: Exception " + ex);
                }
                log.debug((Object)("borrowObject(): Exception on borrow session after " + retries + " retries: " + ex));
            }
        }
        return theSession;
    }

    public void invalidateObject(EPPSession aSession) throws EPPSessionPoolException {
        try {
            this.pool.invalidateObject((Object)aSession);
            log.debug((Object)("invalidateObject(" + aSession + "): Active = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle()));
        }
        catch (Exception ex) {
            log.error((Object)("invalidateObject(" + aSession + "): Caught Exception: " + ex));
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public void returnObject(EPPSession aSession) throws EPPSessionPoolException {
        try {
            this.pool.returnObject((Object)aSession);
            log.debug((Object)("returnObject(" + aSession + "): Active = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle()));
        }
        catch (Exception ex) {
            log.error((Object)("returnObject(" + aSession + "): Caught Exception: " + ex));
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public GenericObjectPool getGenericObjectPool() {
        return this.pool;
    }

    public long getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public String getClientId() {
        return this.clientId;
    }

    public GenericObjectPool.Config getConfig() {
        return this.config;
    }

    public EPPSessionPoolableFactory getFactory() {
        return this.factory;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSystem() {
        return this.system;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String aServerName) {
        this.serverName = aServerName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer aServerPort) {
        this.serverPort = aServerPort;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String aClientHost) {
        this.clientHost = aClientHost;
    }

    private String getProperty(String aProperty) {
        return Environment.getProperty("EPP.SessionPool." + this.system + "." + aProperty);
    }
}

