/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.reseller.EPPResellerCheckCmd;
import com.verisign.epp.codec.reseller.EPPResellerCreateCmd;
import com.verisign.epp.codec.reseller.EPPResellerDeleteCmd;
import com.verisign.epp.codec.reseller.EPPResellerInfoCmd;
import com.verisign.epp.codec.reseller.EPPResellerMapFactory;
import com.verisign.epp.codec.reseller.EPPResellerUpdateCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public abstract class EPPResellerHandler
implements EPPEventHandler {
    private static final Logger cat = Logger.getLogger((String)EPPResellerHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPResellerHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPResellerMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error((Object)"Couldn't load the Map Factory associated with the Reseller Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:reseller-1.0";
    }

    @Override
    public EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        EPPEventResponse response = null;
        if (message instanceof EPPResellerCheckCmd) {
            response = this.doResellerCheck(aEvent, aData);
        } else if (message instanceof EPPResellerInfoCmd) {
            response = this.doResellerInfo(aEvent, aData);
        } else if (message instanceof EPPResellerCreateCmd) {
            response = this.doResellerCreate(aEvent, aData);
        } else if (message instanceof EPPResellerDeleteCmd) {
            response = this.doResellerDelete(aEvent, aData);
        } else if (message instanceof EPPResellerUpdateCmd) {
            response = this.doResellerUpdate(aEvent, aData);
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected abstract EPPEventResponse doResellerCheck(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doResellerInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doResellerCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doResellerDelete(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doResellerUpdate(EPPEvent var1, Object var2);

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }
}

