/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationMapFactory;
import com.verisign.epp.codec.nv.EPPNameVerificationUpdateCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public abstract class EPPNameVerificationHandler
implements EPPEventHandler {
    private static final Logger cat = Logger.getLogger((String)EPPNameVerificationHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPNameVerificationHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPNameVerificationMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error((Object)"Couldn't load the Map Factory associated with the Name Verification Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    @Override
    public EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        EPPEventResponse response = null;
        if (message instanceof EPPNameVerificationCheckCmd) {
            response = this.doNameVerificationCheck(aEvent, aData);
        } else if (message instanceof EPPNameVerificationInfoCmd) {
            response = this.doNameVerificationInfo(aEvent, aData);
        } else if (message instanceof EPPNameVerificationCreateCmd) {
            response = this.doNameVerificationCreate(aEvent, aData);
        } else if (message instanceof EPPNameVerificationUpdateCmd) {
            response = this.doNameVerificationUpdate(aEvent, aData);
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected abstract EPPEventResponse doNameVerificationCheck(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doNameVerificationInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doNameVerificationCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doNameVerificationUpdate(EPPEvent var1, Object var2);

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }
}

