/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryMinMaxLength;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryContactStreet
extends EPPRegistryMinMaxLength {
    private static final long serialVersionUID = -4168392487627210996L;
    public static final String ELM_NAME = "registry:street";
    public static final String ELM_MIN_ENTRY = "registry:minEntry";
    public static final String ELM_MAX_ENTRY = "registry:maxEntry";
    private Integer minEntry = null;
    private Integer maxEntry = null;

    public EPPRegistryContactStreet() {
        this.rootName = ELM_NAME;
    }

    public EPPRegistryContactStreet(Integer minLength, Integer maxLength, Integer minEntry, Integer maxEntry) {
        this();
        this.min = minLength;
        this.max = maxLength;
        this.minEntry = minEntry;
        this.maxEntry = maxEntry;
    }

    public EPPRegistryContactStreet(int minLength, int maxLength, int minEntry, int maxEntry) {
        this(new Integer(minLength), new Integer(maxLength), new Integer(minEntry), new Integer(maxEntry));
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.minEntry == null || this.minEntry < 0) {
            throw new EPPEncodeException("Invalid state on EPPRegistryContactStreet.encode: minEntry is required and should be greater than or equal to 0");
        }
        if (this.maxEntry == null || this.maxEntry < this.minEntry || this.maxEntry > 3) {
            throw new EPPEncodeException("Invalid state on EPPRegistryContactStreet.encode: maxEntry is required and should be greater than or equal to min, and less than or equal to 3");
        }
        Element root = super.encode(aDocument);
        EPPUtil.encodeString(aDocument, root, this.minEntry.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MIN_ENTRY);
        EPPUtil.encodeString(aDocument, root, this.maxEntry.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MAX_ENTRY);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        super.decode(aElement);
        this.minEntry = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MIN_ENTRY);
        this.maxEntry = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MAX_ENTRY);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryContactStreet)super.clone();
    }

    @Override
    public boolean equals(Object aObject) {
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(aObject instanceof EPPRegistryContactStreet)) {
            return false;
        }
        EPPRegistryContactStreet theComp = (EPPRegistryContactStreet)aObject;
        if (!(this.minEntry != null ? this.minEntry.equals(theComp.minEntry) : theComp.minEntry == null)) {
            return false;
        }
        return this.maxEntry != null ? this.maxEntry.equals(theComp.maxEntry) : theComp.maxEntry == null;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public Integer getMinEntry() {
        return this.minEntry;
    }

    public void setMinEntry(Integer minEntry) {
        this.minEntry = minEntry;
    }

    public Integer getMaxEntry() {
        return this.maxEntry;
    }

    public void setMaxEntry(Integer maxEntry) {
        this.maxEntry = maxEntry;
    }

    @Override
    protected void validateState() throws EPPEncodeException {
        if (this.min == null || this.min < 0) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: min is required and should be greater than or equal to 0");
        }
        if (this.max == null || this.max < this.min) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: max is required and should be greater than or equal to min");
        }
        if (this.max > 255) {
            throw new EPPEncodeException("Invalid state on " + this.getClass().getName() + ".encode: max should be less than or equal to 255");
        }
    }
}

