/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.nv.EPPDomainNameVerification;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResult;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateFailed;
import com.verisign.epp.codec.nv.EPPNameVerificationCreatePending;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateSuccess;
import com.verisign.epp.codec.nv.EPPNameVerificationDocument;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoInputResult;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoResp;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoSignedCodeResult;
import com.verisign.epp.codec.nv.EPPNameVerificationPendActionMsg;
import com.verisign.epp.codec.nv.EPPNameVerificationStatus;
import com.verisign.epp.codec.nv.EPPNameVerificationUpdateCmd;
import com.verisign.epp.codec.nv.EPPRealNameVerification;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCodeValue;
import com.verisign.epp.codec.verificationcode.EPPSignedCode;
import com.verisign.epp.codec.verificationcode.VerificationCodeRevocationList;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.TestThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPNameVerificationTst
extends TestCase {
    private static long numIterations = 1L;
    private static PrivateKey privateKey;
    private static PublicKey publicKey;
    private static PKIXParameters pkixParameters;
    private static VerificationCodeRevocationList verificationCodeRevocationList;
    private static Certificate[] certChain;
    private static final String KEYSTORE_FILENAME = "verificationCode.jks";
    private static final String KEYSTORE_PASSWORD = "changeit";
    private static final String KEYSTORE_KEY_ALIAS = "verificationcode";
    private static final String KEYSTORE_CERT_ALIAS = "0:-1:china:domain~real-name:eppsdk:1";
    private static final String TRUSTSTORE_FILENAME = "verificationCode.jks";

    public EPPNameVerificationTst(String name) {
        super(name);
    }

    private EPPEncodedSignedCodeValue createSignedCode(String aCode, String aType) {
        EPPSignedCode signedCode = null;
        EPPEncodedSignedCodeValue encodedSignedCodeValue = null;
        try {
            signedCode = new EPPSignedCode(aCode, aType);
            signedCode.sign(privateKey, certChain);
            if (!signedCode.validate(publicKey)) {
                Assert.fail((String)"Signed code validation error using public key");
            }
            if (!signedCode.validate(pkixParameters)) {
                Assert.fail((String)"Signed code validation error using PKIX");
            }
            encodedSignedCodeValue = new EPPEncodedSignedCodeValue(signedCode);
        }
        catch (EPPEncodeException e) {
            e.printStackTrace();
            Assert.fail((String)("EPPEncodeException: " + e));
        }
        catch (EPPException e) {
            e.printStackTrace();
            Assert.fail((String)("EPPException: " + e));
        }
        return encodedSignedCodeValue;
    }

    public void testCheckCommand() {
        EPPCodecTst.printStart("testCheckCommand");
        EPPNameVerificationCheckCmd theCommand = new EPPNameVerificationCheckCmd("ABC-12345");
        theCommand.addLabel("example1");
        theCommand.addLabel("example2");
        theCommand.addLabel("example3");
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckCommand");
    }

    public void testCheckResponse() {
        EPPCodecTst.printStart("testCheckResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPNameVerificationCheckResp theResp = new EPPNameVerificationCheckResp(theTransId);
        theResp.addResult(new EPPNameVerificationCheckResult("example1", true));
        theResp.addResult(new EPPNameVerificationCheckResult("example2", false, "In Prohibited Lists."));
        EPPNameVerificationCheckResult theCheckResult = new EPPNameVerificationCheckResult("example3", false);
        theCheckResult.setRestricted(true);
        theResp.addResult(theCheckResult);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCheckResponse");
    }

    public void testInfoCommand() {
        EPPCodecTst.printStart("testInfoCommand");
        EPPNameVerificationInfoCmd theCommand = new EPPNameVerificationInfoCmd("ABC-12345", "1-abc123", EPPNameVerificationInfoCmd.Type.SIGNED_CODE);
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPNameVerificationInfoCmd("ABC-12345", "1-abc123", EPPNameVerificationInfoCmd.Type.INPUT);
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPNameVerificationInfoCmd("ABC-12345", "1-abc123", EPPNameVerificationInfoCmd.Type.SIGNED_CODE, new EPPAuthInfo("2fooBAR"));
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoCommand");
    }

    public void testInfoResponse() {
        EPPCodecTst.printStart("testInfoResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPEncodedSignedCodeValue signedCodeValue = this.createSignedCode("1-abc123", "domain");
        EPPNameVerificationInfoResp theResp = new EPPNameVerificationInfoResp(theTransId, new EPPNameVerificationInfoSignedCodeResult("1-abc123", "domain", signedCodeValue, EPPNameVerificationStatus.COMPLIANT, new EPPAuthInfo("2fooBAR")));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPNameVerificationInfoResp(theTransId, new EPPNameVerificationInfoInputResult(new EPPDomainNameVerification("example"), new EPPAuthInfo("2fooBAR")));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPNameVerificationInfoResp(theTransId, new EPPNameVerificationInfoInputResult(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "John Xie", "1234567890", EPPRealNameVerification.ProofType.POC, new EPPNameVerificationDocument(EPPNameVerificationDocument.FileType.JPG, "EABQRAQAAAAAAAAAAAAAAAAAAAAD")), new EPPAuthInfo("2fooBAR")));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPNameVerificationInfoResp(theTransId, new EPPNameVerificationInfoInputResult(new EPPRealNameVerification(EPPRealNameVerification.Role.ORG, "John Xie", "1234567890", EPPRealNameVerification.ProofType.POE, new EPPNameVerificationDocument(EPPNameVerificationDocument.FileType.JPG, "EABQRAQAAAAAAAAAAAAAAAAAAAAD")), new EPPAuthInfo("2fooBAR")));
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testInfoResponse");
    }

    public void testCreateCommand() {
        EPPCodecTst.printStart("testCreateCommand");
        EPPNameVerificationCreateCmd theCommand = new EPPNameVerificationCreateCmd("ABC-12345", new EPPDomainNameVerification("example"), new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPNameVerificationCreateCmd("ABC-12345", new EPPDomainNameVerification("example", "1-abc123"), new EPPAuthInfo("2fooBAR"));
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPNameVerificationCreateCmd("ABC-12345", new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "John Xie", "1234567890", EPPRealNameVerification.ProofType.POE, new EPPNameVerificationDocument(EPPNameVerificationDocument.FileType.JPG, "EABQRAQAAAAAAAAAAAAAAAAAAAAD")), new EPPAuthInfo("2fooBAR"));
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        theCommand = new EPPNameVerificationCreateCmd("ABC-12345", new EPPRealNameVerification(EPPRealNameVerification.Role.ORG, "John Xie", "1234567890", EPPRealNameVerification.ProofType.POE, new EPPNameVerificationDocument(EPPNameVerificationDocument.FileType.JPG, "EABQRAQAAAAAAAAAAAAAAAAAAAAD")), new EPPAuthInfo("2fooBAR"));
        theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCreateCommand");
    }

    public void testCreateResponse() {
        EPPCodecTst.printStart("testCreateResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPEncodedSignedCodeValue signedCodeValue = this.createSignedCode("1-abc123", "domain");
        EPPNameVerificationCreateResp theResp = new EPPNameVerificationCreateResp(theTransId, new EPPNameVerificationCreateSuccess("1-abc123", "domain", EPPNameVerificationStatus.COMPLIANT, new GregorianCalendar(2015, 8, 17, 22, 0).getTime(), signedCodeValue));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPNameVerificationCreateResp(theTransId, new EPPNameVerificationCreateFailed(EPPNameVerificationStatus.NON_COMPLIANT, "The name of the object is not correct."));
        theResp.setResult(2004);
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        theResp = new EPPNameVerificationCreateResp(theTransId, new EPPNameVerificationCreatePending("1-abc123", "domain", EPPNameVerificationStatus.PENDING_COMPLIANT, new GregorianCalendar(2015, 9, 3, 22, 0).getTime()));
        theResp.setResult(1001);
        theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testCreateResponse");
    }

    public void testUpdateCommand() {
        EPPCodecTst.printStart("testUpdateCommand");
        EPPNameVerificationUpdateCmd theCommand = new EPPNameVerificationUpdateCmd("ABC-12345", "1-abc123", new EPPAuthInfo("2BARfoo"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testUpdateCommand");
    }

    public void testPaPollResponse() {
        EPPCodecTst.printStart("testPaPollResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPNameVerificationPendActionMsg theResp = new EPPNameVerificationPendActionMsg(theTransId, "1-abc123", "domain", EPPNameVerificationStatus.COMPLIANT, "The object has passed verification, signed code was generated.", new GregorianCalendar(2015, 9, 4, 22, 0).getTime());
        theResp.setResult(1301);
        theResp.setMsgQueue(new EPPMsgQueue(new Long("5"), "12345", new GregorianCalendar(2015, 9, 4, 22, 1).getTime(), "Pending action completed successfully."));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theResp);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testPaPollResponse");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPNameVerificationTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            KeyStore.PrivateKeyEntry keyEntry = EPPNameVerificationTst.loadPrivateKeyEntry("verificationCode.jks", KEYSTORE_KEY_ALIAS, KEYSTORE_PASSWORD);
            privateKey = keyEntry.getPrivateKey();
            certChain = keyEntry.getCertificateChain();
            publicKey = EPPNameVerificationTst.loadPublicKey("verificationCode.jks", KEYSTORE_CERT_ALIAS);
            pkixParameters = EPPNameVerificationTst.loadPKIXParameters("verificationCode.jks");
        }
        catch (Exception ex) {
            Assert.fail((String)("Error loading keys for signing and validating: " + ex));
        }
        File verificationCodeRevocationListFile = new File("verification-code-test-revocation.csv");
        if (verificationCodeRevocationListFile.exists()) {
            try {
                FileInputStream smdRevocationListStream = new FileInputStream(verificationCodeRevocationListFile);
                verificationCodeRevocationList.decode(smdRevocationListStream);
                System.out.println("Verification Code Revocation List = [\n" + verificationCodeRevocationList + "]");
            }
            catch (FileNotFoundException e) {
                Assert.fail((String)("Error opening Verification Code Revocation List File: " + e));
            }
            catch (EPPDecodeException e) {
                Assert.fail((String)("Error decoding Verification Code Revocation List File: " + e));
            }
        }
        try {
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.verificationcode.EPPVerificationCodeExtFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.nv.EPPNameVerificationMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPNameVerificationTst Thread " + i, EPPNameVerificationTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPNameVerificationTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public static PKIXParameters loadPKIXParameters(String aTrustStoreName) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream trustStoreFile = new FileInputStream(aTrustStoreName);
        trustStore.load(trustStoreFile, null);
        PKIXParameters pkixParameters = new PKIXParameters(trustStore);
        pkixParameters.setRevocationEnabled(false);
        return pkixParameters;
    }

    private static KeyStore.PrivateKeyEntry loadPrivateKeyEntry(String aKeyStoreName, String aKeyAliasName, String aPassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, aPassword.toCharArray());
        assert (keyStore.isKeyEntry(aKeyAliasName));
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(aKeyAliasName, new KeyStore.PasswordProtection(aPassword.toCharArray()));
        return keyEntry;
    }

    public static PublicKey loadPublicKey(String aKeyStoreName, String aPublicKeyAlias) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, null);
        assert (keyStore.isCertificateEntry(aPublicKeyAlias));
        KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)keyStore.getEntry(aPublicKeyAlias, null);
        return certEntry.getTrustedCertificate().getPublicKey();
    }

    static {
        verificationCodeRevocationList = new VerificationCodeRevocationList();
    }
}

