/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nameWatch;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nameWatch.EPPNameWatchPeriod;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRptTo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameWatchCreateCmd
extends EPPCreateCmd {
    static final String ELM_NAME = "nameWatch:create";
    private static final String ELM_NAMEWATCH_NAME = "nameWatch:name";
    static final String ELM_REGISTRANT = "nameWatch:registrant";
    private static final String ELM_PERIOD = "nameWatch:period";
    private static final int MAX_PERIOD = 99;
    private static final int MIN_PERIOD = 1;
    private String name = null;
    private EPPNameWatchRptTo rptTo = null;
    private EPPNameWatchPeriod period = null;
    private EPPAuthInfo authInfo = null;
    private String registrant = null;

    public EPPNameWatchCreateCmd() {
        this.name = null;
        this.registrant = null;
        this.rptTo = null;
        this.authInfo = null;
        this.period = null;
    }

    public EPPNameWatchCreateCmd(String aTransId, String aName) {
        super(aTransId);
        this.name = aName;
    }

    public EPPNameWatchCreateCmd(String aTransId, String aName, String aRegistrant, EPPNameWatchRptTo aRptTo, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.name = aName;
        this.registrant = aRegistrant;
        this.rptTo = aRptTo;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("http://www.nic.name/epp/nameWatch-1.0", "nameWatch:authInfo");
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/nameWatch-1.0";
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.registrant == null) {
            throw new EPPCodecException("registrant required attribute is not set");
        }
        if (this.rptTo == null) {
            throw new EPPCodecException("rptTo required attribute is not set");
        }
        if (this.authInfo == null) {
            throw new EPPCodecException("authInfo required attribute is not set");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public EPPNameWatchRptTo getRptTo() {
        return this.rptTo;
    }

    public void setRptTo(EPPNameWatchRptTo aRptTo) {
        this.rptTo = aRptTo;
    }

    public EPPNameWatchPeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPNameWatchPeriod newPeriod) {
        this.period = newPeriod;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameWatchCreateCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPNameWatchCreateCmd theComp = (EPPNameWatchCreateCmd)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        if (!(this.registrant != null ? this.registrant.equals(theComp.registrant) : theComp.registrant == null)) {
            return false;
        }
        if (!(this.rptTo != null ? this.rptTo.equals(theComp.rptTo) : theComp.rptTo == null)) {
            return false;
        }
        if (!(this.period != null ? this.period.equals(theComp.period) : theComp.period == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameWatchCreateCmd clone = (EPPNameWatchCreateCmd)super.clone();
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.rptTo != null) {
            clone.rptTo = (EPPNameWatchRptTo)this.rptTo.clone();
        }
        if (this.period != null) {
            clone.period = (EPPNameWatchPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("http://www.nic.name/epp/nameWatch-1.0", "nameWatch:authInfo");
        }
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPNameWatchCreateCmd.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/nameWatch-1.0", ELM_NAME);
        root.setAttribute("xmlns:nameWatch", "http://www.nic.name/epp/nameWatch-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.nic.name/epp/nameWatch-1.0 nameWatch-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.nic.name/epp/nameWatch-1.0", ELM_NAMEWATCH_NAME);
        EPPUtil.encodeString(aDocument, root, this.registrant, "http://www.nic.name/epp/nameWatch-1.0", ELM_REGISTRANT);
        if (!this.rptTo.isRptToUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.rptTo);
        }
        if (this.period != null && !this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/nameWatch-1.0", ELM_NAMEWATCH_NAME);
        this.registrant = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/nameWatch-1.0", ELM_REGISTRANT);
        this.rptTo = (EPPNameWatchRptTo)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/nameWatch-1.0", "nameWatch:rptTo", EPPNameWatchRptTo.class);
        this.period = (EPPNameWatchPeriod)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/nameWatch-1.0", ELM_PERIOD, EPPNameWatchPeriod.class);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/nameWatch-1.0", "nameWatch:authInfo", EPPAuthInfo.class);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPNameWatchCreateCmd.decode: " + e);
        }
    }
}

