/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.idntable;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.idntable.EPPIdnTableInfoDomainTable;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPIdnTableInfoDomain
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPIdnTableInfoDomain.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "domain";
    public static final String ELM_NAME = "idnTable:domain";
    private static final String ELM_DOMAIN_NAME = "name";
    private static final String ELM_ANAME = "aname";
    private static final String ELM_UNAME = "uname";
    private static final String ATTR_VALID = "valid";
    private static final String ATTR_IDNMAP = "idnmap";
    private String name;
    private String aname;
    private String uname;
    private boolean valid;
    private boolean idnmap = true;
    private List<EPPIdnTableInfoDomainTable> tables = new ArrayList<EPPIdnTableInfoDomainTable>();

    public EPPIdnTableInfoDomain() {
    }

    public EPPIdnTableInfoDomain(String aName, boolean aValid) {
        this.setName(aName);
        this.setValid(aValid);
    }

    public EPPIdnTableInfoDomain(String aName, boolean aValid, boolean aIdnmap) {
        this.setName(aName);
        this.setValid(aValid);
        this.setIdnmap(aIdnmap);
    }

    public EPPIdnTableInfoDomain(String aName, List<EPPIdnTableInfoDomainTable> aTables) {
        this.setName(aName);
        this.setValid(true);
        this.setTables(aTables);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aDomain) {
        this.name = aDomain;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean aValid) {
        this.valid = aValid;
    }

    public boolean isIdnmap() {
        return this.idnmap;
    }

    public void setIdnmap(boolean aIdnmap) {
        this.idnmap = aIdnmap;
    }

    public boolean hasAname() {
        return this.aname != null;
    }

    public String getAname() {
        return this.aname;
    }

    public void setAname(String aDomain) {
        this.aname = aDomain;
    }

    public boolean hasUname() {
        return this.uname != null;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String aDomain) {
        this.uname = aDomain;
    }

    public boolean hasTables() {
        return this.tables != null && !this.tables.isEmpty();
    }

    public List<EPPIdnTableInfoDomainTable> getTables() {
        return this.tables;
    }

    public void setTables(List<EPPIdnTableInfoDomainTable> aTables) {
        this.tables = aTables;
    }

    public void setTable(EPPIdnTableInfoDomainTable aTable) {
        this.tables = new ArrayList<EPPIdnTableInfoDomainTable>();
        this.tables.add(aTable);
    }

    public void addTable(EPPIdnTableInfoDomainTable aTable) {
        this.tables.add(aTable);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("Undefined name in EPPIdnTableInfoDomain");
        }
        if (this.hasAname() && this.hasUname()) {
            throw new EPPEncodeException("Both aname and uname can be set in EPPIdnTableInfoDomain");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", ELM_NAME);
        Element theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:name");
        theElm.appendChild(aDocument.createTextNode(this.name));
        EPPUtil.encodeBooleanAttr(theElm, ATTR_VALID, this.valid);
        EPPUtil.encodeBooleanAttr(theElm, ATTR_IDNMAP, this.idnmap);
        root.appendChild(theElm);
        EPPUtil.encodeString(aDocument, root, this.aname, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:aname");
        EPPUtil.encodeString(aDocument, root, this.uname, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:uname");
        EPPUtil.encodeCompList(aDocument, root, this.tables);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_DOMAIN_NAME);
        if (theNameElm != null) {
            Node textNode = theNameElm.getFirstChild();
            this.name = textNode != null ? textNode.getNodeValue() : null;
            this.valid = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_VALID);
            try {
                this.idnmap = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_IDNMAP);
            }
            catch (EPPDecodeException ex) {
                cat.debug((Object)"EPPIdnTableInfoDomain.decode(): idnmap attribute undefined, setting to default of true.");
                this.idnmap = true;
            }
        }
        this.aname = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_ANAME);
        this.uname = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", ELM_UNAME);
        this.tables = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:idnTable-1.0", "idnTable:table", EPPIdnTableInfoDomainTable.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPIdnTableInfoDomain clone = (EPPIdnTableInfoDomain)super.clone();
        clone.tables = (List)((ArrayList)this.tables).clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPIdnTableInfoDomain)) {
            return false;
        }
        EPPIdnTableInfoDomain other = (EPPIdnTableInfoDomain)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPIdnTableInfoDomain.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.valid, other.valid)) {
            cat.error((Object)"EPPIdnTableInfoDomain.equals(): valid not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.idnmap, other.idnmap)) {
            cat.error((Object)"EPPIdnTableInfoDomain.equals(): idnmap not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.aname, other.aname)) {
            cat.error((Object)"EPPIdnTableInfoDomain.equals(): aname not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.uname, other.uname)) {
            cat.error((Object)"EPPIdnTableInfoDomain.equals(): uname not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.tables, other.tables)) {
            cat.error((Object)"EPPIdnTableInfoDomain.equals(): tables not equal");
            return false;
        }
        return true;
    }
}

