/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v11;

import com.verisign.epp.codec.fee.v11.EPPFeeCommand;
import com.verisign.epp.codec.fee.v11.EPPFeeCredit;
import com.verisign.epp.codec.fee.v11.EPPFeePeriod;
import com.verisign.epp.codec.fee.v11.EPPFeeValue;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPFeeObjectResult
implements EPPCodecComponent {
    public static final String ELM_LOCALNAME = "cd";
    public static final String ELM_NAME = "fee:cd";
    private static Logger cat = Logger.getLogger((String)EPPFeeObjectResult.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ELM_OBJECT = "object";
    private static final String ELM_CURRENCY = "currency";
    private static final String ELM_CLASSIFICATION = "class";
    private static final String ELM_REASON = "reason";
    private static final String ATTR_AVAIL = "avail";
    private String objXmlNs;
    private String objXmlName;
    private String objID;
    private boolean available;
    private String currency;
    private EPPFeeCommand command;
    private EPPFeePeriod period;
    private List<EPPFeeValue> fees = new ArrayList<EPPFeeValue>();
    private List<EPPFeeCredit> credits = new ArrayList<EPPFeeCredit>();
    private String classification;
    private String reason;

    public EPPFeeObjectResult() {
    }

    public EPPFeeObjectResult(String aObjXMLNs, String aObjectXMLName, String aObjID, String aCurrency, EPPFeeCommand aCommand) {
        this.setObjXmlNs(aObjXMLNs);
        this.setObjXmlName(aObjectXMLName);
        this.setObjID(aObjID);
        this.setAvailable(true);
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
    }

    public EPPFeeObjectResult(String aObjXMLNs, String aObjectXMLName, String aObjID, String aCurrency, EPPFeeCommand aCommand, String aReason) {
        this.setObjXmlNs(aObjXMLNs);
        this.setObjXmlName(aObjectXMLName);
        this.setObjID(aObjID);
        this.setAvailable(false);
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setReason(aReason);
    }

    public EPPFeeObjectResult(String aObjXMLNs, String aObjectXMLName, String aObjID, String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod, EPPFeeValue aFee) {
        this.setObjXmlNs(aObjXMLNs);
        this.setObjXmlName(aObjectXMLName);
        this.setObjID(aObjID);
        this.setAvailable(true);
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
        this.addFee(aFee);
    }

    public EPPFeeObjectResult(String aObjXMLNs, String aObjectXMLName, String aObjID, String aCurrency, EPPFeeCommand aCommand, EPPFeePeriod aPeriod, List<EPPFeeValue> aFees, List<EPPFeeCredit> aCredits, String aClassification) {
        this.setObjXmlNs(aObjXMLNs);
        this.setObjXmlName(aObjectXMLName);
        this.setObjID(aObjID);
        this.setAvailable(true);
        this.setCurrency(aCurrency);
        this.setCommand(aCommand);
        this.setPeriod(aPeriod);
        this.setFees(aFees);
        this.setCredits(aCredits);
        this.setClassification(aClassification);
    }

    public String getObjXmlNs() {
        return this.objXmlNs;
    }

    public void setObjXmlNs(String aObjXmlNs) {
        this.objXmlNs = aObjXmlNs;
    }

    public String getObjXmlName() {
        return this.objXmlName;
    }

    public void setObjXmlName(String aObjXmlName) {
        this.objXmlName = aObjXmlName;
    }

    public String getObjID() {
        return this.objID;
    }

    public void setObjID(String aObjID) {
        this.objID = aObjID;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean aAvailable) {
        this.available = aAvailable;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public EPPFeeCommand getCommand() {
        return this.command;
    }

    public void setCommand(EPPFeeCommand aCommand) {
        this.command = aCommand;
    }

    public boolean hasPeriod() {
        return this.period != null;
    }

    public EPPFeePeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPFeePeriod aPeriod) {
        this.period = aPeriod;
    }

    public boolean hasFees() {
        return !this.fees.isEmpty();
    }

    public List<EPPFeeValue> getFees() {
        return this.fees;
    }

    public void addFee(EPPFeeValue aFee) {
        if (aFee == null) {
            return;
        }
        this.fees.add(aFee);
    }

    public void setFees(List<EPPFeeValue> aFees) {
        this.fees = aFees == null ? new ArrayList<EPPFeeValue>() : aFees;
    }

    public boolean hasCredits() {
        return !this.credits.isEmpty();
    }

    public List<EPPFeeCredit> getCredits() {
        return this.credits;
    }

    public void addCredit(EPPFeeCredit aCredit) {
        if (aCredit == null) {
            return;
        }
        this.credits.add(aCredit);
    }

    public void setCredits(List<EPPFeeCredit> aCredits) {
        this.credits = aCredits == null ? new ArrayList<EPPFeeCredit>() : aCredits;
    }

    public boolean hasClassification() {
        return this.classification != null;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String aClassification) {
        this.classification = aClassification;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String aReason) {
        this.reason = aReason;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPFeeObjectResult.encode(Document)");
        }
        if (this.objXmlNs == null) {
            throw new EPPEncodeException("Required objXmlNs attribute is null in EPPFeeObjectResult.encode(Document).");
        }
        if (this.objXmlName == null) {
            throw new EPPEncodeException("Required objXmlName attribute is null in EPPFeeObjectResult.encode(Document).");
        }
        if (this.objID == null) {
            throw new EPPEncodeException("Required objID attribute is null in EPPFeeObjectResult.encode(Document).");
        }
        if (this.currency == null) {
            throw new EPPEncodeException("Required currency attribute is null in EPPFeeObjectResult.encode(Document).");
        }
        if (this.command == null) {
            throw new EPPEncodeException("Required command attribute is null in EPPFeeObjectResult.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.11", ELM_NAME);
        EPPUtil.encodeBooleanAttr(root, ATTR_AVAIL, this.available);
        Element theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.11", "fee:object");
        Element theObjectElm = aDocument.createElementNS(this.objXmlNs, this.objXmlName);
        Text theVal = aDocument.createTextNode(this.objID);
        theObjectElm.appendChild(theVal);
        theElm.appendChild(theObjectElm);
        root.appendChild(theElm);
        EPPUtil.encodeComp(aDocument, root, this.command);
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.11", "fee:currency");
        EPPUtil.encodeComp(aDocument, root, this.period);
        EPPUtil.encodeCompList(aDocument, root, this.fees);
        EPPUtil.encodeCompList(aDocument, root, this.credits);
        EPPUtil.encodeString(aDocument, root, this.classification, "urn:ietf:params:xml:ns:fee-0.11", "fee:class");
        EPPUtil.encodeString(aDocument, root, this.reason, "urn:ietf:params:xml:ns:fee-0.11", "fee:reason");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theObjectElm;
        this.available = EPPUtil.decodeBooleanAttr(aElement, ATTR_AVAIL);
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:fee-0.11", ELM_OBJECT);
        if (theElm != null && (theObjectElm = EPPUtil.getFirstElementChild(theElm)) != null) {
            this.objXmlNs = theObjectElm.getNamespaceURI();
            this.objXmlName = theObjectElm.getNodeName();
            this.objID = EPPUtil.decodeStringValue(theObjectElm);
        }
        this.command = (EPPFeeCommand)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.11", "fee:command", EPPFeeCommand.class);
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.11", ELM_CURRENCY);
        this.period = (EPPFeePeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:fee-0.11", "fee:period", EPPFeePeriod.class);
        this.fees = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.11", "fee", EPPFeeValue.class);
        this.credits = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.11", "credit", EPPFeeCredit.class);
        this.classification = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.11", ELM_CLASSIFICATION);
        this.reason = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.11", ELM_REASON);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeObjectResult clone = (EPPFeeObjectResult)super.clone();
        clone.available = this.available;
        clone.objXmlNs = this.objXmlNs;
        clone.objXmlName = this.objXmlName;
        clone.objID = this.objID;
        clone.currency = this.currency;
        clone.command = (EPPFeeCommand)this.command.clone();
        if (this.period != null) {
            clone.period = (EPPFeePeriod)this.period.clone();
        }
        clone.fees = new ArrayList<EPPFeeValue>();
        for (EPPFeeValue fee : this.fees) {
            clone.fees.add((EPPFeeValue)fee.clone());
        }
        clone.credits = new ArrayList<EPPFeeCredit>();
        for (EPPFeeCredit credit : this.credits) {
            clone.credits.add((EPPFeeCredit)credit.clone());
        }
        clone.classification = this.classification;
        clone.reason = this.reason;
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeObjectResult)) {
            cat.error((Object)("EPPFeeObjectResult.equals(): " + aObject.getClass().getName() + " not EPPFeeObjectResult instance"));
            return false;
        }
        EPPFeeObjectResult other = (EPPFeeObjectResult)aObject;
        if (!EqualityUtil.equals(this.available, other.available)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): available not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.objXmlNs, other.objXmlNs)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): objXmlNs not equal");
            return false;
        }
        if (!EqualityUtil.equals(EPPUtil.getLocalName(this.objXmlName), EPPUtil.getLocalName(other.objXmlName))) {
            cat.error((Object)("EPPFeeObjectResult.equals(): local XML Name (" + EPPUtil.getLocalName(this.objXmlName) + ", " + EPPUtil.getLocalName(other.objXmlName) + ") not equal"));
            return false;
        }
        if (!EqualityUtil.equals(this.objID, other.objID)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): objID not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.command, other.command)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): command not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.period, other.period)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): period not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fees, other.fees)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): fees not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.credits, other.credits)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): credits not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.classification, other.classification)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): classification not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.reason, other.reason)) {
            cat.error((Object)"EPPFeeObjectResult.equals(): reason not equal");
            return false;
        }
        return true;
    }
}

