/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactAddChange;
import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCheckCmd;
import com.verisign.epp.codec.contact.EPPContactCheckResp;
import com.verisign.epp.codec.contact.EPPContactCheckResult;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactCreateResp;
import com.verisign.epp.codec.contact.EPPContactDeleteCmd;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactDiscloseAddress;
import com.verisign.epp.codec.contact.EPPContactDiscloseName;
import com.verisign.epp.codec.contact.EPPContactDiscloseOrg;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactStatus;
import com.verisign.epp.codec.contact.EPPContactTransferCmd;
import com.verisign.epp.codec.contact.EPPContactTransferResp;
import com.verisign.epp.codec.contact.EPPContactTst;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPContactRelaxedValidationTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPContactRelaxedValidationTst(String name) {
        super(name);
    }

    public void testMinimumContactCreateWithRelaxedValidations() {
        EPPCodecTst.printStart("testMinimumContactCreateWithRelaxedValidations");
        EPPContactPostalDefinition contactPostalDefintion = new EPPContactPostalDefinition(null, null, "loc", null);
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd("ABC-12345", "test-20161208-01", contactPostalDefintion, null, new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactCreateResp theResponse = new EPPContactCreateResp(respTransId, "sh8013", new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testMinimumContactCreateWithRelaxedValidations");
    }

    public void testContactCreateWithPartialOptionalElementsForRelaxedValidations() {
        EPPCodecTst.printStart("testContactCreateWithPartialOptionalElementsForRelaxedValidations");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(null, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition contactPostalDefinition = new EPPContactPostalDefinition("John Doe", "Example Inc.", "int", address);
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd("ABC-12345", "sh8013", contactPostalDefinition, "jdoe@example.com", new EPPAuthInfo("2fooBAR"));
        theCommand.setFax("+1.7035555556");
        theCommand.setVoice("+1.7035555555");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactCreateResp theResponse = new EPPContactCreateResp(respTransId, "sh8013", new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactCreateWithPartialOptionalElementsForRelaxedValidations");
    }

    public void testContactCreateWithAllOptionalElementsForRelaxedValidations() {
        EPPCodecTst.printStart("testContactCreateWithAllOptionalElementsForRelaxedValidations");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(null, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition contactPostalDefinition = new EPPContactPostalDefinition("John Doe", "Example Inc.", "int", address);
        Vector<String> i15dStreets = new Vector<String>();
        i15dStreets.addElement("i15d 123 Example Dr.");
        i15dStreets.addElement("i15d Suite 100");
        EPPContactAddress i15dAddress = new EPPContactAddress(i15dStreets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition localContactPostalDefinition = new EPPContactPostalDefinition("i15d John Doe", "i15d Example Inc.", "loc", i15dAddress);
        Vector<EPPContactPostalDefinition> postalDefinitions = new Vector<EPPContactPostalDefinition>();
        postalDefinitions.add(contactPostalDefinition);
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd("ABC-12345", "sh8013", localContactPostalDefinition, "jdoe@example.com", new EPPAuthInfo("2fooBAR"));
        theCommand.setFax("+1.7035555556");
        theCommand.setFaxExt("123");
        theCommand.setVoice("+1.7035555555");
        theCommand.setVoiceExt("456");
        theCommand.setPostalInfo(postalDefinitions);
        Vector<EPPContactDiscloseName> contactDiscloseName = new Vector<EPPContactDiscloseName>();
        contactDiscloseName.addElement(new EPPContactDiscloseName("int"));
        Vector<EPPContactDiscloseOrg> orgs = new Vector<EPPContactDiscloseOrg>();
        orgs.addElement(new EPPContactDiscloseOrg("loc"));
        orgs.addElement(new EPPContactDiscloseOrg("int"));
        Vector<EPPContactDiscloseAddress> addresses = new Vector<EPPContactDiscloseAddress>();
        addresses.addElement(new EPPContactDiscloseAddress("loc"));
        addresses.addElement(new EPPContactDiscloseAddress("int"));
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag("0");
        disclose.setNames(contactDiscloseName);
        disclose.setOrgs(orgs);
        disclose.setAddresses(addresses);
        disclose.setVoice("");
        disclose.setFax("");
        disclose.setEmail("");
        theCommand.setDisclose(disclose);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactCreateResp theResponse = new EPPContactCreateResp(respTransId, "sh8013", new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactCreateWithAllOptionalElementsForRelaxedValidations");
    }

    public void testContactInfoWithRelaxedValidation() {
        EPPCodecTst.printStart("testContactInfoWithRelaxedValidation");
        EPPContactInfoCmd theCommand = new EPPContactInfoCmd("ABC-12345", "sh8013");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPContactPostalDefinition contactPostalDefintion = new EPPContactPostalDefinition(null, null, "loc", null);
        EPPContactPostalDefinition internationContactPostalDefintion = new EPPContactPostalDefinition(null, null, "int", null);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("linked"));
        infoStatuses.addElement(new EPPContactStatus("clientUpdateProhibited"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactInfoResp theResponse = new EPPContactInfoResp(respTransId, "SH8013-VRSN", "sh8013", infoStatuses, contactPostalDefintion, null, "ClientY", "ClientX", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.addPostalInfo(internationContactPostalDefintion);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastUpdatedDate(new Date());
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactInfoWithRelaxedValidation");
    }

    public void testContactPartialInfoWithRelaxedValidation() {
        EPPCodecTst.printStart("testContactPartialInfoWithRelaxedValidation");
        EPPContactInfoCmd theCommand = new EPPContactInfoCmd("ABC-12345", "sh8013");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "loc", address);
        Vector<String> i15dStreets = new Vector<String>();
        i15dStreets.addElement("i15d 123 Example Dr.");
        EPPContactAddress i15dAddress = new EPPContactAddress(i15dStreets, null, "VA", "20166-6503", null);
        EPPContactPostalDefinition i15dName = new EPPContactPostalDefinition("i15d John Doe", "i15d Example Inc.", "int", i15dAddress);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("linked"));
        infoStatuses.addElement(new EPPContactStatus("clientUpdateProhibited"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactInfoResp theResponse = new EPPContactInfoResp(respTransId, "SH8013-VRSN", "sh8013", infoStatuses, name, "jdoe@example.com", "ClientY", "ClientX", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setFax("+1.7035555556");
        theResponse.addPostalInfo(i15dName);
        Vector<EPPContactDiscloseName> names = new Vector<EPPContactDiscloseName>();
        names.addElement(new EPPContactDiscloseName("int"));
        Vector<EPPContactDiscloseOrg> orgs = new Vector<EPPContactDiscloseOrg>();
        orgs.addElement(new EPPContactDiscloseOrg("loc"));
        orgs.addElement(new EPPContactDiscloseOrg("int"));
        Vector<EPPContactDiscloseAddress> addresses = new Vector<EPPContactDiscloseAddress>();
        addresses.addElement(new EPPContactDiscloseAddress("loc"));
        addresses.addElement(new EPPContactDiscloseAddress("int"));
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag("1");
        disclose.setNames(names);
        disclose.setOrgs(orgs);
        disclose.setAddresses(addresses);
        disclose.setVoice("");
        disclose.setFax("");
        disclose.setEmail("");
        theResponse.setDisclose(disclose);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastUpdatedDate(new Date());
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactPartialInfoWithRelaxedValidation");
    }

    public void testContactFullInfoWithRelaxedValidations() {
        EPPCodecTst.printStart("testContactFullInfoWithRelaxedValidations");
        EPPContactInfoCmd theCommand = new EPPContactInfoCmd("ABC-12345", "sh8013");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "loc", address);
        Vector<String> i15dStreets = new Vector<String>();
        i15dStreets.addElement("i15d 123 Example Dr.");
        i15dStreets.addElement("i15d Suite 100");
        EPPContactAddress i15dAddress = new EPPContactAddress(i15dStreets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition i15dName = new EPPContactPostalDefinition("i15d John Doe", "i15d Example Inc.", "int", i15dAddress);
        Vector<EPPContactStatus> infoStatuses = new Vector<EPPContactStatus>();
        infoStatuses.addElement(new EPPContactStatus("linked"));
        infoStatuses.addElement(new EPPContactStatus("clientUpdateProhibited"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactInfoResp theResponse = new EPPContactInfoResp(respTransId, "SH8013-VRSN", "sh8013", infoStatuses, name, "jdoe@example.com", "ClientY", "ClientX", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setVoice("+1.7035555555");
        theResponse.setVoiceExt("123");
        theResponse.setFax("+1.7035555556");
        theResponse.setFaxExt("456");
        theResponse.addPostalInfo(i15dName);
        Vector<EPPContactDiscloseName> names = new Vector<EPPContactDiscloseName>();
        names.addElement(new EPPContactDiscloseName("int"));
        Vector<EPPContactDiscloseOrg> orgs = new Vector<EPPContactDiscloseOrg>();
        orgs.addElement(new EPPContactDiscloseOrg("loc"));
        orgs.addElement(new EPPContactDiscloseOrg("int"));
        Vector<EPPContactDiscloseAddress> addresses = new Vector<EPPContactDiscloseAddress>();
        addresses.addElement(new EPPContactDiscloseAddress("loc"));
        addresses.addElement(new EPPContactDiscloseAddress("int"));
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag("1");
        disclose.setNames(names);
        disclose.setOrgs(orgs);
        disclose.setAddresses(addresses);
        disclose.setVoice("");
        disclose.setFax("");
        disclose.setEmail("");
        theResponse.setDisclose(disclose);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastUpdatedDate(new Date());
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactFullInfoWithRelaxedValidations");
    }

    public void testContactDelete() {
        EPPCodecTst.printStart("testContactDelete");
        EPPContactDeleteCmd theCommand = new EPPContactDeleteCmd("ABC-12345", "sh8013");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactDelete");
    }

    public void testContactCheck() {
        EPPCodecTst.printStart("testContactCheck");
        EPPContactCheckCmd theCommand = new EPPContactCheckCmd("ABC-12345", "sh8013");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> contacts = new Vector<String>();
        contacts.addElement("sh8013");
        contacts.addElement("sah8013");
        contacts.addElement("8013sah");
        theCommand = new EPPContactCheckCmd("ABC-12345", contacts);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactCheckResp theResponse = new EPPContactCheckResp(respTransId, new EPPContactCheckResult("sh8013", true));
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        Vector<EPPContactCheckResult> contactResults = new Vector<EPPContactCheckResult>();
        contactResults.addElement(new EPPContactCheckResult("sh8013", true));
        EPPContactCheckResult contactResult = new EPPContactCheckResult("sah8013", false);
        contactResult.setContactReason("In Use");
        contactResults.addElement(contactResult);
        contactResults.addElement(new EPPContactCheckResult("8013sah", true));
        theResponse = new EPPContactCheckResp(respTransId, contactResults);
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactCheck");
    }

    public void testContactUpdate() {
        EPPContactUpdateCmd theCommand = null;
        EPPEncodeDecodeStats commandStats = null;
        EPPCodecTst.printStart("testContactUpate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John", "loc", address);
        EPPContactAddChange change = new EPPContactAddChange(name, "+1.7034444444", new EPPAuthInfo("2BARfoo"));
        change.setVoiceExt("678");
        change.setFax("+1.7037777777");
        change.setFaxExt("678");
        Vector<EPPContactDiscloseName> names = new Vector<EPPContactDiscloseName>();
        names.addElement(new EPPContactDiscloseName("int"));
        Vector<EPPContactDiscloseOrg> orgs = new Vector<EPPContactDiscloseOrg>();
        orgs.addElement(new EPPContactDiscloseOrg("loc"));
        orgs.addElement(new EPPContactDiscloseOrg("int"));
        Vector<EPPContactDiscloseAddress> addresses = new Vector<EPPContactDiscloseAddress>();
        addresses.addElement(new EPPContactDiscloseAddress("loc"));
        addresses.addElement(new EPPContactDiscloseAddress("int"));
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag("0");
        disclose.setNames(names);
        disclose.setOrgs(orgs);
        disclose.setAddresses(addresses);
        disclose.setVoice("");
        disclose.setFax("");
        disclose.setEmail("");
        change.setDisclose(disclose);
        Vector<EPPContactStatus> addStatuses = new Vector<EPPContactStatus>();
        addStatuses.addElement(new EPPContactStatus("clientDeleteProhibited"));
        addStatuses.addElement(new EPPContactStatus("clientDeleteProhibited", "Hello World", "en"));
        EPPContactAddChange add = new EPPContactAddChange(addStatuses);
        theCommand = new EPPContactUpdateCmd("ABC-12345", "sh8013", add, null, change);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testContactUpate");
    }

    public void testContactTransfer() {
        EPPCodecTst.printStart("testContactTransfer");
        EPPContactTransferCmd theCommand = new EPPContactTransferCmd("ABC-12345", "request", "sh8013");
        theCommand.setAuthInfo(new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPContactTransferResp theResponse = new EPPContactTransferResp(respTransId, "SH0000", "pending");
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setRequestDate(new Date());
        theResponse.setActionDate(new Date());
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPContactTransferCmd("ABC-12345", "cancel", "sh8013");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPContactTransferCmd("ABC-12345", "query", "sh8013");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPContactTransferCmd("ABC-12345", "reject", "sh8013");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        theCommand = new EPPContactTransferCmd("ABC-12345", "approve", "sh8013");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactTransfer");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        Environment.setProperty("EPP.Contact.RelaxedValidation", "true");
        TestSuite suite = new TestSuite(EPPContactRelaxedValidationTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.contact.EPPContactMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPContactMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPContactTst Thread " + i, EPPContactTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPContactTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

