/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EqualityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactPostalDefinition
implements EPPCodecComponent {
    public static final String ELM_NAME_POSTAL_INFO = "contact:postalInfo";
    private static final String ELM_ORG = "contact:org";
    private static final String ELM_CONTACT_NAME = "contact:name";
    private static final String ATTR_TYPE = "type";
    public static final String ATTR_TYPE_LOC = "loc";
    public static final String ATTR_TYPE_INT = "int";
    private String rootName = "contact:postalInfo";
    private String type = "int";
    private String name = null;
    private String org = null;
    private EPPContactAddress address = null;
    private boolean validatedFlag = true;

    public EPPContactPostalDefinition() {
    }

    public EPPContactPostalDefinition(String aType) {
        this.type = aType;
    }

    public EPPContactPostalDefinition(String aType, EPPContactAddress aAddress) {
        this.type = aType;
        this.address = aAddress;
    }

    public EPPContactPostalDefinition(String aName, String aType, EPPContactAddress aAddress) {
        this.name = aName;
        this.type = aType;
        this.address = aAddress;
    }

    public EPPContactPostalDefinition(String aName, String aOrg, String aType, EPPContactAddress aAddress) {
        this.name = aName;
        this.org = aOrg;
        this.type = aType;
        this.address = aAddress;
    }

    public String getOrg() {
        return this.org;
    }

    public boolean hasOrg() {
        return this.org != null;
    }

    public void setOrg(String aOrg) {
        this.org = aOrg;
    }

    public EPPContactAddress getAddress() {
        return this.address;
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public void setAddress(EPPContactAddress aAddress) {
        this.address = aAddress;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.validatedFlag) {
            try {
                if (EPPEnv.isContactRelaxedValidation()) {
                    this.relaxedValidateState();
                } else {
                    this.validateState();
                }
            }
            catch (EPPCodecException e) {
                throw new EPPEncodeException("Invalid state on EPPContactPostalDefination.encode: " + e);
            }
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", this.rootName);
        root.setAttribute(ATTR_TYPE, this.type);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_NAME);
        EPPUtil.encodeString(aDocument, root, this.org, "urn:ietf:params:xml:ns:contact-1.0", ELM_ORG);
        if (this.hasAddress()) {
            EPPUtil.encodeComp(aDocument, root, this.address);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_NAME);
        this.org = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_ORG);
        this.type = aElement.getAttribute(ATTR_TYPE);
        this.address = (EPPContactAddress)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", "contact:addr", EPPContactAddress.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactPostalDefinition)) {
            return false;
        }
        EPPContactPostalDefinition theComp = (EPPContactPostalDefinition)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            return false;
        }
        if (!EqualityUtil.equals(this.org, theComp.org)) {
            return false;
        }
        if (!EqualityUtil.equals(this.type, theComp.type)) {
            return false;
        }
        return EqualityUtil.equals(this.address, theComp.address);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPContactPostalDefinition clone = (EPPContactPostalDefinition)super.clone();
        if (this.hasAddress()) {
            clone.address = (EPPContactAddress)this.address.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    private void validateState() throws EPPCodecException {
        if (!this.hasRootName()) {
            throw new EPPCodecException("root element name is not set");
        }
        if (!this.rootName.equals(ELM_NAME_POSTAL_INFO)) {
            throw new EPPCodecException("root element name is not recognized");
        }
        if (!this.hasName()) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (!this.hasType()) {
            throw new EPPCodecException("required attribute type is not set");
        }
        if (!this.hasAddress()) {
            throw new EPPCodecException("address required attribute is not set");
        }
    }

    private void relaxedValidateState() throws EPPCodecException {
        if (!this.hasRootName()) {
            throw new EPPCodecException("root element name is not set");
        }
        if (!this.rootName.equals(ELM_NAME_POSTAL_INFO)) {
            throw new EPPCodecException("root element name is not recognized");
        }
        if (!this.hasType()) {
            throw new EPPCodecException("required attribute type is not set");
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getRootName() {
        return this.rootName;
    }

    public boolean hasRootName() {
        return this.rootName != null;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setRootName(String newRootName) {
        this.rootName = newRootName;
    }

    public boolean isValidated() {
        return this.validatedFlag;
    }

    public void setValidatedFlag(boolean newValidatedFlag) {
        this.validatedFlag = newValidatedFlag;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public void setType(String newType) {
        this.type = newType;
    }
}

