/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirror;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class JUnitTestRunner
implements TestListener,
JUnitTaskMirror.JUnitTestRunnerMirror {
    private Vector formatters = new Vector();
    private TestResult res;
    private static boolean filtertrace = true;
    private boolean showOutput = false;
    private boolean outputToFormatters = true;
    private Permissions perm = null;
    private static final String[] DEFAULT_TRACE_FILTERS = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "java.lang.reflect.Method.invoke(", "sun.reflect.", "org.apache.tools.ant.", "org.junit.", "junit.framework.JUnit4TestAdapter", "Caused by: java.lang.AssertionError", " more"};
    private boolean haltOnError = false;
    private boolean haltOnFailure = false;
    private int retCode = 0;
    private JUnitTest junitTest;
    private PrintStream systemError;
    private PrintStream systemOut;
    private boolean forked = false;
    private static boolean multipleTests = false;
    private ClassLoader loader;
    private boolean logTestListenerEvents = false;
    private boolean junit4;
    private static String crashFile = null;
    private PrintStream savedOut = null;
    private PrintStream savedErr = null;
    private static Vector fromCmdLine = new Vector();
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Throwable;

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure) {
        this(test, haltOnError, filtertrace, haltOnFailure, false);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput) {
        this(test, haltOnError, filtertrace, haltOnFailure, showOutput, false);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, boolean logTestListenerEvents) {
        this(test, haltOnError, filtertrace, haltOnFailure, showOutput, logTestListenerEvents, null);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, ClassLoader loader) {
        this(test, haltOnError, filtertrace, haltOnFailure, false, loader);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, ClassLoader loader) {
        this(test, haltOnError, filtertrace, haltOnFailure, showOutput, false, loader);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, boolean logTestListenerEvents, ClassLoader loader) {
        JUnitTestRunner.filtertrace = filtertrace;
        this.junitTest = test;
        this.haltOnError = haltOnError;
        this.haltOnFailure = haltOnFailure;
        this.showOutput = showOutput;
        this.logTestListenerEvents = logTestListenerEvents;
        this.loader = loader;
    }

    private PrintStream createEmptyStream() {
        return new PrintStream(new OutputStream(){

            public void write(int b) {
            }
        });
    }

    private PrintStream createTeePrint(PrintStream ps1, PrintStream ps2) {
        return new PrintStream((OutputStream)new TeeOutputStream((OutputStream)ps1, (OutputStream)ps2));
    }

    private void setupIOStreams(ByteArrayOutputStream o, ByteArrayOutputStream e) {
        this.systemOut = new PrintStream(o);
        this.systemError = new PrintStream(e);
        if (this.forked) {
            if (!this.outputToFormatters) {
                if (!this.showOutput) {
                    this.savedOut = System.out;
                    this.savedErr = System.err;
                    System.setOut(this.createEmptyStream());
                    System.setErr(this.createEmptyStream());
                }
            } else {
                this.savedOut = System.out;
                this.savedErr = System.err;
                if (!this.showOutput) {
                    System.setOut(this.systemOut);
                    System.setErr(this.systemError);
                } else {
                    System.setOut(this.createTeePrint(this.savedOut, this.systemOut));
                    System.setErr(this.createTeePrint(this.savedErr, this.systemError));
                }
                this.perm = null;
            }
        } else if (this.perm != null) {
            this.perm.setSecurityManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean startTestSuiteSuccess;
        ByteArrayOutputStream outStrm;
        ByteArrayOutputStream errStrm;
        block30: {
            this.res = new TestResult();
            this.res.addListener(this.wrapListener(this));
            for (int i = 0; i < this.formatters.size(); ++i) {
                this.res.addListener(this.wrapListener((TestListener)this.formatters.elementAt(i)));
            }
            errStrm = new ByteArrayOutputStream();
            outStrm = new ByteArrayOutputStream();
            this.setupIOStreams(outStrm, errStrm);
            Object suite = null;
            Throwable exception = null;
            startTestSuiteSuccess = false;
            try {
                block29: {
                    try {
                        Class<?> testClass = null;
                        testClass = this.loader == null ? Class.forName(this.junitTest.getName()) : Class.forName(this.junitTest.getName(), true, this.loader);
                        Method suiteMethod = null;
                        try {
                            suiteMethod = testClass.getMethod("suite", new Class[0]);
                        }
                        catch (NoSuchMethodException e) {
                            // empty catch block
                        }
                        if (suiteMethod != null) {
                            suite = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
                            break block29;
                        }
                        Class<?> junit4TestAdapterClass = null;
                        try {
                            Class.forName("java.lang.annotation.Annotation");
                            junit4TestAdapterClass = this.loader == null ? Class.forName("junit.framework.JUnit4TestAdapter") : Class.forName("junit.framework.JUnit4TestAdapter", true, this.loader);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                        boolean bl = this.junit4 = junit4TestAdapterClass != null;
                        suite = this.junit4 ? (Test)junit4TestAdapterClass.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = JUnitTestRunner.class$("java.lang.Class")) : class$java$lang$Class).newInstance(testClass) : new TestSuite(testClass);
                    }
                    catch (Throwable e) {
                        this.retCode = 2;
                        exception = e;
                    }
                }
                long start = System.currentTimeMillis();
                this.fireStartTestSuite();
                startTestSuiteSuccess = true;
                if (exception != null) {
                    for (int i = 0; i < this.formatters.size(); ++i) {
                        ((TestListener)this.formatters.elementAt(i)).addError(null, exception);
                    }
                    this.junitTest.setCounts(1L, 0L, 1L);
                    this.junitTest.setRunTime(0L);
                } else {
                    try {
                        this.logTestListenerEvent("tests to run: " + suite.countTestCases());
                        suite.run(this.res);
                        Object var11_15 = null;
                        if (this.junit4) {
                            int[] cnts = this.findJUnit4FailureErrorCount(this.res);
                            this.junitTest.setCounts(this.res.runCount(), cnts[0], cnts[1]);
                        } else {
                            this.junitTest.setCounts(this.res.runCount(), this.res.failureCount(), this.res.errorCount());
                        }
                        this.junitTest.setRunTime(System.currentTimeMillis() - start);
                    }
                    catch (Throwable throwable) {
                        Object var11_16 = null;
                        if (this.junit4) {
                            int[] cnts = this.findJUnit4FailureErrorCount(this.res);
                            this.junitTest.setCounts(this.res.runCount(), cnts[0], cnts[1]);
                        } else {
                            this.junitTest.setCounts(this.res.runCount(), this.res.failureCount(), this.res.errorCount());
                        }
                        this.junitTest.setRunTime(System.currentTimeMillis() - start);
                        throw throwable;
                    }
                }
                Object var14_20 = null;
                if (this.perm == null) break block30;
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                if (this.perm != null) {
                    this.perm.restoreSecurityManager();
                }
                if (this.savedOut != null) {
                    System.setOut(this.savedOut);
                }
                if (this.savedErr != null) {
                    System.setErr(this.savedErr);
                }
                this.systemError.close();
                this.systemError = null;
                this.systemOut.close();
                this.systemOut = null;
                if (startTestSuiteSuccess) {
                    this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
                }
                throw throwable;
            }
            this.perm.restoreSecurityManager();
        }
        if (this.savedOut != null) {
            System.setOut(this.savedOut);
        }
        if (this.savedErr != null) {
            System.setErr(this.savedErr);
        }
        this.systemError.close();
        this.systemError = null;
        this.systemOut.close();
        this.systemOut = null;
        if (startTestSuiteSuccess) {
            this.sendOutAndErr(new String(outStrm.toByteArray()), new String(errStrm.toByteArray()));
        }
        this.fireEndTestSuite();
        if (this.retCode != 0 || this.res.errorCount() != 0) {
            this.retCode = 2;
        } else if (this.res.failureCount() != 0) {
            this.retCode = 1;
        }
    }

    public int getRetCode() {
        return this.retCode;
    }

    public void startTest(Test t) {
        String testName = JUnitVersionHelper.getTestCaseName(t);
        this.logTestListenerEvent("startTest(" + testName + ")");
    }

    public void endTest(Test test) {
        String testName = JUnitVersionHelper.getTestCaseName(test);
        this.logTestListenerEvent("endTest(" + testName + ")");
    }

    private void logTestListenerEvent(String msg) {
        PrintStream out;
        PrintStream printStream = out = this.savedOut != null ? this.savedOut : System.out;
        if (this.logTestListenerEvents) {
            out.flush();
            out.println("junit.framework.TestListener: " + msg);
            out.flush();
        }
    }

    public void addFailure(Test test, Throwable t) {
        String testName = JUnitVersionHelper.getTestCaseName(test);
        this.logTestListenerEvent("addFailure(" + testName + ", " + t.getMessage() + ")");
        if (this.haltOnFailure) {
            this.res.stop();
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        String testName = JUnitVersionHelper.getTestCaseName(test);
        this.logTestListenerEvent("addError(" + testName + ", " + t.getMessage() + ")");
        if (this.haltOnError) {
            this.res.stop();
        }
    }

    public void setPermissions(Permissions permissions) {
        this.perm = permissions;
    }

    public void handleOutput(String output) {
        if ((this.logTestListenerEvents || !output.startsWith("junit.framework.TestListener: ")) && this.systemOut != null) {
            this.systemOut.print(output);
        }
    }

    public int handleInput(byte[] buffer, int offset, int length) throws IOException {
        return -1;
    }

    public void handleErrorOutput(String output) {
        if (this.systemError != null) {
            this.systemError.print(output);
        }
    }

    public void handleFlush(String output) {
        if (this.systemOut != null) {
            this.systemOut.print(output);
        }
    }

    public void handleErrorFlush(String output) {
        if (this.systemError != null) {
            this.systemError.print(output);
        }
    }

    private void sendOutAndErr(String out, String err) {
        for (int i = 0; i < this.formatters.size(); ++i) {
            JUnitResultFormatter formatter = (JUnitResultFormatter)this.formatters.elementAt(i);
            formatter.setSystemOutput(out);
            formatter.setSystemError(err);
        }
    }

    private void fireStartTestSuite() {
        for (int i = 0; i < this.formatters.size(); ++i) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).startTestSuite(this.junitTest);
        }
    }

    private void fireEndTestSuite() {
        for (int i = 0; i < this.formatters.size(); ++i) {
            ((JUnitResultFormatter)this.formatters.elementAt(i)).endTestSuite(this.junitTest);
        }
    }

    public void addFormatter(JUnitResultFormatter f) {
        this.formatters.addElement(f);
    }

    public void addFormatter(JUnitTaskMirror.JUnitResultFormatterMirror f) {
        this.formatters.addElement((JUnitResultFormatter)f);
    }

    public static void main(String[] args) throws IOException {
        boolean haltError = false;
        boolean haltFail = false;
        boolean stackfilter = true;
        Properties props = new Properties();
        boolean showOut = false;
        boolean outputToFormat = true;
        boolean logTestListenerEvents = false;
        if (args.length == 0) {
            System.err.println("required argument TestClassName missing");
            System.exit(2);
        }
        if (args[0].startsWith("testsfile=")) {
            multipleTests = true;
            args[0] = args[0].substring("testsfile=".length());
        }
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("haltOnError=")) {
                haltError = Project.toBoolean((String)args[i].substring("haltOnError=".length()));
                continue;
            }
            if (args[i].startsWith("haltOnFailure=")) {
                haltFail = Project.toBoolean((String)args[i].substring("haltOnFailure=".length()));
                continue;
            }
            if (args[i].startsWith("filtertrace=")) {
                stackfilter = Project.toBoolean((String)args[i].substring("filtertrace=".length()));
                continue;
            }
            if (args[i].startsWith("crashfile=")) {
                crashFile = args[i].substring("crashfile=".length());
                JUnitTestRunner.registerTestCase("BeforeFirstTest");
                continue;
            }
            if (args[i].startsWith("formatter=")) {
                try {
                    JUnitTestRunner.createAndStoreFormatter(args[i].substring("formatter=".length()));
                }
                catch (BuildException be) {
                    System.err.println(be.getMessage());
                    System.exit(2);
                }
                continue;
            }
            if (args[i].startsWith("propsfile=")) {
                FileInputStream in = new FileInputStream(args[i].substring("propsfile=".length()));
                props.load(in);
                in.close();
                continue;
            }
            if (args[i].startsWith("showoutput=")) {
                showOut = Project.toBoolean((String)args[i].substring("showoutput=".length()));
                continue;
            }
            if (args[i].startsWith("logtestlistenerevents=")) {
                logTestListenerEvents = Project.toBoolean((String)args[i].substring("logtestlistenerevents=".length()));
                continue;
            }
            if (!args[i].startsWith("outputtoformatters=")) continue;
            outputToFormat = Project.toBoolean((String)args[i].substring("outputtoformatters=".length()));
        }
        Properties p = System.getProperties();
        Enumeration e = ((Hashtable)p).keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            props.put(key, ((Hashtable)p).get(key));
        }
        int returnCode = 0;
        if (multipleTests) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(args[0]));
                int code = 0;
                boolean errorOccurred = false;
                boolean failureOccurred = false;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line, ",");
                    String testCaseName = st.nextToken();
                    JUnitTest t = new JUnitTest(testCaseName);
                    t.setTodir(new File(st.nextToken()));
                    t.setOutfile(st.nextToken());
                    t.setProperties(props);
                    code = JUnitTestRunner.launch(t, haltError, stackfilter, haltFail, showOut, outputToFormat, logTestListenerEvents);
                    errorOccurred = code == 2;
                    boolean bl = failureOccurred = code != 0;
                    if (!errorOccurred && !failureOccurred) continue;
                    if (errorOccurred && haltError || failureOccurred && haltFail) {
                        JUnitTestRunner.registerNonCrash();
                        System.exit(code);
                        continue;
                    }
                    if (code > returnCode) {
                        returnCode = code;
                    }
                    System.out.println("TEST " + t.getName() + " FAILED");
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else {
            JUnitTest t = new JUnitTest(args[0]);
            t.setProperties(props);
            returnCode = JUnitTestRunner.launch(t, haltError, stackfilter, haltFail, showOut, outputToFormat, logTestListenerEvents);
        }
        JUnitTestRunner.registerNonCrash();
        System.exit(returnCode);
    }

    private static void transferFormatters(JUnitTestRunner runner, JUnitTest test) {
        runner.addFormatter(new JUnitResultFormatter(){

            public void startTestSuite(JUnitTest suite) throws BuildException {
            }

            public void endTestSuite(JUnitTest suite) throws BuildException {
            }

            public void setOutput(OutputStream out) {
            }

            public void setSystemOutput(String out) {
            }

            public void setSystemError(String err) {
            }

            public void addError(Test arg0, Throwable arg1) {
            }

            public void addFailure(Test arg0, AssertionFailedError arg1) {
            }

            public void endTest(Test arg0) {
            }

            public void startTest(Test arg0) {
                JUnitTestRunner.registerTestCase(JUnitVersionHelper.getTestCaseName(arg0));
            }
        });
        for (int i = 0; i < fromCmdLine.size(); ++i) {
            FormatterElement fe = (FormatterElement)fromCmdLine.elementAt(i);
            if (multipleTests && fe.getUseFile()) {
                File destFile = new File(test.getTodir(), test.getOutfile() + fe.getExtension());
                fe.setOutfile(destFile);
            }
            runner.addFormatter((JUnitResultFormatter)fe.createFormatter());
        }
    }

    private static void createAndStoreFormatter(String line) throws BuildException {
        FormatterElement fe = new FormatterElement();
        int pos = line.indexOf(44);
        if (pos == -1) {
            fe.setClassname(line);
            fe.setUseFile(false);
        } else {
            fe.setClassname(line.substring(0, pos));
            fe.setUseFile(true);
            if (!multipleTests) {
                fe.setOutfile(new File(line.substring(pos + 1)));
            } else {
                int fName = line.indexOf("IGNORETHIS");
                if (fName > -1) {
                    fe.setExtension(line.substring(fName + "IGNORETHIS".length()));
                }
            }
        }
        fromCmdLine.addElement(fe);
    }

    public static String getFilteredTrace(Throwable t) {
        String trace = StringUtils.getStackTrace((Throwable)t);
        return JUnitTestRunner.filterStack(trace);
    }

    public static String filterStack(String stack) {
        if (!filtertrace) {
            return stack;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (JUnitTestRunner.filterLine(line)) continue;
                pw.println(line);
            }
        }
        catch (Exception e) {
            return stack;
        }
        return sw.toString();
    }

    private static boolean filterLine(String line) {
        for (int i = 0; i < DEFAULT_TRACE_FILTERS.length; ++i) {
            if (line.indexOf(DEFAULT_TRACE_FILTERS[i]) == -1) continue;
            return true;
        }
        return false;
    }

    private static int launch(JUnitTest t, boolean haltError, boolean stackfilter, boolean haltFail, boolean showOut, boolean outputToFormat, boolean logTestListenerEvents) {
        JUnitTestRunner runner = new JUnitTestRunner(t, haltError, stackfilter, haltFail, showOut, logTestListenerEvents, null);
        runner.forked = true;
        runner.outputToFormatters = outputToFormat;
        JUnitTestRunner.transferFormatters(runner, t);
        runner.run();
        return runner.getRetCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void registerNonCrash() throws IOException {
        if (crashFile == null) return;
        FileWriter out = null;
        try {
            out = new FileWriter(crashFile);
            out.write("terminated successfully\n");
            out.flush();
            Object var2_1 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void registerTestCase(String testCase) {
        if (crashFile == null) return;
        try {
            FileWriter out = null;
            try {
                out = new FileWriter(crashFile);
                out.write(testCase + "\n");
                out.flush();
                Object var3_3 = null;
                if (out == null) return;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            out.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private TestListener wrapListener(final TestListener testListener) {
        return new TestListener(){

            public void addError(Test test, Throwable t) {
                if (JUnitTestRunner.this.junit4 && t instanceof AssertionFailedError) {
                    testListener.addFailure(test, (AssertionFailedError)t);
                } else if (JUnitTestRunner.this.junit4 && t.getClass().getName().equals("java.lang.AssertionError")) {
                    try {
                        String msg = t.getMessage();
                        AssertionFailedError failure = msg != null ? new AssertionFailedError(msg) : new AssertionFailedError();
                        Method initCause = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = JUnitTestRunner.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("initCause", class$java$lang$Throwable == null ? (class$java$lang$Throwable = JUnitTestRunner.class$("java.lang.Throwable")) : class$java$lang$Throwable);
                        initCause.invoke((Object)failure, t);
                        testListener.addFailure(test, failure);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        testListener.addError(test, t);
                    }
                } else {
                    testListener.addError(test, t);
                }
            }

            public void addFailure(Test test, AssertionFailedError t) {
                testListener.addFailure(test, t);
            }

            public void addFailure(Test test, Throwable t) {
                if (t instanceof AssertionFailedError) {
                    testListener.addFailure(test, (AssertionFailedError)t);
                } else {
                    testListener.addError(test, t);
                }
            }

            public void endTest(Test test) {
                testListener.endTest(test);
            }

            public void startTest(Test test) {
                testListener.startTest(test);
            }
        };
    }

    private int[] findJUnit4FailureErrorCount(TestResult res) {
        int failures = 0;
        int errors = 0;
        Enumeration e = res.failures();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++failures;
        }
        e = res.errors();
        while (e.hasMoreElements()) {
            Throwable t = ((TestFailure)e.nextElement()).thrownException();
            if (t instanceof AssertionFailedError || t.getClass().getName().equals("java.lang.AssertionError")) {
                ++failures;
                continue;
            }
            ++errors;
        }
        return new int[]{failures, errors};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

