/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;

public class Filters
implements FilenameFilter {
    public static final int POLICY_LAZY = 2;
    public static final int POLICY_STRICT = 1;
    private FilterComparator _filterComp;
    private FilenameFilter[] _filters;
    private int _policy = 2;

    public Filters() {
        this(2);
    }

    public Filters(int policy) {
        this._policy = policy;
        this._filters = new FilenameFilter[0];
        this._filterComp = new FilterComparator();
        Arrays.sort(this._filters, this._filterComp);
    }

    public void setPolicy(int policy) {
        this._policy = policy;
    }

    public int getPolicy() {
        return this._policy;
    }

    public boolean accept(File dir, String name) {
        if (this._policy == 1) {
            return this.strictAccept(dir, name);
        }
        return this.lazyAccept(dir, name);
    }

    public synchronized void addFilter(FilenameFilter filter) {
        if (Arrays.binarySearch(this._filters, filter, this._filterComp) < 0) {
            FilenameFilter[] tmp = new FilenameFilter[this._filters.length + 1];
            System.arraycopy(this._filters, 0, tmp, 0, this._filters.length);
            tmp[this._filters.length] = filter;
            this._filters = tmp;
        }
    }

    public synchronized boolean contains(FilenameFilter filter) {
        return Arrays.binarySearch(this._filters, filter, this._filterComp) > -1;
    }

    public synchronized void removeFilter(FilenameFilter filter) {
        int length = this._filters.length;
        int found = Arrays.binarySearch(this._filters, filter, this._filterComp);
        if (found > -1) {
            FilenameFilter[] tmp = new FilenameFilter[length - 1];
            System.arraycopy(this._filters, 0, tmp, 0, length - (length - found));
            System.arraycopy(this._filters, found + 1, tmp, found, length - found - 1);
            this._filters = tmp;
        }
    }

    private boolean lazyAccept(File dir, String name) {
        if (this._filters.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this._filters.length) {
            if (this._filters[i].accept(dir, name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean strictAccept(File dir, String name) {
        if (new File(dir + File.separator + name).isDirectory()) {
            return true;
        }
        int i = 0;
        while (i < this._filters.length) {
            if (!this._filters[i].accept(dir, name)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class FilterComparator
    implements Comparator {
        private FilterComparator() {
        }

        public int compare(Object first, Object second) {
            if (first == null) {
                if (second == null) {
                    return 0;
                }
                return -1;
            }
            if (second == null) {
                return 1;
            }
            if (first.equals(second)) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            return this.equals(obj);
        }
    }
}

