/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/

package com.verisign.epp.codec.relateddomainext;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;

/**
 * EPPCodecComponent that encodes and decodes a <relDom:info> tag
 * <p>
 * Title: EPP 1.0 Related Domain - info tag
 * </p>
 * <p>
 * Description: The EPPRelatedDomainExtInfo object indicates to the server to
 * include the related domain information in the response. As XML, it is
 * represented by a <relDom:info> element.
 * </p>
 * <p>
 * Copyright: Copyright (c) 2013
 * </p>
 * <p>
 * Company: VeriSign
 * </p>
 * 
 * @author nchigurupati
 * @version 1.0
 */
public class EPPRelatedDomainExtInfo implements
		com.verisign.epp.codec.gen.EPPCodecComponent {

	/**
	 * Log4j category for logging
	 */
	private static Logger cat = Logger.getLogger( EPPRelatedDomainExtInfo.class
			.getName(), EPPCatFactory.getInstance().getFactory() );

	/**
	 * 
	 */
	private static final long serialVersionUID = -4632606931436150525L;

	final static java.lang.String ELM_INFO = "relDom:info";


	/**
	 * Default constructor
	 */

	public EPPRelatedDomainExtInfo () {
	}


	/**
	 * Clone <code>EPPRelatedDomainExtInfo</code>.
	 * 
	 * @return clone of <code>EPPRelatedDomainExtInfo</code>
	 * @exception CloneNotSupportedException
	 *            standard Object.clone exception
	 */
	public Object clone () throws CloneNotSupportedException {
		EPPRelatedDomainExtInfo clone = null;

		clone = (EPPRelatedDomainExtInfo) super.clone();

		return clone;
	}


	/**
	 * Decode the EPPRelatedDomainExtInfo attributes from the aElement DOM Element
	 * tree.
	 * 
	 * @param aElement
	 *        - Root DOM Element to decode EPPRelatedDomainExtInfo from.
	 * @exception EPPDecodeException
	 *            Unable to decode aElement
	 */
	public void decode ( final Element aElement ) throws EPPDecodeException {
		// nothing to decode
	}


	/**
	 * Encode a DOM Element tree from the attributes of the
	 * EPPRelatedDomainExtInfo instance.
	 * 
	 * @param aDocument
	 *        - DOM Document that is being built. Used as an Element factory.
	 * @return Element - Root DOM Element representing the EPPRelatedDomainExtInfo
	 *         instance.
	 * @exception EPPEncodeException
	 *            - Unable to encode EPPRelatedDomainExtInfo instance.
	 */
	public Element encode ( final Document aDocument ) throws EPPEncodeException {
		// Create the element relDom:Info
		final Element root =
				aDocument.createElementNS( EPPRelatedDomainExtFactory.NS, ELM_INFO );
		return root;
	}


	/**
	 * implements a deep <code>EPPRelatedDomainExtInfo</code> compare.
	 * 
	 * @param aObject
	 *        <code>EPPRelatedDomainExtInfo</code> instance to compare with
	 * @return DOCUMENT ME!
	 */
	public boolean equals ( final Object aObject ) {
		if ( !(aObject instanceof EPPRelatedDomainExtInfo) ) {
			cat
					.error( "In EPPRelatedDomainExtInfo.equals(): not instanceof EPPRelatedDomainExtInfo" );
			return false;
		}

		return true;
	}


	/**
	 * Implementation of <code>Object.toString</code>, which will result in an
	 * indented XML <code>String</code> representation of the concrete
	 * <code>EPPCodecComponent</code>.
	 * 
	 * @return Indented XML <code>String</code> if successful; <code>ERROR</code>
	 *         otherwise.
	 */
	public String toString () {
		return EPPUtil.toString( this );
	}

}
