package com.verisign.epp.codec.registry;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;

public class EPPRegistryRegex implements EPPCodecComponent {
	private static final long serialVersionUID = 6061392945665281499L;

	public static final String ELM_EXPRESSION = "registry:expression";
	public static final String ELM_EXPLANATION = "registry:explanation";

	public static final String ATTR_LANG = "lang";

	private String rootName = null;

	private String expression = null;
	private String explanation = null;
	private String lang = null;

	public EPPRegistryRegex() {
		super();
	}

	public EPPRegistryRegex(String expression) {
		this();
		this.expression = expression;
	}

	public EPPRegistryRegex(String expression, String explanation) {
		this(expression);
		this.explanation = explanation;
	}

	public EPPRegistryRegex(String expression, String explanation, String lang) {
		this(expression);
		this.explanation = explanation;
		this.lang = lang;
	}

	// public EPPRegistryRegex(String rootName, String expression,
	// String explanation) {
	// this(expression, explanation);
	// this.rootName = rootName;
	// }

	public Element encode(Document aDocument) throws EPPEncodeException {
		if (rootName == null || rootName.trim().length() == 0) {
			throw new EPPEncodeException("rootName is not set");
		}
		if (expression == null || expression.trim().length() == 0) {
			throw new EPPEncodeException(
					"expression attribute is not set in EPPRegistryRegex.encode");
		}
		Element root = aDocument.createElementNS(EPPRegistryMapFactory.NS,
				getRootName());
		EPPUtil.encodeString(aDocument, root, expression,
				EPPRegistryMapFactory.NS, ELM_EXPRESSION);
		if (explanation != null && explanation.trim().length() > 0) {
			if (lang == null || lang.trim().length() == 0) {
				lang = "en";
			}
			Element currElm = aDocument.createElementNS(
					EPPRegistryMapFactory.NS, ELM_EXPLANATION);
			Text currVal = aDocument.createTextNode(explanation);
			currElm.setAttribute(ATTR_LANG, lang);
			currElm.appendChild(currVal);
			root.appendChild(currElm);
		}

		return root;
	}

	public void decode(Element aElement) throws EPPDecodeException {
		expression = EPPUtil.decodeString(aElement, EPPRegistryMapFactory.NS,
				ELM_EXPRESSION);
		explanation = EPPUtil.decodeString(aElement, EPPRegistryMapFactory.NS,
				ELM_EXPLANATION);
		if (explanation != null) {
			Element theElm = EPPUtil.getElementByTagNameNS(aElement,
					EPPRegistryMapFactory.NS, ELM_EXPLANATION);
			lang = theElm.getAttribute(ATTR_LANG);
			if (lang == null || lang.trim().length() == 0) {
				lang = "en";
			}
		}

		if (expression == null || expression.trim().length() == 0) {
			throw new EPPDecodeException(
					"expression attribute is not set in EPPRegistryRegex.decode");
		}
	}

	public String toString() {
		return EPPUtil.toString(this);
	}

	public Object clone() throws CloneNotSupportedException {
		return (EPPRegistryRegex) super.clone();
	}

	public boolean equals(Object aObject) {
		if (!(aObject instanceof EPPRegistryRegex)) {
			return false;
		}

		EPPRegistryRegex theComp = (EPPRegistryRegex) aObject;
		if (!((rootName == null) ? (theComp.rootName == null) : rootName
				.equals(theComp.rootName))) {
			return false;
		}
		if (!((expression == null) ? (theComp.expression == null) : expression
				.equals(theComp.expression))) {
			return false;
		}
		if (!((explanation == null) ? (theComp.explanation == null)
				: explanation.equals(theComp.explanation))) {
			return false;
		}
		if (explanation != null) {
			if (!((lang == null) ? (theComp.lang == null) : lang
					.equals(theComp.lang))) {
				return false;
			}
		}

		return true;
	}

	public String getExpression() {
		return expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
	}

	public String getExplanation() {
		return explanation;
	}

	public void setExplanation(String explanation) {
		this.explanation = explanation;
	}

	String getRootName() {
		return rootName;
	}

	void setRootName(String rootName) {
		this.rootName = rootName;
	}

	public String getLang() {
		return lang;
	}

	public void setLang(String lang) {
		this.lang = lang;
	}
}
