/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.util;

import com.codestudio.util.PoolMetaData;

public class JDBCPoolMetaData
extends PoolMetaData {
    private String driver;
    private String URL;
    private String username;
    private String password;
    private boolean nativeResults = false;
    private String validationQuery;
    private String initialPoolSQL;
    private String initialConnectionSQL;
    private boolean removeOnExceptions = false;
    private boolean poolingPreparedStatements = true;
    private int transactionIsolationLevel = 2;
    private int transactionTimeout = 20;
    private boolean cacheEnabled = false;
    private int cacheSize = 5;
    private int cacheRefreshInterval = 30;
    private String JNDIName;

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String string) {
        this.URL = string;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getDbname() {
        return this.getName();
    }

    public void setDbname(String string) {
        this.setName(string);
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public void setJNDIName(String string) {
        this.JNDIName = string;
    }

    public boolean isNativeResults() {
        return this.nativeResults;
    }

    public void setNativeResults(boolean bl) {
        this.nativeResults = bl;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolingPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean bl) {
        this.poolingPreparedStatements = bl;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string;
    }

    public String getInitialPoolSQL() {
        return this.initialPoolSQL;
    }

    public void setInitialPoolSQL(String string) {
        this.initialPoolSQL = string;
    }

    public String getInitialConnectionSQL() {
        return this.initialConnectionSQL;
    }

    public void setInitialConnectionSQL(String string) {
        this.initialConnectionSQL = string;
    }

    public boolean isRemoveOnExceptions() {
        return this.removeOnExceptions;
    }

    public void setRemoveOnExceptions(boolean bl) {
        this.removeOnExceptions = bl;
    }

    public int getInitialConnections() {
        return this.getInitialObjects();
    }

    public void setInitialConnections(int n) {
        this.setInitialObjects(n);
    }

    public int getConnectionTimeout() {
        return this.getObjectTimeout();
    }

    public void setConnectionTimeout(int n) {
        this.setObjectTimeout(n);
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int n) {
        this.transactionTimeout = n;
    }

    public int getIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setIsolationLevel(int n) {
        this.transactionIsolationLevel = n;
    }

    public String getTxIsolationLevel() {
        return this.convertIsoToString(this.getIsolationLevel());
    }

    public void setTxIsolationLevel(String string) {
        this.setIsolationLevel(this.convertIsoToInt(string));
    }

    private int convertIsoToInt(String string) {
        int n = 2;
        if ((string = string.toUpperCase().trim()).equals("NONE")) {
            n = 0;
        } else if (string.equals("READ_COMMITTED")) {
            n = 2;
        } else if (string.equals("READ_UNCOMMITTED")) {
            n = 1;
        } else if (string.equals("REPEATABLE_READ")) {
            n = 4;
        } else if (string.equals("SERIALIZABLE")) {
            n = 8;
        } else {
            System.out.println("Unrecognized isolation level " + string + " using default setting of " + this.convertIsoToString(n));
        }
        return n;
    }

    private String convertIsoToString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "NONE";
                break;
            }
            case 2: {
                string = "READ_COMMITTED";
                break;
            }
            case 1: {
                string = "READ_UNCOMMITTED";
                break;
            }
            case 4: {
                string = "REPEATABLE_READ";
                break;
            }
            case 8: {
                string = "SERIALIZABLE";
                break;
            }
        }
        return string;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean bl) {
        this.cacheEnabled = bl;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public int getCacheRefreshInterval() {
        return this.cacheRefreshInterval;
    }

    public void setCacheRefreshInterval(int n) {
        this.cacheRefreshInterval = n;
    }
}

