/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.util;

import com.codestudio.util.GenericPoolMetaData;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.PoolMetaData;
import java.lang.reflect.Constructor;

public class GenericPool
extends ObjectPool {
    private GenericPoolMetaData info;
    protected Class otype;
    protected Object[] oparams = null;
    protected Constructor con = null;

    public GenericPool(PoolMetaData poolMetaData) {
        super(poolMetaData);
        this.info = (GenericPoolMetaData)poolMetaData;
        try {
            this.init();
        }
        catch (Exception exception) {
            this.log("GenericPool: Exception while initializing", exception);
        }
    }

    public GenericPool(GenericPoolMetaData genericPoolMetaData, String string, Object[] objectArray) {
        this(genericPoolMetaData);
        this.oparams = objectArray;
        this.con = this.figureConstructor();
    }

    public synchronized void setParams(Object[] objectArray) {
        this.oparams = objectArray;
        this.con = this.figureConstructor();
    }

    public synchronized Object[] getParams() {
        return this.oparams;
    }

    protected Constructor figureConstructor() {
        if (this.oparams == null) {
            return null;
        }
        Class[] classArray = new Class[this.oparams.length];
        int n = 0;
        while (n < this.oparams.length) {
            classArray[n] = this.oparams[n].getClass();
            ++n;
        }
        try {
            Class<?> clazz = Class.forName(this.info.getObjectType());
            return clazz.getConstructor(classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("ERROR: GenericPool of " + this.info.getObjectType() + " cannot be created, that Class cannot be found");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.log("ERROR: In GenericPool: No such constructor with the specified params:");
        }
        catch (SecurityException securityException) {
            this.log("ERROR: GenericPool: Security Exception:");
        }
        return null;
    }

    protected Object create() throws Exception {
        String string = this.info.getObjectType();
        if (string == null) {
            throw new ClassNotFoundException();
        }
        Class<?> clazz = Class.forName(string);
        Object var3_3 = null;
        if (this.con == null) {
            var3_3 = clazz.newInstance();
            return var3_3;
        }
        var3_3 = this.con.newInstance(this.oparams);
        return var3_3;
    }

    public Object requestObject() {
        try {
            return super.checkOut();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public void returnObject(Object object) {
        super.checkIn(object);
    }

    protected boolean validate(Object object) {
        return object != null;
    }

    protected void expire(Object object) {
        object = null;
    }
}

