/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAvailable;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreate;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreateResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDelete;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDeleteResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomainData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtField;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtFields;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtGroup;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtName;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRegistered;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenew;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenewResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransfer;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransferResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtUpdate;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class RelatedDomainHandler
extends DomainHandler {
    private static final String svrTransId = "54322-XYZ";
    private static Logger cat = Logger.getLogger((String)RelatedDomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theMessage = (EPPDomainCreateCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtCreate.class)) {
            return super.doDomainCreate(aEvent, aData);
        }
        cat.info((Object)"Domain Create has relatedDomain extension");
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getFiveYearsFutureDate();
        EPPTransId respTransId = new EPPTransId(theMessage.getTransId(), "54321-XYZ");
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(respTransId, "example.com", theDate, expDate);
        theResponse.setResult(1000);
        ArrayList<EPPRelatedDomainExtDomainData> domains = new ArrayList<EPPRelatedDomainExtDomainData>();
        EPPRelatedDomainExtDomainData domainData = new EPPRelatedDomainExtDomainData("domain1.com", theDate, expDate);
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("domain2.com", theDate, expDate);
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("xn--idn.com", theDate, expDate);
        domains.add(domainData);
        EPPRelatedDomainExtCreateResp resp = new EPPRelatedDomainExtCreateResp(domains);
        theResponse.addExtension(resp);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        EPPDomainDeleteCmd theMessage = (EPPDomainDeleteCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtDelete.class)) {
            return super.doDomainDelete(aEvent, aData);
        }
        cat.info((Object)"Domain Delete has relatedDomain extension");
        EPPTransId respTransId = new EPPTransId(theMessage.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1001);
        ArrayList<EPPRelatedDomainExtDomainData> domains = new ArrayList<EPPRelatedDomainExtDomainData>();
        EPPRelatedDomainExtDomainData domainData = new EPPRelatedDomainExtDomainData("domain1.com", "deleted");
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("domain2.com", "pendingDelete");
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("xn--idn.com", "pendingDelete");
        domains.add(domainData);
        EPPRelatedDomainExtDeleteResp resp = new EPPRelatedDomainExtDeleteResp(domains);
        theResponse.addExtension(resp);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainRenew(EPPEvent aEvent, Object aData) {
        EPPDomainRenewCmd theMessage = (EPPDomainRenewCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtRenew.class)) {
            return super.doDomainRenew(aEvent, aData);
        }
        cat.info((Object)"Domain Renew has relatedDomain extension");
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getFiveYearsFutureDate();
        EPPTransId respTransId = new EPPTransId(theMessage.getTransId(), "54321-XYZ");
        EPPDomainRenewResp theResponse = new EPPDomainRenewResp(respTransId, "example.com", expDate);
        theResponse.setResult(1000);
        ArrayList<EPPRelatedDomainExtDomainData> domains = new ArrayList<EPPRelatedDomainExtDomainData>();
        EPPRelatedDomainExtDomainData domainData = new EPPRelatedDomainExtDomainData("domain1.com", expDate);
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("domain2.com", expDate);
        domains.add(domainData);
        EPPRelatedDomainExtRenewResp resp = new EPPRelatedDomainExtRenewResp();
        resp.setDomains(domains);
        theResponse.addExtension(resp);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPDomainUpdateCmd theMessage = (EPPDomainUpdateCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtUpdate.class)) {
            return super.doDomainUpdate(aEvent, aData);
        }
        cat.info((Object)"Domain Update has relatedDomain extension");
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        EPPDomainTransferCmd theMessage = (EPPDomainTransferCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtTransfer.class)) {
            return super.doDomainTransfer(aEvent, aData);
        }
        cat.info((Object)("Domain Transfer has relatedDomain extension: op = " + theMessage.getOp()));
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainTransferResp theResponse = null;
        if (theMessage.getOp().equals("request") || theMessage.getOp().equals("query")) {
            theResponse = this.getEPPDomainTransferResp("example.com", "request");
            EPPRelatedDomainExtTransferResp respExt = new EPPRelatedDomainExtTransferResp();
            theResponse.addExtension(respExt);
            ArrayList<EPPRelatedDomainExtDomainData> domains = new ArrayList<EPPRelatedDomainExtDomainData>();
            respExt.setDomains(domains);
            domains.add(this.getDomainDataForTransferResp("domain1.com", "request"));
            domains.add(this.getDomainDataForTransferResp("domain2.com", "request"));
            EPPDomainTransferResp thePollMsg = this.getEPPDomainTransferResp("example.com", "request");
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("doDomainTransfer: Error putting message [" + thePollMsg + "]"));
                EPPResult theResult = new EPPResult(2400);
                EPPResponse failureResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(failureResponse);
            }
            theResponse.setResult(1000);
        } else if (theMessage.getOp().equals("cancel")) {
            theResponse = this.getEPPDomainTransferResp("example.com", "cancel");
            EPPRelatedDomainExtTransferResp respExt = new EPPRelatedDomainExtTransferResp();
            theResponse.addExtension(respExt);
            ArrayList<EPPRelatedDomainExtDomainData> domains = new ArrayList<EPPRelatedDomainExtDomainData>();
            respExt.setDomains(domains);
            domains.add(this.getDomainDataForTransferResp("domain1.com", "request"));
            domains.add(this.getDomainDataForTransferResp("domain2.com", "request"));
            EPPDomainTransferResp thePollMsg = this.getEPPDomainTransferResp("example.com", "cancel");
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("doDomainTransfer: Error putting message [" + thePollMsg + "]"));
                EPPResult theResult = new EPPResult(2400);
                EPPResponse failureResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(failureResponse);
            }
            theResponse.setResult(1000);
        } else if (theMessage.getOp().equals("approve")) {
            theResponse = this.getEPPDomainTransferResp("example.com", "approve");
            EPPRelatedDomainExtTransferResp respExt = new EPPRelatedDomainExtTransferResp();
            theResponse.addExtension(respExt);
            ArrayList<EPPRelatedDomainExtDomainData> domains = new ArrayList<EPPRelatedDomainExtDomainData>();
            respExt.setDomains(domains);
            domains.add(this.getDomainDataForTransferResp("domain1.com", "request"));
            domains.add(this.getDomainDataForTransferResp("domain2.com", "request"));
            EPPDomainTransferResp thePollMsg = this.getEPPDomainTransferResp("example.com", "approve");
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("doDomainTransfer: Error putting message [" + thePollMsg + "]"));
                EPPResult theResult = new EPPResult(2400);
                EPPResponse failureResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(failureResponse);
            }
            theResponse.setResult(1000);
        } else if (theMessage.getOp().equals("reject")) {
            theResponse = this.getEPPDomainTransferResp("example.com", "reject");
            EPPRelatedDomainExtTransferResp respExt = new EPPRelatedDomainExtTransferResp();
            theResponse.addExtension(respExt);
            ArrayList<EPPRelatedDomainExtDomainData> domains = new ArrayList<EPPRelatedDomainExtDomainData>();
            respExt.setDomains(domains);
            domains.add(this.getDomainDataForTransferResp("domain1.com", "request"));
            domains.add(this.getDomainDataForTransferResp("domain2.com", "request"));
            EPPDomainTransferResp thePollMsg = this.getEPPDomainTransferResp("example.com", "reject");
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("doDomainTransfer: Error putting message [" + thePollMsg + "]"));
                EPPResult theResult = new EPPResult(2400);
                EPPResponse failureResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(failureResponse);
            }
            theResponse.setResult(1000);
        }
        return new EPPEventResponse(theResponse);
    }

    private EPPDomainTransferResp getEPPDomainTransferResp(String aDomainName, String aCommandType) {
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getOneYearFutureDate();
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPDomainTransferResp theResponse = new EPPDomainTransferResp(respTransId, aDomainName);
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus(this.getTransferStatus(aCommandType));
        theResponse.setRequestDate(theDate);
        theResponse.setActionDate(theDate);
        theResponse.setExpirationDate(expDate);
        return theResponse;
    }

    private EPPRelatedDomainExtDomainData getDomainDataForTransferResp(String aDomainName, String aCommandType) {
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getOneYearFutureDate();
        EPPRelatedDomainExtDomainData result = new EPPRelatedDomainExtDomainData();
        result.setName(aDomainName);
        result.setRequestClient("ClientX");
        result.setActionClient("ClientY");
        result.setTransferStatus(this.getTransferStatus(aCommandType));
        result.setRequestDate(theDate);
        result.setActionDate(theDate);
        result.setExpirationDate(expDate);
        return result;
    }

    private String getTransferStatus(String aCommandType) {
        if (aCommandType.equals("request") || aCommandType.equals("query")) {
            return "pending";
        }
        if (aCommandType.equals("cancel")) {
            return "clientCancelled";
        }
        if (aCommandType.equals("reject")) {
            return "clientRejected";
        }
        if (aCommandType.equals("approve")) {
            return "clientApproved";
        }
        return "pending";
    }

    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPDomainInfoCmd theMessage = (EPPDomainInfoCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtInfo.class)) {
            return super.doDomainInfo(aEvent, aData);
        }
        cat.info((Object)"Domain Info has relatedDomain extension");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPTransId respTransId = new EPPTransId(theMessage.getTransId(), "54321-XYZ");
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "xn--test.tld1", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        theResponse.setRegistrant("sh0813");
        EPPDomainContact contactAdmin = new EPPDomainContact("sh0813", "admin");
        EPPDomainContact contactBilling = new EPPDomainContact("sh0813", "billing");
        EPPDomainContact contactTech = new EPPDomainContact("sh0813", "tech");
        Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
        contacts.add(contactAdmin);
        contacts.add(contactTech);
        contacts.add(contactBilling);
        theResponse.setContacts(contacts);
        EPPRelatedDomainExtInfData infData = new EPPRelatedDomainExtInfData();
        ArrayList<EPPRelatedDomainExtGroup> groupList = new ArrayList<EPPRelatedDomainExtGroup>();
        EPPRelatedDomainExtGroup tldGroup = new EPPRelatedDomainExtGroup();
        groupList.add(tldGroup);
        tldGroup.setType("tld");
        infData.setGroup(groupList);
        EPPRelatedDomainExtFields fields = new EPPRelatedDomainExtFields();
        tldGroup.setFields(fields);
        ArrayList<EPPRelatedDomainExtField> fieldsList = new ArrayList<EPPRelatedDomainExtField>();
        fields.setFields(fieldsList);
        fields.setInSync(false);
        EPPRelatedDomainExtField field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(false);
        field.setName("clID");
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(true);
        field.setName("registrant");
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(false);
        field.setName("ns");
        EPPRelatedDomainExtRegistered registered = new EPPRelatedDomainExtRegistered();
        tldGroup.setRegistered(registered);
        ArrayList<EPPRelatedDomainExtName> regList = new ArrayList<EPPRelatedDomainExtName>();
        registered.setRegisteredDomains(regList);
        EPPRelatedDomainExtName name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test.tld1");
        regList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test.tld2");
        regList.add(name);
        EPPRelatedDomainExtGroup variantGroup = new EPPRelatedDomainExtGroup();
        groupList.add(variantGroup);
        variantGroup.setType("variant");
        infData.setGroup(groupList);
        fields = new EPPRelatedDomainExtFields();
        variantGroup.setFields(fields);
        fieldsList = new ArrayList();
        fields.setFields(fieldsList);
        fields.setInSync(true);
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(true);
        field.setName("clID");
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(true);
        field.setName("registrant");
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(true);
        field.setName("ns");
        registered = new EPPRelatedDomainExtRegistered();
        variantGroup.setRegistered(registered);
        regList = new ArrayList();
        registered.setRegisteredDomains(regList);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant1.tld1");
        regList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant1.tld2");
        regList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant1.tld3");
        regList.add(name);
        EPPRelatedDomainExtAvailable avail = new EPPRelatedDomainExtAvailable();
        ArrayList<EPPRelatedDomainExtName> availDomainsList = new ArrayList<EPPRelatedDomainExtName>();
        avail.setAvailableDomains(availDomainsList);
        variantGroup.setAvailable(avail);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant2.tld1");
        availDomainsList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant2.tld2");
        availDomainsList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant2.tld2");
        availDomainsList.add(name);
        theResponse.addExtension(infData);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    private Date getTodaysUTCDateAtMidnight() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getFiveYearsFutureDate() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(1, 5);
        return cal.getTime();
    }

    private Date getOneYearFutureDate() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(1, 1);
        return cal.getTime();
    }
}

