/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchCheck;
import com.verisign.epp.codec.launch.EPPLaunchCheckResult;
import com.verisign.epp.codec.launch.EPPLaunchChkData;
import com.verisign.epp.codec.launch.EPPLaunchCodeMark;
import com.verisign.epp.codec.launch.EPPLaunchCreData;
import com.verisign.epp.codec.launch.EPPLaunchCreate;
import com.verisign.epp.codec.launch.EPPLaunchDelete;
import com.verisign.epp.codec.launch.EPPLaunchInfData;
import com.verisign.epp.codec.launch.EPPLaunchInfo;
import com.verisign.epp.codec.launch.EPPLaunchNotice;
import com.verisign.epp.codec.launch.EPPLaunchStatus;
import com.verisign.epp.codec.launch.EPPLaunchUpdate;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.codec.mark.EPPMarkAddress;
import com.verisign.epp.codec.mark.EPPMarkContact;
import com.verisign.epp.codec.mark.EPPTrademark;
import com.verisign.epp.codec.signedMark.EPPSignedMark;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class LaunchDomainHandler
extends DomainHandler {
    private static Logger cat = Logger.getLogger((String)LaunchDomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private PKIXParameters pkixParameters;

    public LaunchDomainHandler() {
        cat.debug((Object)"LaunchDomainHandler.LaunchDomainHandler(): enter");
        String truststore = Environment.getProperty("EPP.SignedMark.truststore");
        if (truststore == null) {
            cat.error((Object)"LaunchDomainHandler.LaunchDomainHandler(): EPP.SignedMark.truststore NOT defined in configuration");
            System.err.println("LaunchDomainHandler.LaunchDomainHandler(): EPP.SignedMark.truststore NOT defined in configuration");
            System.exit(1);
        }
        String crl = Environment.getOption("EPP.SignedMark.crl");
        try {
            this.pkixParameters = this.loadPKIXParameters(truststore, crl);
        }
        catch (Exception ex) {
            cat.error((Object)("LaunchDomainHandler.LaunchDomainHandler(): Error loading the public key: " + ex));
            ex.printStackTrace();
            System.exit(1);
        }
        cat.debug((Object)"LaunchDomainHandler.LaunchDomainHandler(): exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PKIXParameters loadPKIXParameters(String aTrustStoreName, String aCrlName) throws Exception {
        cat.debug((Object)"LaunchDomainHandler.loadPKIXParameters(String, String): enter");
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream trustStoreFile = new FileInputStream(aTrustStoreName);
        trustStore.load(trustStoreFile, null);
        PKIXParameters pkixParameters = new PKIXParameters(trustStore);
        if (aCrlName == null) {
            cat.debug((Object)"LaunchDomainHandler.loadPKIXParameters(String, String): No CRL specified");
            pkixParameters.setRevocationEnabled(false);
            cat.debug((Object)"LaunchDomainHandler.loadPKIXParameters(String, String): exit");
            return pkixParameters;
        }
        File crlFile = new File(aCrlName);
        if (!crlFile.exists()) {
            throw new EPPException("CRL file " + crlFile + " does not exist.");
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<CRL> crlContentsList = new ArrayList<CRL>();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(aCrlName);
            crlContentsList.add(certFactory.generateCRL(inStream));
        }
        finally {
            if (inStream != null) {
                ((InputStream)inStream).close();
            }
        }
        ArrayList<CertStore> certStores = new ArrayList<CertStore>();
        certStores.add(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crlContentsList)));
        pkixParameters.setCertStores(certStores);
        pkixParameters.setRevocationEnabled(true);
        cat.debug((Object)"LaunchDomainHandler.loadPKIXParameters(String, String): exit");
        return pkixParameters;
    }

    private EPPEventResponse returnError(int aCode, String aClientTransId, String aReason) {
        cat.error((Object)("LaunchDomainHandler.returnError: code = " + aCode + ", reason = " + aReason));
        EPPResponse theResponse = new EPPResponse();
        EPPResult theResult = new EPPResult(aCode);
        theResult.addExtValueReason(aReason);
        theResponse.setResult(theResult);
        theResponse.setTransId(new EPPTransId(aClientTransId, "54321-XYZ"));
        return new EPPEventResponse(theResponse);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected EPPEventResponse doDomainCheck(EPPEvent aEvent, Object aData) {
        EPPEventResponse theEventResponse;
        cat.debug((Object)"LaunchDomainHandler.doDomainCheck: enter");
        EPPDomainCheckCmd theCommand = (EPPDomainCheckCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPLaunchCheck.class)) {
            EPPLaunchCheck theLaunchCheck = (EPPLaunchCheck)theCommand.getExtension(EPPLaunchCheck.class);
            if (!theLaunchCheck.hasType() || theLaunchCheck.getType().equals("claims")) {
                cat.debug((Object)("LaunchDomainHandler.doDomainCheck: Launch Claims Check Form for Phase = " + theLaunchCheck.getPhase()));
                String phase = theLaunchCheck.getPhase().getPhase();
                if (!phase.equals("claims")) return this.returnError(2306, theCommand.getTransId(), "Unsupported check Phase = " + phase);
                EPPResponse theResponse = new EPPResponse(new EPPTransId(theCommand.getTransId(), "54321-XYZ"));
                EPPLaunchChkData theExt = new EPPLaunchChkData(theLaunchCheck.getPhase());
                boolean exists = true;
                Vector vDomainNames = theCommand.getNames();
                Enumeration eDomainNames = vDomainNames.elements();
                while (eDomainNames.hasMoreElements()) {
                    String domainName = (String)eDomainNames.nextElement();
                    if (exists) {
                        theExt.addCheckResult(new EPPLaunchCheckResult(domainName, true, Base64.encodeBase64String((byte[])domainName.getBytes())));
                        exists = !exists;
                        continue;
                    }
                    theExt.addCheckResult(new EPPLaunchCheckResult(domainName, false));
                }
                theResponse.addExtension(theExt);
                theEventResponse = new EPPEventResponse(theResponse);
            } else {
                cat.debug((Object)("LaunchDomainHandler.doDomainCheck: Launch Availability Check Form for Phase = " + theLaunchCheck.getPhase()));
                theEventResponse = super.doDomainCheck(aEvent, aData);
            }
        } else {
            theEventResponse = super.doDomainCheck(aEvent, aData);
        }
        cat.debug((Object)"LaunchDomainHandler.doDomainCheck: exit");
        return theEventResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"LaunchDomainHandler.doDomainInfo: enter");
        EPPLaunchInfData theRespExt = null;
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPLaunchInfo.class)) {
            EPPLaunchInfo theCmdExt = (EPPLaunchInfo)theCommand.getExtension(EPPLaunchInfo.class);
            String applicationId = theCmdExt.getApplicationId();
            String phase = theCmdExt.getPhase().getPhase();
            if (phase.equals("sunrise")) {
                theRespExt = new EPPLaunchInfData();
                theRespExt.setPhase("sunrise");
                if (theCmdExt.isIncludeMark()) {
                    EPPTrademark trademark = new EPPTrademark();
                    trademark.setId("1234-2");
                    trademark.setName("Example One");
                    trademark.setJurisdiction("US");
                    trademark.addClass("35");
                    trademark.addClass("36");
                    trademark.addLabel("example-one");
                    trademark.addLabel("exampleone");
                    trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
                    trademark.setRegNum("234235");
                    trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
                    trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
                    EPPMarkContact holder = new EPPMarkContact();
                    holder.setOrg("Example Inc.");
                    EPPMarkAddress holderAddress = new EPPMarkAddress();
                    holderAddress.addStreet("123 Example Dr.");
                    holderAddress.addStreet("Suite 100");
                    holderAddress.setCity("Reston");
                    holderAddress.setSp("VA");
                    holderAddress.setPc("20190");
                    holderAddress.setCc("US");
                    holder.setAddress(holderAddress);
                    trademark.addHolder(holder);
                    EPPMarkContact contact = new EPPMarkContact();
                    contact.setName("John Doe");
                    contact.setOrg("Example Inc.");
                    EPPMarkAddress contactAddress = new EPPMarkAddress();
                    contactAddress.addStreet("123 Example Dr.");
                    contactAddress.addStreet("Suite 100");
                    contactAddress.setCity("Reston");
                    contactAddress.setSp("VA");
                    contactAddress.setPc("20166-6503");
                    contactAddress.setCc("US");
                    contact.setAddress(contactAddress);
                    contact.setVoice("+1.7035555555");
                    contact.setVoiceExt("1234");
                    contact.setFax("+1.7035555556");
                    contact.setEmail("jdoe@example.tld");
                    trademark.addContact(contact);
                    EPPMark mark = new EPPMark();
                    mark.addTrademark(trademark);
                    theRespExt.addMark(mark);
                }
                if (applicationId != null) {
                    theRespExt.setStatus("pendingValidation");
                    theRespExt.setApplicationId(applicationId);
                }
            } else {
                if (!phase.equals("landrush")) return this.returnError(2306, theCommand.getTransId(), "Unsupported Info Phase = " + phase);
                theRespExt = new EPPLaunchInfData();
                theRespExt.setPhase("landrush");
                if (applicationId == null) return this.returnError(2306, theCommand.getTransId(), "Info with landrush phase must include applicationId");
                theRespExt.setStatus("pendingValidation");
                theRespExt.setApplicationId(applicationId);
            }
        } else {
            cat.debug((Object)"LaunchDomainHandler.doDomainInfo: No EPPLaunchInfo extension passed");
        }
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
        if (theRespExt != null) {
            theResponse.addExtension(theRespExt);
        }
        cat.debug((Object)"LaunchDomainHandler.doDomainInfo: exit");
        return theEventResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPEventResponse theEventResponse;
        block24: {
            boolean isApp;
            EPPLaunchCreate theCmdExt;
            EPPDomainCreateCmd theCommand;
            block29: {
                Iterator<EPPCodecComponent> i$;
                block28: {
                    block25: {
                        String phase;
                        block26: {
                            block27: {
                                cat.debug((Object)"LaunchDomainHandler.doDomainCreate: enter");
                                theEventResponse = null;
                                theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
                                if (!theCommand.hasExtension(EPPLaunchCreate.class)) break block25;
                                theCmdExt = (EPPLaunchCreate)theCommand.getExtension(EPPLaunchCreate.class);
                                phase = theCmdExt.getPhase().getPhase();
                                isApp = new Random().nextBoolean();
                                if (theCmdExt.hasType()) {
                                    isApp = theCmdExt.getType().equals("application");
                                }
                                if (!phase.equals("sunrise")) break block26;
                                String domainName = theCommand.getName().toUpperCase();
                                if (!theCmdExt.hasCodeMarks()) break block27;
                                List<EPPLaunchCodeMark> codeMarks = theCmdExt.getCodeMarks();
                                if (codeMarks.size() == 0) {
                                    return this.returnError(2306, theCommand.getTransId(), "No codeMarks provided");
                                }
                                i$ = codeMarks.iterator();
                                break block28;
                            }
                            if (!theCmdExt.hasSignedMarks()) {
                                return this.returnError(2306, theCommand.getTransId(), "No mark information provided");
                            }
                            List<EPPSignedMark> signedMarks = theCmdExt.getSignedMarks();
                            if (signedMarks.size() == 0) {
                                return this.returnError(2306, theCommand.getTransId(), "No signed marks provided");
                            }
                            for (EPPSignedMark signedMark : signedMarks) {
                                signedMark.setBase64Encode(false);
                                cat.debug((Object)("LaunchDomainHandler.doDomainCreate: signedMark = [" + signedMark + "]"));
                                if (!signedMark.validate(this.pkixParameters)) {
                                    return this.returnError(2004, theCommand.getTransId(), "Signed mark signature invalid");
                                }
                                cat.debug((Object)"LaunchDomainHandler.doDomainCreate: Signature is valid");
                            }
                            break block29;
                        }
                        if (phase.equals("claims")) {
                            if (theCmdExt.hasNotice()) {
                                EPPLaunchNotice notice = theCmdExt.getNotice();
                                cat.debug((Object)("LaunchDomainHandler.doDomainCreate: notice id = [" + notice.getNoticeId() + "]"));
                                cat.debug((Object)("LaunchDomainHandler.doDomainCreate: notice not after date = [" + EPPUtil.encodeTimeInstant(notice.getNotAfterDate()) + "]"));
                                cat.debug((Object)("LaunchDomainHandler.doDomainCreate: notice accepted date = [" + EPPUtil.encodeTimeInstant(notice.getAcceptedDate()) + "]"));
                            }
                            if (isApp) {
                                Random random = new Random();
                                String applicationId = "" + System.currentTimeMillis() + "-" + random.nextInt();
                                EPPLaunchCreData respExt = new EPPLaunchCreData(theCmdExt.getPhase(), applicationId);
                                theEventResponse = super.doDomainCreate(aEvent, aData);
                                EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
                                theResponse.addExtension(respExt);
                                theResponse.setResult(1001);
                                break block24;
                            } else {
                                theEventResponse = super.doDomainCreate(aEvent, aData);
                            }
                            break block24;
                        } else {
                            cat.debug((Object)("LaunchDomainHandler.doDomainCreate: phase = " + phase));
                            if (isApp) {
                                Random random = new Random();
                                String applicationId = "" + System.currentTimeMillis() + "-" + random.nextInt();
                                EPPLaunchCreData respExt = new EPPLaunchCreData(theCmdExt.getPhase(), applicationId);
                                theEventResponse = super.doDomainCreate(aEvent, aData);
                                EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
                                theResponse.addExtension(respExt);
                                theResponse.setResult(1001);
                                break block24;
                            } else {
                                theEventResponse = super.doDomainCreate(aEvent, aData);
                            }
                        }
                        break block24;
                    }
                    theEventResponse = super.doDomainCreate(aEvent, aData);
                    break block24;
                }
                while (i$.hasNext()) {
                    EPPLaunchCodeMark codeMark = (EPPLaunchCodeMark)i$.next();
                    if (codeMark.hasCodeMark()) {
                        cat.debug((Object)("LaunchDomainHandler.doDomainCreate: code = [" + codeMark.getCode() + "]"));
                        cat.debug((Object)("LaunchDomainHandler.doDomainCreate: mark = [" + codeMark.getMark() + "]"));
                        continue;
                    }
                    if (codeMark.hasCode()) {
                        cat.debug((Object)("LaunchDomainHandler.doDomainCreate: code = [" + codeMark.getCode() + "]"));
                        continue;
                    }
                    if (!codeMark.hasMark()) {
                        return this.returnError(2004, theCommand.getTransId(), "codeMark does not having any codes or marks");
                    }
                    cat.debug((Object)("LaunchDomainHandler.doDomainCreate: mark = [" + codeMark.getMark() + "]"));
                }
            }
            theEventResponse = super.doDomainCreate(aEvent, aData);
            EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
            if (isApp) {
                Random random = new Random();
                String applicationId = "" + System.currentTimeMillis() + "-" + random.nextInt();
                EPPLaunchCreData respExt = new EPPLaunchCreData(theCmdExt.getPhase(), applicationId);
                theResponse.addExtension(respExt);
                theResponse.setResult(1001);
                try {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), "54322-XYZ");
                    if (theCommand.getName().equals("APPPENDINGALLOCATION.TLD")) {
                        EPPDomainInfoResp thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setTransId(transId);
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("validated")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setTransId(transId);
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("pendingAllocation")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        break block24;
                    }
                    if (theCommand.getName().equals("APPREJECTEDINVALID.TLD")) {
                        EPPDomainInfoResp thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setTransId(transId);
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("invalid")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        EPPResponse cmdResp = (EPPResponse)theEventResponse.getResponse();
                        EPPTransId cmdRespTransId = (EPPTransId)cmdResp.getTransId().clone();
                        EPPDomainPendActionMsg thePendActionPollMsg = new EPPDomainPendActionMsg(transId, theCommand.getName(), false, cmdRespTransId, new Date());
                        thePendActionPollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("rejected")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePendActionPollMsg, null);
                        break block24;
                    }
                    if (theCommand.getName().equals("APPALLOCATEDALLSTATES.TLD")) {
                        EPPDomainInfoResp thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("validated")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("pendingAllocation")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        EPPResponse cmdResp = (EPPResponse)theEventResponse.getResponse();
                        EPPTransId cmdRespTransId = (EPPTransId)cmdResp.getTransId().clone();
                        EPPDomainPendActionMsg thePendActionPollMsg = new EPPDomainPendActionMsg(transId, theCommand.getName(), true, cmdRespTransId, new Date());
                        thePendActionPollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("allocated")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePendActionPollMsg, null);
                    }
                }
                catch (EPPPollQueueException ex) {
                    return this.returnError(2400, theCommand.getTransId(), "Poll queue error: " + ex);
                }
                catch (CloneNotSupportedException ex) {
                    return this.returnError(2400, theCommand.getTransId(), "Error cloning object: " + ex);
                }
            }
        }
        cat.debug((Object)"LaunchDomainHandler.doDomainDelete: exit");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"LaunchDomainHandler.doDomainDelete: enter");
        EPPDomainDeleteCmd theCommand = (EPPDomainDeleteCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPLaunchDelete.class)) {
            EPPLaunchDelete theCmdExt = (EPPLaunchDelete)theCommand.getExtension(EPPLaunchDelete.class);
            String applicationId = theCmdExt.getApplicationId();
            String phase = theCmdExt.getPhase().getPhase();
            if (phase.equals("sunrise") || phase.equals("landrush")) {
                if (applicationId != null) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
                    EPPResponse theResponse = new EPPResponse(transId);
                    theResponse.setResult(1000);
                    cat.debug((Object)"LaunchDomainHandler.doDomainDelete: exit - application");
                    return new EPPEventResponse(theResponse);
                }
                return this.returnError(2306, theCommand.getTransId(), "Delete with " + phase + " phase must include applicationId");
            }
            return this.returnError(2306, theCommand.getTransId(), "Unsupported Delete Phase = " + phase);
        }
        cat.debug((Object)"LaunchDomainHandler.doDomainDelete: No EPPLaunchDelete extension passed");
        EPPEventResponse theEventResponse = super.doDomainDelete(aEvent, aData);
        cat.debug((Object)"LaunchDomainHandler.doDomainDelete: exit");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"LaunchDomainHandler.doDomainUpdate: enter");
        EPPDomainUpdateCmd theCommand = (EPPDomainUpdateCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPLaunchUpdate.class)) {
            EPPLaunchUpdate theCmdExt = (EPPLaunchUpdate)theCommand.getExtension(EPPLaunchUpdate.class);
            String applicationId = theCmdExt.getApplicationId();
            String phase = theCmdExt.getPhase().getPhase();
            if (phase.equals("sunrise") || phase.equals("landrush")) {
                if (applicationId != null) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
                    EPPResponse theResponse = new EPPResponse(transId);
                    theResponse.setResult(1000);
                    cat.debug((Object)"LaunchDomainHandler.doDomainUpdate: exit - application");
                    return new EPPEventResponse(theResponse);
                }
                return this.returnError(2306, theCommand.getTransId(), "Update with " + phase + " phase must include applicationId");
            }
            return this.returnError(2306, theCommand.getTransId(), "Unsupported Update Phase = " + phase);
        }
        cat.debug((Object)"LaunchDomainHandler.doDomainUpdate: No EPPLaunchUpdate extension passed");
        EPPEventResponse theEventResponse = super.doDomainUpdate(aEvent, aData);
        cat.debug((Object)"LaunchDomainHandler.doDomainUpdate: exit");
        return theEventResponse;
    }
}

