/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.namestore.interfaces;

import com.verisign.epp.codec.coaext.EPPCoaExtAttr;
import com.verisign.epp.codec.coaext.EPPCoaExtInfData;
import com.verisign.epp.codec.coaext.EPPCoaExtKey;
import com.verisign.epp.codec.coaext.EPPCoaExtValue;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheck;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheckResp;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheckResult;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainReAssignCmd;
import com.verisign.epp.codec.rgpext.EPPRgpExtInfData;
import com.verisign.epp.codec.rgpext.EPPRgpExtReport;
import com.verisign.epp.codec.rgpext.EPPRgpExtReportText;
import com.verisign.epp.codec.rgpext.EPPRgpExtStatus;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtInfData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtKeyData;
import com.verisign.epp.codec.whois.EPPWhoisInfData;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.namestore.interfaces.NSDomain;
import com.verisign.epp.pool.EPPSessionPool;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.InvalidateSessionException;
import com.verisign.epp.util.TestThread;
import com.verisign.epp.util.TestUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class NSDomainTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)NSDomainTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static EPPSessionPool sessionPool = null;
    private Random rd = new Random(System.currentTimeMillis());

    public NSDomainTst(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainCreate() {
        NSDomainTst.printStart("testDomainCreate");
        EPPSession theSession = null;
        EPPDomainCreateResp theResponse = null;
        try {
            ArrayList<EPPSecDNSExtDsData> dsDataRecords;
            EPPSecDNSExtDsData dsData2;
            EPPSecDNSExtDsData dsData;
            EPPSecDNSExtKeyData keyData2;
            String theDomainName;
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with no optional attributes");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with all optional attributes");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                for (int i = 0; i <= 20; ++i) {
                    theDomain.addHostName(this.makeHostName(theDomainName));
                }
                if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                    theDomain.addContact("SH0000", "admin");
                    theDomain.addContact("SH0000", "tech");
                    theDomain.addContact("SH0000", "billing");
                }
                theDomain.setPeriodLength(10);
                theDomain.setPeriodUnit("y");
                theDomain.setAuthString("ClientX");
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with SecDNS Extension");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
                keyData.setFlags(257);
                keyData.setProtocol(3);
                keyData.setAlg(5);
                keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
                keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
                dsData = new EPPSecDNSExtDsData();
                dsData.setKeyTag(34095);
                dsData.setAlg(5);
                dsData.setDigestType(1);
                dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
                dsData.setKeyData(keyData);
                dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", keyData2);
                dsDataRecords = new ArrayList<EPPSecDNSExtDsData>();
                dsDataRecords.add(dsData);
                dsDataRecords.add(dsData2);
                theDomain.setSecDNSCreate(dsDataRecords);
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with SecDNS and COA Extensions");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
                keyData.setFlags(257);
                keyData.setProtocol(3);
                keyData.setAlg(5);
                keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
                keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
                dsData = new EPPSecDNSExtDsData();
                dsData.setKeyTag(34095);
                dsData.setAlg(5);
                dsData.setDigestType(1);
                dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
                dsData.setKeyData(keyData);
                dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", keyData2);
                dsDataRecords = new ArrayList();
                dsDataRecords.add(dsData);
                dsDataRecords.add(dsData2);
                theDomain.setSecDNSCreate(dsDataRecords);
                EPPCoaExtKey key = new EPPCoaExtKey("KEY1");
                EPPCoaExtValue value = new EPPCoaExtValue("value1");
                EPPCoaExtAttr attr = new EPPCoaExtAttr();
                attr.setKey(key);
                attr.setValue(value);
                ArrayList<EPPCoaExtAttr> attrList = new ArrayList<EPPCoaExtAttr>();
                attrList.add(attr);
                theDomain.setCoaCreate(attrList);
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with COA Extension");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                EPPCoaExtKey key = new EPPCoaExtKey("KEY1");
                EPPCoaExtValue value = new EPPCoaExtValue("value1");
                EPPCoaExtAttr attr = new EPPCoaExtAttr();
                attr.setKey(key);
                attr.setValue(value);
                ArrayList<EPPCoaExtAttr> attrList = new ArrayList<EPPCoaExtAttr>();
                attrList.add(attr);
                theDomain.setCoaCreate(attrList);
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainCreate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateDsDataInterface() {
        NSDomainTst.printStart("testCreateDsDataInterface");
        EPPSession theSession = null;
        EPPDomainCreateResp theResponse = null;
        try {
            ArrayList<EPPSecDNSExtDsData> dsDataList;
            String theDomainName;
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = this.makeDomainName();
                System.out.println("testCreateDsDataInterface(1): domain = " + theDomainName + ", Create for a Secure Delegation using the DS Data Interface with one DS");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                dsDataList = new ArrayList<EPPSecDNSExtDsData>();
                dsDataList.add(new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC"));
                theDomain.setSecDNSCreate(dsDataList);
                theResponse = theDomain.sendCreate();
                System.out.println("testCreateDsDataInterface(1): Response = [" + theResponse + "]\n\n");
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("testCreateDsDataInterface(2): domain = " + theDomainName + ", Create for a Secure Delegation using the DS Data Interface with two DS");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                dsDataList = new ArrayList();
                dsDataList.add(new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC"));
                EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
                keyData.setFlags(257);
                keyData.setProtocol(3);
                keyData.setAlg(5);
                keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
                dsDataList.add(keyData.toDsData("testCreateDsDataInterface.com", 1));
                theDomain.setSecDNSCreate(dsDataList);
                theResponse = theDomain.sendCreate();
                System.out.println("testCreateDsDataInterface(2): Response = [" + theResponse + "]\n\n");
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testCreateDsDataInterface");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateDsDataInterface() {
        NSDomainTst.printStart("testUpdateDsDataInterface");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            ArrayList<EPPSecDNSExtDsData> addDsDataList;
            String theDomainName;
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = this.makeDomainName();
                System.out.println("testUpdateDsDataInterface(1): domain = " + theDomainName + ", Adding and Removing DS Data using the DS Data Interface");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                addDsDataList = new ArrayList<EPPSecDNSExtDsData>();
                addDsDataList.add(new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC"));
                ArrayList<EPPSecDNSExtDsData> remDsDataList = new ArrayList<EPPSecDNSExtDsData>();
                remDsDataList.add(new EPPSecDNSExtDsData(12345, 3, 1, "38EC35D5B3A34B44C39B"));
                theDomain.setSecDNSUpdate(addDsDataList, remDsDataList);
                theResponse = theDomain.sendUpdate();
                System.out.println("testUpdateDsDataInterface(1): Response = [" + theResponse + "]\n\n");
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("testUpdateDsDataInterface(2): domain = " + theDomainName + ", Remove all DS and Key Data using <secDNS:rem> with <secDNS:all>");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                theDomain.setSecDNSUpdate(null, NSDomain.REM_ALL_DS);
                theResponse = theDomain.sendCreate();
                System.out.println("testUpdateDsDataInterface(2): Response = [" + theResponse + "]\n\n");
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("testUpdateDsDataInterface(3): domain = " + theDomainName + ", Replacing all DS Data using the DS Data Interface");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                addDsDataList = new ArrayList();
                addDsDataList.add(new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC"));
                theDomain.setSecDNSUpdate(addDsDataList, NSDomain.REM_ALL_DS);
                theResponse = theDomain.sendCreate();
                System.out.println("testUpdateDsDataInterface(3): Response = [" + theResponse + "]\n\n");
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testUpdateDsDataInterface");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainCheck() {
        NSDomainTst.printStart("testDomainCheck");
        EPPSession theSession = null;
        EPPDomainCheckResp theResponse = null;
        try {
            String theDomainName;
            EPPDomainCheckResult currResult;
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                String theDomainName2 = this.makeDomainName();
                System.out.println("domainCheck: Check single domain name (" + theDomainName2 + ")");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName2);
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendCheck();
                System.out.println("Response Type = " + theResponse.getType());
                System.out.println("Response.TransId.ServerTransId = " + theResponse.getTransId().getServerTransId());
                System.out.println("Response.TransId.ServerTransId = " + theResponse.getTransId().getClientTransId());
                System.out.println("\ndomainCheck: Response = [" + theResponse + "]");
                for (int i = 0; i < theResponse.getCheckResults().size(); ++i) {
                    currResult = (EPPDomainCheckResult)theResponse.getCheckResults().elementAt(i);
                    if (currResult.isAvailable()) {
                        System.out.println("domainCheck: Domain " + currResult.getName() + " is available");
                        continue;
                    }
                    System.out.println("domainCheck: Domain " + currResult.getName() + " is not available");
                }
                this.handleResponse(theResponse);
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                int i;
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("domainCheck: Check multiple domain names (example1.com, example2.com, example3.com)");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName("example1.com");
                theDomain.addDomainName("example2.com");
                theDomain.addDomainName("example3.com");
                theDomain.setSubProductID("dotCOM");
                for (i = 0; i <= 10; ++i) {
                    theDomain.addDomainName(this.makeDomainName());
                }
                theResponse = theDomain.sendCheck();
                System.out.println("\ndomainCheck: Response = [" + theResponse + "]");
                System.out.println("Client Transaction Id = " + theResponse.getTransId().getClientTransId());
                System.out.println("Server Transaction Id = " + theResponse.getTransId().getServerTransId());
                for (i = 0; i < theResponse.getCheckResults().size(); ++i) {
                    EPPDomainCheckResult currResult2 = (EPPDomainCheckResult)theResponse.getCheckResults().elementAt(i);
                    if (currResult2.isAvailable()) {
                        System.out.println("domainCheck: Domain " + currResult2.getName() + " is available");
                        continue;
                    }
                    System.out.println("domainCheck: Domain " + currResult2.getName() + " is not available");
                }
                this.handleResponse(theResponse);
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = "non-premiumdomain.tv";
                System.out.println("nonPremiumDomainCheck: Check single domain name With Flag True (" + theDomainName + ")");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotTV");
                EPPPremiumDomainCheck extension = new EPPPremiumDomainCheck(true);
                theDomain.addExtension(extension);
                theResponse = theDomain.sendCheck();
                System.out.println("\nnonPremiumDomainCheck: Response = [" + theResponse + "]");
                this.handleResponse(theResponse);
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = "premium.tv";
                System.out.println("premiumDomainCheck: Check single domain name With Flag True (" + theDomainName + ")");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotTV");
                EPPPremiumDomainCheck extension = new EPPPremiumDomainCheck(true);
                theDomain.addExtension(extension);
                theResponse = theDomain.sendCheck();
                System.out.println("\npremiumDomainCheck: Response = [" + theResponse + "]");
                this.handleResponse(theResponse);
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("premiumDomainCheck: Check multiple domain names With Flag True ");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.setSubProductID("dotTV");
                for (int i = 1; i <= 3; ++i) {
                    theDomain.addDomainName("premium" + i + ".tv");
                }
                EPPPremiumDomainCheck extension = new EPPPremiumDomainCheck(true);
                theDomain.addExtension(extension);
                theResponse = theDomain.sendCheck();
                System.out.println("\npremiumDomainCheck: Response = [" + theResponse + "]");
                for (int i = 0; i < theResponse.getCheckResults().size(); ++i) {
                    currResult = (EPPDomainCheckResult)theResponse.getCheckResults().elementAt(i);
                    if (currResult.isAvailable()) {
                        System.out.println("domainCheck: Domain " + currResult.getName() + " is available");
                        continue;
                    }
                    System.out.println("domainCheck: Domain " + currResult.getName() + " is not available");
                }
                if (theResponse.hasExtension(EPPPremiumDomainCheckResp.class)) {
                    EPPPremiumDomainCheckResp premiumDomainCheckResponse = (EPPPremiumDomainCheckResp)theResponse.getExtension(EPPPremiumDomainCheckResp.class);
                    for (int i = 0; i < premiumDomainCheckResponse.getCheckResults().size(); ++i) {
                        EPPPremiumDomainCheckResult currResult3 = (EPPPremiumDomainCheckResult)premiumDomainCheckResponse.getCheckResults().elementAt(i);
                        if (currResult3.isPremium()) {
                            System.out.println("domainCheck: Domain " + currResult3.getName() + " is premium");
                            if (currResult3.getPrice() == null) continue;
                            System.out.println("domainCheck: Premium price is $" + currResult3.getPrice());
                            System.out.println("domainCheck: Premium renewal price is $" + currResult3.getRenewalPrice());
                            continue;
                        }
                        System.out.println("domainCheck: Domain " + currResult3.getName() + " is not premium");
                    }
                }
                this.handleResponse(theResponse);
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainCheck");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainInfo() {
        NSDomainTst.printStart("testDomainInfo");
        EPPSession theSession = null;
        EPPDomainInfoResp theResponse = null;
        try {
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                int i;
                System.out.println("\ndomainInfo: Standard Domain info");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(this.makeDomainName());
                theDomain.setSubProductID("dotCOM");
                theDomain.setHosts("all");
                theResponse = theDomain.sendInfo();
                System.out.println("domainInfo: Response = [" + theResponse + "]\n\n");
                System.out.println("domainInfo: name            = " + theResponse.getName());
                System.out.println("domainInfo: client id       = " + theResponse.getClientId());
                System.out.println("domainInfo: created by      = " + theResponse.getCreatedBy());
                System.out.println("domainInfo: create date     = " + theResponse.getCreatedDate());
                System.out.println("domainInfo: expiration date = " + theResponse.getExpirationDate());
                System.out.println("domainInfo: Registrant      = " + theResponse.getRegistrant());
                if (theResponse.getContacts() != null) {
                    for (i = 0; i < theResponse.getContacts().size(); ++i) {
                        EPPDomainContact myContact = (EPPDomainContact)theResponse.getContacts().elementAt(i);
                        System.out.println("Contact Name : " + myContact.getName());
                        System.out.println("Contact Type : " + myContact.getType());
                    }
                }
                if (theResponse.getAuthInfo() != null) {
                    System.out.println("Authorization        : " + theResponse.getAuthInfo().getPassword());
                    System.out.println("Authorization (Roid) : " + theResponse.getAuthInfo().getRoid());
                }
                if (theResponse.getHosts() != null) {
                    for (i = 0; i < theResponse.getHosts().size(); ++i) {
                        System.out.println("Host Name : " + theResponse.getHosts().elementAt(i));
                    }
                }
                if (theResponse.getNses() != null) {
                    for (i = 0; i < theResponse.getNses().size(); ++i) {
                        System.out.println("Name Server : " + theResponse.getNses().elementAt(i));
                    }
                }
                if (theResponse.getStatuses() != null) {
                    for (i = 0; i < theResponse.getStatuses().size(); ++i) {
                        EPPDomainStatus myStatus = (EPPDomainStatus)theResponse.getStatuses().elementAt(i);
                        System.out.println("Lang     : " + myStatus.getLang());
                        System.out.println("Status   : " + myStatus.getStatus());
                    }
                }
                this.handleResponse(theResponse);
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\ndomainInfo: Domain info with whois information");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(this.makeDomainName());
                theDomain.setSubProductID("dotCOM");
                theDomain.setWhoisInfo(true);
                theResponse = theDomain.sendInfo();
                System.out.println("domainInfo: Response = [" + theResponse + "]\n\n");
                if (theResponse.hasExtension(EPPWhoisInfData.class)) {
                    EPPWhoisInfData theWhoisInf = (EPPWhoisInfData)theResponse.getExtension(EPPWhoisInfData.class);
                    System.out.println("domainInfo: registrar    = " + theWhoisInf.getRegistrar());
                    System.out.println("domainInfo: whois server = " + theWhoisInf.getWhoisServer());
                    System.out.println("domainInfo: url          = " + theWhoisInf.getURL());
                    System.out.println("domainInfo: iris server  = " + theWhoisInf.getIrisServer());
                }
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\ndomainInfo: Domain info with SecDNS extension");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName("secdns.com");
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendInfo();
                System.out.println("domainInfo: Response DNSSEC = [" + theResponse + "]\n\n");
                if (theResponse.hasExtension(EPPSecDNSExtInfData.class)) {
                    EPPSecDNSExtInfData infData = (EPPSecDNSExtInfData)theResponse.getExtension(EPPSecDNSExtInfData.class);
                    List dsDataVec = infData.getDsData();
                    EPPSecDNSExtDsData dsData2 = null;
                    if (dsDataVec == null) {
                        System.out.println("domainInfo: secDNS:infData dsDataVec = " + dsDataVec);
                    } else {
                        int i = 0;
                        for (EPPSecDNSExtDsData dsData2 : dsDataVec) {
                            System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyTag = " + dsData2.getKeyTag());
                            System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/alg = " + dsData2.getAlg());
                            System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/digestType = " + dsData2.getDigestType());
                            System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/digest = " + dsData2.getDigest());
                            EPPSecDNSExtKeyData keyData = dsData2.getKeyData();
                            if (keyData == null) {
                                System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData = " + keyData);
                            } else {
                                System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData/flags = " + keyData.getFlags());
                                System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData/protocol = " + keyData.getProtocol());
                                System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData/alg = " + keyData.getAlg());
                                System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData/pubKey = " + keyData.getPubKey());
                            }
                            ++i;
                        }
                    }
                } else {
                    Assert.fail((String)"domainInfo: no EPPSecDNSExtInfData extension");
                }
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\ndomainInfo: Domain info with COA extension");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName("coa-full-info-owned.com");
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendInfo();
                System.out.println("domainInfo: Response COA = [" + theResponse + "]\n\n");
                if (theResponse.hasExtension(EPPCoaExtInfData.class)) {
                    EPPCoaExtInfData coaInfData = (EPPCoaExtInfData)theResponse.getExtension(EPPCoaExtInfData.class);
                    for (EPPCoaExtAttr attr : coaInfData.getAttrs()) {
                        String key = attr.getKey().getKey();
                        String value = attr.getValue().getValue();
                        System.out.println("Client Object Attribute: key='" + key + "', value='" + value + "'");
                    }
                } else {
                    Assert.fail((String)"domainInfo: no EPPCoaExtInfData extension");
                }
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\ndomainInfo: Domain info for domain with RGP statuses");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName("graceperiod.com");
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendInfo();
                System.out.println("domainInfo: Response for graceperiod.com = [" + theResponse + "]\n\n");
                this.printRgpStatuses(theResponse);
                theDomain.addDomainName("pendingperiod.com");
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendInfo();
                System.out.println("domainInfo: Response for pendingperiod.com = [" + theResponse + "]\n\n");
                this.printRgpStatuses(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainDelete() {
        NSDomainTst.printStart("testDomainDelete");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                System.out.println("\ndomainDelete: Domain delete");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(this.makeDomainName());
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendDelete();
                System.out.println("domainDelete: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainDelete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainRenew() {
        NSDomainTst.printStart("testDomainRenew");
        EPPSession theSession = null;
        EPPDomainRenewResp theResponse = null;
        try {
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                String theDomainName = this.makeDomainName();
                System.out.println("\ndomainRenew: Domain " + theDomainName + " renew");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setExpirationDate(new GregorianCalendar(2004, 2, 3).getTime());
                theDomain.setPeriodLength(10);
                theDomain.setPeriodUnit("y");
                theResponse = theDomain.sendRenew();
                System.out.println("domainRenew: Response = [" + theResponse + "]\n\n");
                System.out.println("domainRenew: name = " + theResponse.getName());
                System.out.println("domainRenew: expiration date = " + theResponse.getExpirationDate());
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            this.handleResponse(theResponse);
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainRenew");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainUpdate() {
        NSDomainTst.printStart("testDomainUpdate");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            String theDomainName;
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("\ndomainUpdate: Domain " + theDomainName + " update");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                    theDomain.setUpdateAttrib(1, "SH0000", "billing", 1);
                }
                theDomain.setUpdateAttrib(0, this.makeHostName(theDomainName), 1);
                theDomain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 1);
                theDomain.setUpdateAttrib(0, this.makeHostName(theDomainName), 2);
                theDomain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 2);
                if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                    theDomain.setUpdateAttrib(1, "SH0000", "billing", 2);
                }
                theDomain.setAuthString("new-auth-info-123");
                theResponse = theDomain.sendUpdate();
                System.out.println("domainUpdate: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("\ndomainUpdate: Domain " + theDomainName + " update/add with SecDNS extension");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
                keyData.setFlags(257);
                keyData.setProtocol(3);
                keyData.setAlg(5);
                keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
                EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
                EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
                dsData.setKeyTag(34095);
                dsData.setAlg(5);
                dsData.setDigestType(1);
                dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
                dsData.setKeyData(keyData);
                EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", keyData2);
                ArrayList<EPPSecDNSExtDsData> addDsData = new ArrayList<EPPSecDNSExtDsData>();
                addDsData.add(dsData);
                addDsData.add(dsData2);
                theDomain.setSecDNSUpdate(addDsData, null);
                theResponse = theDomain.sendUpdate();
                System.out.println("domainUpdate: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
                theDomain.setTransId("ABC-12345-XYZ-2");
                theDomainName = this.makeDomainName();
                System.out.println("\ndomainUpdate: Domain " + theDomainName + " update/add with SecDNS extension and urgent = true");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setSecDNSUpdate(addDsData, null);
                theResponse = theDomain.sendUpdate();
                System.out.println("domainUpdate: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("\ndomainUpdate: Domain " + theDomainName + " update/rem with SecDNS extension");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
                dsData.setKeyTag(34095);
                dsData.setAlg(5);
                dsData.setDigestType(1);
                dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
                EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B");
                ArrayList<EPPSecDNSExtDsData> rmvDsData = new ArrayList<EPPSecDNSExtDsData>();
                rmvDsData.add(dsData);
                rmvDsData.add(dsData2);
                theDomain.setSecDNSUpdate(null, rmvDsData);
                theResponse = theDomain.sendUpdate();
                System.out.println("domainUpdate: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = "premium.tv";
                System.out.println("\npremiumDomainUpdate: Domain " + theDomainName + " update with ReAssign extension");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotTV");
                EPPPremiumDomainReAssignCmd extension = new EPPPremiumDomainReAssignCmd();
                extension.setShortName("testregistrar");
                theDomain.addExtension(extension);
                theResponse = theDomain.sendUpdate();
                System.out.println("domainUpdate: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainTransfer() {
        NSDomainTst.printStart("testDomainTransfer");
        EPPSession theSession = null;
        EPPDomainTransferResp theResponse = null;
        try {
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            String theDomainName = this.makeDomainName();
            try {
                System.out.println("\ndomainTransfer: Domain " + theDomainName + " transfer request");
                theDomain.setTransferOpCode("request");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.setAuthString("ClientX");
                theDomain.addDomainName(this.makeDomainName());
                theDomain.setSubProductID("dotCOM");
                theDomain.setPeriodLength(10);
                theDomain.setPeriodUnit("y");
                theResponse = theDomain.sendTransfer();
                System.out.println("domainTransfer: Response = [" + theResponse + "]\n\n");
                System.out.println("domainTransfer: name = " + theResponse.getName());
                System.out.println("domainTransfer: request client = " + theResponse.getRequestClient());
                System.out.println("domainTransfer: action client = " + theResponse.getActionClient());
                System.out.println("domainTransfer: transfer status = " + theResponse.getTransferStatus());
                System.out.println("domainTransfer: request date = " + theResponse.getRequestDate());
                System.out.println("domainTransfer: action date = " + theResponse.getActionDate());
                if (theResponse.getExpirationDate() != null) {
                    System.out.println("domainTransfer: expiration date = " + theResponse.getExpirationDate());
                }
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("\ndomainTransfer: Domain " + theDomainName + " transfer query");
                theDomain.setTransferOpCode("query");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendTransfer();
                System.out.println("domainTransferQuery: Response = [" + theResponse + "]\n\n");
                System.out.println("domainTransferQuery: name = " + theResponse.getName());
                System.out.println("domainTransferQuery: request client = " + theResponse.getRequestClient());
                System.out.println("domainTransferQuery: action client = " + theResponse.getActionClient());
                System.out.println("domainTransferQuery: transfer status = " + theResponse.getTransferStatus());
                System.out.println("domainTransferQuery: request date = " + theResponse.getRequestDate());
                System.out.println("domainTransferQuery: action date = " + theResponse.getActionDate());
                if (theResponse.getExpirationDate() != null) {
                    System.out.println("domainTransferQuery: expiration date = " + theResponse.getExpirationDate());
                }
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("\ndomainTransfer: Domain " + theDomainName + " transfer cancel");
                theDomain.setTransferOpCode("cancel");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendTransfer();
                System.out.println("domainTransfer: Response = [" + theResponse + "]\n\n");
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("\ndomainTransfer: Domain " + theDomainName + " transfer reject");
                theDomain.setTransferOpCode("reject");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendTransfer();
                System.out.println("domainTransfer: Response = [" + theResponse + "]\n\n");
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("\ndomainTransfer: Domain transfer approve");
                theDomain.setTransferOpCode("approve");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendTransfer();
                System.out.println("domainTransfer: Response = [" + theResponse + "]\n\n");
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainTransfer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainSync() {
        NSDomainTst.printStart("testDomainSync");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                String theDomainName = this.makeDomainName();
                System.out.println("\ndomainSync: Domain " + theDomainName + " sync");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setDay(15);
                theDomain.setMonth(5);
                theResponse = theDomain.sendSync();
                System.out.println("domainSync: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainSync");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainRestoreRequest() {
        NSDomainTst.printStart("testDomainRestoreRequest");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            String theDomainName = this.makeDomainName();
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                System.out.println("\ndomainRestoreRequest: Domain " + theDomainName + " restore request");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theResponse = theDomain.sendRestoreRequest();
                System.out.println("domainRestoreRequest: Response = [" + theResponse + "]\n\n");
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            this.handleResponse(theResponse);
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainRestoreRequest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainRestoreReport() {
        NSDomainTst.printStart("testDomainRestoreReport");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            String theDomainName = this.makeDomainName();
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                System.out.println("\ndomainRestoreReport: Domain " + theDomainName + " restore request");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                EPPRgpExtReport theReport = new EPPRgpExtReport();
                theReport.setPreData("Pre-delete whois data goes here. Both XML and free text are allowed");
                theReport.setPostData("Post-delete whois data goes here. Both XML and free text are allowed");
                theReport.setDeleteTime(new Date());
                theReport.setRestoreTime(new Date());
                theReport.setRestoreReason(new EPPRgpExtReportText("Registrant Error"));
                theReport.setStatement1(new EPPRgpExtReportText("This registrar has not restored the Registered Domain in order to assume the rights to use or sell the Registered Name for itself or for any third party"));
                theReport.setStatement2(new EPPRgpExtReportText("The information in this report  is true to best of this registrar's knowledge, and thisregistrar acknowledges that intentionally supplying false information in this report shall constitute  an incurable material breach of the Registry-Registrar Agreement"));
                theReport.setOther("other stuff");
                theDomain.setReport(theReport);
                theResponse = theDomain.sendRestoreReport();
                System.out.println("domainRestoreReport: Response = [" + theResponse + "]\n\n");
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            this.handleResponse(theResponse);
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainRestoreReport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainIDNCreate() {
        NSDomainTst.printStart("testDomainIDNCreate");
        EPPSession theSession = null;
        EPPDomainCreateResp theResponse = null;
        try {
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                String theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with IDN tag");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                theDomain.setIDNLangTag("en");
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainIDNCreate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEndSession() {
        NSDomainTst.printStart("testEndSession");
        EPPSession theSession = null;
        try {
            theSession = this.borrowSession();
            sessionPool.invalidateObject(theSession);
            theSession = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("testEndSession(): Exception invalidating session: " + ex));
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testEndSession");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncCommands() {
        NSDomainTst.printStart("testAsyncCommands");
        EPPSession theSession = null;
        int previousSessionMode = 0;
        try {
            String theClientTransId;
            ArrayList<String> clientTransIdQueue = new ArrayList<String>();
            theSession = this.borrowSession();
            if (!theSession.isModeSupported(1)) {
                System.out.println("testAsyncCommands: Session " + theSession.getClass().getName() + " does not support MODE_ASYNC, skipping test");
                NSDomainTst.printEnd("testAsyncCommands (skipped)");
                return;
            }
            previousSessionMode = theSession.setMode(1);
            NSDomain theDomain = new NSDomain(theSession);
            String theDomainName = this.makeDomainName();
            try {
                theClientTransId = "ASYNC-CMD-" + System.currentTimeMillis();
                clientTransIdQueue.add(theClientTransId);
                theDomain.setTransId(theClientTransId);
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                System.out.println("domainCheck: Async check of domain name (" + theDomainName + ")");
                theDomain.sendCheck();
                theClientTransId = "ASYNC-CMD-" + System.currentTimeMillis();
                clientTransIdQueue.add(theClientTransId);
                theDomain.setTransId(theClientTransId);
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                System.out.println("domainCheck: Async create of domain name (" + theDomainName + ")");
                theDomain.sendCreate();
                theClientTransId = "ASYNC-CMD-" + System.currentTimeMillis();
                clientTransIdQueue.add(theClientTransId);
                theDomain.setTransId(theClientTransId);
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                System.out.println("domainCheck: Async delete of domain name (" + theDomainName + ")");
                theDomain.sendDelete();
            }
            catch (EPPCommandException ex) {
                Assert.fail((String)("testAsyncCommands(): Exception sending asynchronous command: " + ex));
            }
            try {
                while (clientTransIdQueue.size() > 0) {
                    theClientTransId = (String)clientTransIdQueue.get(0);
                    clientTransIdQueue.remove(0);
                    EPPResponse theResponse = theSession.readResponse();
                    if (theClientTransId.equals(theResponse.getTransId().getClientTransId())) {
                        System.out.println("Successfully received client transaction id " + theClientTransId + " asynchronously");
                        continue;
                    }
                    Assert.fail((String)("testAsyncCommands(): Received response with client transid " + theResponse.getTransId().getClientTransId() + " != expected transid " + theClientTransId));
                }
            }
            catch (EPPCommandException ex) {
                Assert.fail((String)("testAsyncCommands(): Exception receiving asynchronous response: " + ex));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("testAsyncCommands(): Exception invalidating session: " + ex));
        }
        finally {
            if (theSession != null) {
                theSession.setMode(previousSessionMode);
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testAsyncCommands");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSecDNS10() {
        NSDomainTst.printStart("testSecDNS10");
        EPPSession theSession = null;
        EPPDomainCreateResp theResponse = null;
        try {
            String theDomainName;
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with no optional attributes");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with all optional attributes");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                for (int i = 0; i <= 20; ++i) {
                    theDomain.addHostName(this.makeHostName(theDomainName));
                }
                if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                    theDomain.addContact("SH0000", "admin");
                    theDomain.addContact("SH0000", "tech");
                    theDomain.addContact("SH0000", "billing");
                }
                theDomain.setPeriodLength(10);
                theDomain.setPeriodUnit("y");
                theDomain.setAuthString("ClientX");
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                System.out.println("\n----------------------------------------------------------------");
                theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with SecDNS Extension");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
                keyData.setFlags(257);
                keyData.setProtocol(3);
                keyData.setAlg(5);
                keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
                EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
                EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
                dsData.setKeyTag(34095);
                dsData.setAlg(5);
                dsData.setDigestType(1);
                dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
                dsData.setKeyData(keyData);
                EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", keyData2);
                ArrayList<EPPSecDNSExtDsData> dsDataRecords = new ArrayList<EPPSecDNSExtDsData>();
                dsDataRecords.add(dsData);
                dsDataRecords.add(dsData2);
                theDomain.setSecDNSCreate(dsDataRecords);
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testSecDNS10");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        return new NSDomainTstSetup((Test)new TestSuite(NSDomainTst.class));
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("NSDomainTst Thread " + i, NSDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)NSDomainTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private EPPSession borrowSession() {
        EPPSession theSession = null;
        try {
            theSession = sessionPool.borrowObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("borrowSession(): Exception borrowing session: " + ex));
        }
        return theSession;
    }

    private void returnSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.returnObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("returnSession(): Exception returning session: " + ex));
        }
    }

    private void invalidateSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.invalidateObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("invalidateSession(): Exception invalidating session: " + ex));
        }
    }

    private void handleResponse(EPPResponse aResponse) {
        for (int i = 0; i < aResponse.getResults().size(); ++i) {
            EPPResult theResult = (EPPResult)aResponse.getResults().elementAt(i);
            System.out.println("Result Code    : " + theResult.getCode());
            System.out.println("Result Message : " + theResult.getMessage());
            System.out.println("Result Lang    : " + theResult.getLang());
            if (theResult.isSuccess()) {
                System.out.println("Command Passed ");
            } else {
                System.out.println("Command Failed ");
            }
            if (theResult.getAllValues() == null) continue;
            for (int k = 0; k < theResult.getAllValues().size(); ++k) {
                System.out.println("Result Values  : " + theResult.getAllValues().elementAt(k));
            }
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".com");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printRgpStatuses(EPPDomainInfoResp aResp) {
        if (aResp.hasExtension(EPPRgpExtInfData.class)) {
            EPPRgpExtInfData theRgpInf = (EPPRgpExtInfData)aResp.getExtension(EPPRgpExtInfData.class);
            Vector rgpStatuses = theRgpInf.getStatuses();
            System.out.println("domainInfo: rgpStatuses.size = " + rgpStatuses.size());
            for (int i = 0; i < rgpStatuses.size(); ++i) {
                EPPRgpExtStatus rgpStatus = (EPPRgpExtStatus)rgpStatuses.get(i);
                if (rgpStatus.getStatus().equals("addPeriod") || rgpStatus.getStatus().equals("autoRenewPeriod") || rgpStatus.getStatus().equals("renewPeriod") || rgpStatus.getStatus().equals("transferPeriod")) {
                    System.out.println("domainInfo: rgp grace period status " + rgpStatus.getStatus());
                    System.out.println("domainInfo: rgp grace period end date = " + EPPUtil.decodeTimeInstant(rgpStatus.getMessage().substring(8)));
                    continue;
                }
                if (!rgpStatus.getStatus().equals("redemptionPeriod") && !rgpStatus.getStatus().equals("pendingRestore") && !rgpStatus.getStatus().equals("pendingDelete")) continue;
                System.out.println("domainInfo: rgp pending period status " + rgpStatus.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainCoaCreate() {
        NSDomainTst.printStart("testDomainCreate");
        EPPSession theSession = null;
        EPPDomainCreateResp theResponse = null;
        try {
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                String theDomainName = this.makeDomainName();
                System.out.println("domainCreate: Create " + theDomainName + " with COA Extension");
                theDomain.setTransId("ABC-12345-XYZ");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                theDomain.setAuthString("ClientX");
                EPPCoaExtAttr attr = new EPPCoaExtAttr("KEY1", "value1");
                ArrayList<EPPCoaExtAttr> attrList = new ArrayList<EPPCoaExtAttr>();
                attrList.add(attr);
                theDomain.setCoaCreate(attrList);
                theResponse = theDomain.sendCreate();
                System.out.println("domainCreate: Response = [" + theResponse + "]\n\n");
                System.out.println("domainCreate: name = " + theResponse.getName());
                System.out.println("domainCreate: expiration date = " + theResponse.getExpirationDate());
            }
            catch (Exception ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainCoaCreate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainCoaUpdate() {
        NSDomainTst.printStart("testDomainCoaUpdate");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            String theDomainName;
            theSession = this.borrowSession();
            NSDomain theDomain = new NSDomain(theSession);
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("\ndomainUpdate: Domain " + theDomainName + " update adding a COA.");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                    theDomain.setUpdateAttrib(1, "SH0000", "billing", 1);
                }
                theDomain.setUpdateAttrib(0, this.makeHostName(theDomainName), 1);
                theDomain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 1);
                theDomain.setUpdateAttrib(0, this.makeHostName(theDomainName), 2);
                theDomain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 2);
                if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                    theDomain.setUpdateAttrib(1, "SH0000", "billing", 2);
                }
                theDomain.setAuthString("new-auth-info-123");
                EPPCoaExtAttr attr = new EPPCoaExtAttr("KEY1", "value1");
                ArrayList<EPPCoaExtAttr> addAttrs = new ArrayList<EPPCoaExtAttr>();
                addAttrs.add(attr);
                theDomain.setCoaUpdateForPut(addAttrs);
                theResponse = theDomain.sendUpdate();
                System.out.println("domainUpdate adding a COA: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
            try {
                theDomain.setTransId("ABC-12345-XYZ");
                theDomainName = this.makeDomainName();
                System.out.println("\ndomainUpdate: Domain " + theDomainName + " update removing a COA.");
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID("dotCOM");
                if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                    theDomain.setUpdateAttrib(1, "SH0000", "billing", 1);
                }
                theDomain.setUpdateAttrib(0, this.makeHostName(theDomainName), 1);
                theDomain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 1);
                theDomain.setUpdateAttrib(0, this.makeHostName(theDomainName), 2);
                theDomain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 2);
                if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                    theDomain.setUpdateAttrib(1, "SH0000", "billing", 2);
                }
                theDomain.setAuthString("new-auth-info-123");
                EPPCoaExtKey key = new EPPCoaExtKey("KEY1");
                ArrayList<EPPCoaExtKey> remAttrs = new ArrayList<EPPCoaExtKey>();
                remAttrs.add(key);
                theDomain.setCoaUpdateForRem(remAttrs);
                theResponse = theDomain.sendUpdate();
                System.out.println("domainUpdate removing a COA: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSDomainTst.printEnd("testDomainCoaUpdate");
    }

    private static class NSDomainTstSetup
    extends TestSetup {
        public NSDomainTstSetup(Test aTest) {
            super(aTest);
        }

        protected void setUp() throws Exception {
            super.setUp();
            String theConfigFileName = System.getProperty("EPP.ConfigFile");
            if (theConfigFileName != null) {
                configFileName = theConfigFileName;
            }
            try {
                app.initialize(configFileName);
            }
            catch (EPPCommandException e) {
                e.printStackTrace();
                Assert.fail((String)("Error initializing the EPP Application: " + e));
            }
            try {
                sessionPool = EPPSessionPool.getInstance();
                sessionPool.init();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)("Error initializing the session pool: " + ex));
            }
        }

        protected void tearDown() throws Exception {
            super.tearDown();
            EPPSessionPool.getInstance().close();
        }
    }
}

