/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.util.ExceptionUtil;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.codec.suggestion.util.StatusEnum;
import com.verisign.epp.codec.suggestion.util.UnsignedShort;
import com.verisign.epp.util.EqualityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSuggestionCell
implements EPPCodecComponent {
    private static final long serialVersionUID = -116005839289398939L;
    private static final String ATT_TLD = "tld";
    private static final String ATT_SCORE = "score";
    private static final String ATT_STATUS = "status";
    static final String ELM_NAME = "suggestion:cell";
    private String tld = null;
    private UnsignedShort score = new UnsignedShort();
    private StatusEnum status = new StatusEnum();

    public EPPSuggestionCell() {
    }

    public EPPSuggestionCell(Element aElement) throws EPPDecodeException {
        this.decode(aElement);
    }

    public EPPSuggestionCell(String aTld, short aScore, String aStatus) throws InvalidValueException {
        this();
        this.setTld(aTld);
        this.setScore(aScore);
        this.setStatus(aStatus);
    }

    public String getTld() {
        return this.tld;
    }

    public UnsignedShort getScore() {
        return this.score;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setTld(String aTld) {
        this.tld = aTld;
    }

    public void setScore(short aScore) throws InvalidValueException {
        this.score.set(aScore);
    }

    public void setScore(String aScoreAsString) throws InvalidValueException {
        this.score.set(aScoreAsString);
    }

    public void setScore(UnsignedShort aScore) {
        this.score = aScore;
    }

    public void setStatus(StatusEnum aStatus) {
        this.status = aStatus;
    }

    public void setStatus(String aStatusAsString) throws InvalidValueException {
        this.status.set(aStatusAsString);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionCell)super.clone();
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.setTld(aElement.getAttribute(ATT_TLD));
        if (this.tld == null) {
            ExceptionUtil.missingDuringDecode(ATT_TLD);
        }
        this.setScore(aElement.getAttribute(ATT_SCORE));
        if (!this.score.isSet()) {
            ExceptionUtil.missingDuringDecode(ATT_SCORE);
        }
        this.setStatus(aElement.getAttribute(ATT_STATUS));
        if (!this.status.isSet()) {
            ExceptionUtil.missingDuringDecode(ATT_STATUS);
        }
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.tld == null) {
            ExceptionUtil.missingDuringEncode(ATT_TLD);
        }
        if (!this.score.isSet()) {
            ExceptionUtil.missingDuringEncode(ATT_SCORE);
        }
        if (!this.status.isSet()) {
            ExceptionUtil.missingDuringEncode(ATT_STATUS);
        }
        root.setAttribute(ATT_TLD, this.tld);
        root.setAttribute(ATT_SCORE, this.score.get() + "");
        root.setAttribute(ATT_STATUS, this.status + "");
        return root;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPSuggestionCell other = (EPPSuggestionCell)o;
            if (!EqualityUtil.equals(this.tld, other.tld)) {
                return false;
            }
            if (!this.score.equals(other.score)) {
                return false;
            }
            return this.status.equals(other.status);
        }
        return false;
    }
}

