/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgpext;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.rgpext.EPPRgpExtInfData;
import com.verisign.epp.codec.rgpext.EPPRgpExtReport;
import com.verisign.epp.codec.rgpext.EPPRgpExtReportText;
import com.verisign.epp.codec.rgpext.EPPRgpExtRestore;
import com.verisign.epp.codec.rgpext.EPPRgpExtStatus;
import com.verisign.epp.codec.rgpext.EPPRgpExtUpdate;
import com.verisign.epp.codec.rgppoll.EPPRgpPollResponse;
import com.verisign.epp.codec.rgppoll.EPPRgpPollStatus;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPRgpExtTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPRgpExtTst(String name) {
        super(name);
    }

    public void testPoll() {
        EPPCodecTst.printStart("testPoll");
        EPPRgpPollResponse pollResponse = new EPPRgpPollResponse();
        EPPTransId respTransId = new EPPTransId("abc-123", "54321-XYZ-1");
        pollResponse.setTransId(respTransId);
        pollResponse.setResult(1301);
        pollResponse.setMsgQueue(new EPPMsgQueue(new Long(5L), "12345", new Date(), "Transfer request pending"));
        pollResponse.setName("foobar.com");
        pollResponse.setStatus(new EPPRgpPollStatus("pendingDelete"));
        pollResponse.setReportDueDate(new Date());
        pollResponse.setReqDate(new Date());
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(pollResponse);
        EPPCodecTst.printEnd("testPoll");
    }

    public void testRestoreReport() {
        EPPCodecTst.printStart("testRestoreReport");
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345-XYZ", "example.com", null, null, null);
        EPPRgpExtReport report = new EPPRgpExtReport();
        report.setPreData("Pre-delete whois data goes here. Both XML and free text are allowed");
        report.setPostData("Post-delete whois data goes here. Both XML and free text are allowed");
        report.setDeleteTime(new Date());
        report.setRestoreTime(new Date());
        report.setRestoreReason(new EPPRgpExtReportText("Registrant Error"));
        report.setStatement1(new EPPRgpExtReportText("This registrar has not restored the Registered Domain in order to assume the rights to use or sell the Registered Name for itself or for any third party"));
        report.setStatement2(new EPPRgpExtReportText("The information in this report  is true to best of this registrar's knowledge, and thisregistrar acknowledges that intentionally supplying false information in this report shall constitute  an incurable material breach of the Registry-Registrar Agreement"));
        report.setOther("other stuff");
        EPPRgpExtRestore restore = new EPPRgpExtRestore(report);
        theCommand.addExtension(new EPPRgpExtUpdate(restore));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testRestoreReport");
    }

    public void testRestoreRequest() {
        EPPCodecTst.printStart("testRestoreRequest");
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345-XYZ", "example.com", null, null, null);
        theCommand.addExtension(new EPPRgpExtUpdate(new EPPRgpExtRestore()));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testRestoreRequest");
    }

    public void testDomainInfoRespWithRgpExt() {
        EPPCodecTst.printStart("testDomainInfoRespWithRgpExt");
        EPPTransId respTransId = new EPPTransId("54321-CLI", "54321-SER");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setRegistrant("JD1234-VRSN");
        Vector<String> servers = new Vector<String>();
        servers.addElement("ns1.example.com");
        servers.addElement("ns2.example.com");
        theResponse.setNses(servers);
        Vector<String> hosts = new Vector<String>();
        hosts.addElement("ns1.example.com");
        hosts.addElement("ns2.example.com");
        theResponse.setHosts(hosts);
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "admin"));
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "tech"));
            theResponse.setContacts(contacts);
        }
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastTransferDate(new Date());
        respTransId = new EPPTransId("54321-CLI", "54321-SER");
        theResponse.setTransId(respTransId);
        theResponse.setRoid("EXAMPLE1-VRSN");
        theResponse.setResult(1000);
        EPPRgpExtInfData infData = new EPPRgpExtInfData();
        EPPRgpExtStatus rgpStatus = new EPPRgpExtStatus();
        rgpStatus.setMessage("human readable message");
        rgpStatus.setLang("fr");
        rgpStatus.setStatus("autoRenewPeriod");
        infData.addStatus(rgpStatus);
        Vector<EPPRgpExtInfData> commandExtensions = new Vector<EPPRgpExtInfData>();
        commandExtensions.add(infData);
        theResponse.setExtensions(commandExtensions);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainInfoRespWithRgpExt");
    }

    public void testDomainInfoRespWithRgpExtStatuses() {
        EPPCodecTst.printStart("testDomainInfoRespWithRgpExtStatuses");
        EPPTransId respTransId = new EPPTransId("54321-CLI", "54321-SER");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setLastTransferDate(new Date());
        respTransId = new EPPTransId("54321-CLI", "54321-SER");
        theResponse.setTransId(respTransId);
        theResponse.setRoid("EXAMPLE1-VRSN");
        theResponse.setResult(1000);
        EPPRgpExtInfData infData = new EPPRgpExtInfData();
        infData.addStatus(new EPPRgpExtStatus("renewPeriod"));
        infData.addStatus(new EPPRgpExtStatus("addPeriod"));
        Vector<EPPRgpExtInfData> commandExtensions = new Vector<EPPRgpExtInfData>();
        commandExtensions.add(infData);
        theResponse.setExtensions(commandExtensions);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainInfoRespWithRgpExtStatuses");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPRgpExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.rgppoll.EPPRgpPollMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.rgpext.EPPRgpExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPRgpExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPRgpExtTst Thread " + i, EPPRgpExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPRgpExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

