/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.relateddomainext;

import com.verisign.epp.codec.domain.EPPDomainAddRemove;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAuthInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAvailable;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreate;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreateResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDelete;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDeleteResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomain;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomainData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtField;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtFields;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtGroup;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtName;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtPeriod;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRegistered;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenew;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenewResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransfer;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransferResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtUpdate;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.TestThread;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPRelatedDomainExtTst
extends TestCase {
    private static Logger cat = Logger.getLogger((String)EPPRelatedDomainExtTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static long numIterations = 1L;

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPRelatedDomainExtTst Thread " + i, EPPRelatedDomainExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPRelatedDomainExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPRelatedDomainExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory or EPPRelatedDomainExtFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public void testDomainInfoCmd() {
        EPPCodecTst.printStart("testDomainInfo");
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd("ABC-12349", "xn--test.tld1");
        theCommand.setHosts("del");
        theCommand.setAuthInfo(new EPPAuthInfo("2fooBAR"));
        theCommand.addExtension(new EPPRelatedDomainExtInfo());
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        this.encodeDecodeInfoResponse();
        EPPCodecTst.printEnd("testDomainInfo");
    }

    public void testDomainCreate() {
        EPPCodecTst.printStart("testDomainCreate");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> servers = new Vector<String>();
        servers.addElement("ns1.example.com");
        servers.addElement("ns2.example.com");
        Vector<EPPDomainContact> contacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            contacts = new Vector<EPPDomainContact>();
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "admin"));
            contacts.addElement(new EPPDomainContact("SH8013-VRSN", "tech"));
        }
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getFiveYearsFutureDate();
        theCommand = new EPPDomainCreateCmd("ABC-12345-XYZ", "example.com", servers, contacts, new EPPDomainPeriod(5), new EPPAuthInfo("2fooBAR"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo("2fooBAR"));
        Vector<EPPHostAttr> serverAttrs = new Vector<EPPHostAttr>();
        serverAttrs.add(new EPPHostAttr("ns1.example.com"));
        Vector<EPPHostAddress> hostAddresses = new Vector<EPPHostAddress>();
        hostAddresses.add(new EPPHostAddress("197.162.10.10"));
        serverAttrs.add(new EPPHostAttr("ns2.example.com", hostAddresses));
        theCommand.setServers(serverAttrs);
        EPPRelatedDomainExtCreate create = new EPPRelatedDomainExtCreate();
        theCommand.addExtension(create);
        ArrayList<EPPCodecComponent> domains = new ArrayList<EPPCodecComponent>();
        EPPRelatedDomainExtAuthInfo authInfo = new EPPRelatedDomainExtAuthInfo("relDom123!");
        EPPRelatedDomainExtPeriod period = new EPPRelatedDomainExtPeriod(5);
        EPPRelatedDomainExtDomain domain = new EPPRelatedDomainExtDomain("domain1.com", authInfo, period);
        domains.add(domain);
        domain = new EPPRelatedDomainExtDomain("domain2.com", authInfo, period);
        domains.add(domain);
        domain = new EPPRelatedDomainExtDomain("xn--idn.com", authInfo, period, "CHI");
        domains.add(domain);
        create.setDomains(domains);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(respTransId, "example.com", theDate, expDate);
        theResponse.setResult(1000);
        domains = new ArrayList();
        EPPRelatedDomainExtDomainData domainData = new EPPRelatedDomainExtDomainData("domain1.com", theDate, expDate);
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("domain2.com", theDate, expDate);
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("xn--idn.com", theDate, expDate);
        domains.add(domainData);
        EPPRelatedDomainExtCreateResp resp = new EPPRelatedDomainExtCreateResp(domains);
        theResponse.addExtension(resp);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainCreate");
    }

    public void testDomainDelete() {
        EPPCodecTst.printStart("testDomainDelete");
        EPPDomainDeleteCmd theCommand = new EPPDomainDeleteCmd("ABC-12345", "example.com");
        EPPRelatedDomainExtDelete delete = new EPPRelatedDomainExtDelete();
        theCommand.addExtension(delete);
        ArrayList<Object> domains = new ArrayList<Object>();
        domains.add("domain1.com");
        domains.add("domain2.com");
        delete.setDomains(domains);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1001);
        domains = new ArrayList();
        EPPRelatedDomainExtDomainData domainData = new EPPRelatedDomainExtDomainData("domain1.com", "deleted");
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("domain2.com", "pendingDelete");
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("xn--idn.com", "pendingDelete");
        domains.add(domainData);
        EPPRelatedDomainExtDeleteResp resp = new EPPRelatedDomainExtDeleteResp(domains);
        theResponse.addExtension(resp);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainDelete");
    }

    public void testDomainUpdate() {
        EPPCodecTst.printStart("testDomainUpdate");
        Vector<String> addServers = new Vector<String>();
        addServers.addElement("ns1.example.com");
        Vector<EPPDomainStatus> addStatuses = new Vector<EPPDomainStatus>();
        addStatuses.addElement(new EPPDomainStatus("clientHold", "The description"));
        Vector<EPPDomainContact> addContacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            addContacts = new Vector<EPPDomainContact>();
            addContacts.addElement(new EPPDomainContact("MAK21-VRSN", "tech"));
        }
        Vector<String> removeServers = new Vector<String>();
        removeServers.addElement("ns2.example.com");
        Vector<EPPDomainStatus> removeStatuses = new Vector<EPPDomainStatus>();
        removeStatuses.addElement(new EPPDomainStatus("clientHold"));
        Vector<EPPDomainContact> removeContacts = null;
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            removeContacts = new Vector<EPPDomainContact>();
            removeContacts.addElement(new EPPDomainContact("SH8013-VRSN", "tech"));
        }
        EPPDomainAddRemove addItems = new EPPDomainAddRemove(addServers, addContacts, addStatuses);
        EPPDomainAddRemove removeItems = new EPPDomainAddRemove(removeServers, removeContacts, removeStatuses);
        EPPDomainAddRemove changeItems = new EPPDomainAddRemove("SH8013-VRSN", new EPPAuthInfo("2fooBAR"));
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345-XYZ", "example.com", addItems, removeItems, changeItems);
        EPPRelatedDomainExtUpdate update = new EPPRelatedDomainExtUpdate();
        theCommand.addExtension(update);
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("domain1.com");
        domains.add("domain2.com");
        update.setDomains(domains);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPDomainAddRemove emptyChangeItems = new EPPDomainAddRemove();
        Assert.assertTrue((boolean)emptyChangeItems.isEmpty());
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainUpdate");
    }

    public void testDomainRenew() {
        EPPCodecTst.printStart("testDomainRenew");
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getFiveYearsFutureDate();
        EPPDomainRenewCmd theCommand = new EPPDomainRenewCmd("ABC-12345", "example.com", theDate, new EPPDomainPeriod(5));
        EPPRelatedDomainExtRenew renew = new EPPRelatedDomainExtRenew();
        theCommand.addExtension(renew);
        EPPRelatedDomainExtAuthInfo authInfo = new EPPRelatedDomainExtAuthInfo("relDom123!");
        EPPRelatedDomainExtPeriod period = new EPPRelatedDomainExtPeriod(5);
        EPPRelatedDomainExtDomain domain = new EPPRelatedDomainExtDomain("domain1.com", theDate, period);
        ArrayList<EPPCodecComponent> domains = new ArrayList<EPPCodecComponent>();
        domains.add(domain);
        domain = new EPPRelatedDomainExtDomain("domain2.com", theDate, period);
        domains.add(domain);
        renew.setDomains(domains);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainRenewResp theResponse = new EPPDomainRenewResp(respTransId, "example.com", expDate);
        theResponse.setResult(1000);
        domains = new ArrayList();
        EPPRelatedDomainExtDomainData domainData = new EPPRelatedDomainExtDomainData("domain1.com", expDate);
        domains.add(domainData);
        domainData = new EPPRelatedDomainExtDomainData("domain2.com", expDate);
        domains.add(domainData);
        EPPRelatedDomainExtRenewResp resp = new EPPRelatedDomainExtRenewResp();
        resp.setDomains(domains);
        theResponse.addExtension(resp);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainRenew");
    }

    public void testDomainTransfer() {
        ArrayList<EPPCodecComponent> domains;
        EPPCodecTst.printStart("testDomainTransfer");
        EPPDomainTransferCmd theCommand = new EPPDomainTransferCmd("ABC-12345", "request", "example.com", new EPPAuthInfo("2fooBAR"), new EPPDomainPeriod(1));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPAuthInfo theAuthInfo = new EPPAuthInfo("2fooBAR");
        theAuthInfo.setRoid("JD1234-REP");
        theCommand = new EPPDomainTransferCmd("ABC-12345", "request", "example.com", theAuthInfo, new EPPDomainPeriod(1));
        ArrayList<EPPCodecComponent> requestDomains = domains = new ArrayList<EPPCodecComponent>();
        EPPRelatedDomainExtTransfer transfer = new EPPRelatedDomainExtTransfer();
        theCommand.addExtension(transfer);
        EPPTransId tid = new EPPTransId("ABC-1234");
        EPPRelatedDomainExtAuthInfo authInfo = new EPPRelatedDomainExtAuthInfo("relDom123!");
        EPPRelatedDomainExtPeriod period = new EPPRelatedDomainExtPeriod(1);
        EPPRelatedDomainExtDomain domain = new EPPRelatedDomainExtDomain("domain1.com", authInfo, period);
        domains.add(domain);
        domain = new EPPRelatedDomainExtDomain("domain2.com", authInfo);
        domains.add(domain);
        transfer.setDomains(domains);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPDomainTransferResp theResponse = this.getEPPDomainTransferResp("example.com", "request");
        EPPRelatedDomainExtTransferResp respExt = new EPPRelatedDomainExtTransferResp();
        theResponse.addExtension(respExt);
        domains = new ArrayList();
        respExt.setDomains(domains);
        domains.add(this.getDomainDataForTransferResp("domain1.com", "request"));
        domains.add(this.getDomainDataForTransferResp("domain2.com", "request"));
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "cancel", "example.com");
        transfer = new EPPRelatedDomainExtTransfer();
        theCommand.addExtension(transfer);
        domains = new ArrayList();
        transfer.setDomains(domains);
        domains.add(new EPPRelatedDomainExtDomain("domain1.com"));
        domains.add(new EPPRelatedDomainExtDomain("domain2.com"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theResponse = this.getEPPDomainTransferResp("example.com", "cancel");
        respExt = new EPPRelatedDomainExtTransferResp();
        theResponse.addExtension(respExt);
        domains = new ArrayList();
        respExt.setDomains(domains);
        domains.add(this.getDomainDataForTransferResp("domain1.com", "cancel"));
        domains.add(this.getDomainDataForTransferResp("domain2.com", "cancel"));
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "query", "example.com");
        transfer = new EPPRelatedDomainExtTransfer();
        theCommand.addExtension(transfer);
        domains = new ArrayList();
        transfer.setDomains(domains);
        domains.add(new EPPRelatedDomainExtDomain("domain1.com"));
        domains.add(new EPPRelatedDomainExtDomain("domain2.com"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theResponse = this.getEPPDomainTransferResp("example.com", "query");
        respExt = new EPPRelatedDomainExtTransferResp();
        theResponse.addExtension(respExt);
        domains = new ArrayList();
        respExt.setDomains(domains);
        domains.add(this.getDomainDataForTransferResp("domain1.com", "query"));
        domains.add(this.getDomainDataForTransferResp("domain2.com", "query"));
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "reject", "example.com");
        transfer = new EPPRelatedDomainExtTransfer();
        theCommand.addExtension(transfer);
        domains = new ArrayList();
        transfer.setDomains(domains);
        domains.add(new EPPRelatedDomainExtDomain("domain1.com"));
        domains.add(new EPPRelatedDomainExtDomain("domain2.com"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theResponse = this.getEPPDomainTransferResp("example.com", "reject");
        respExt = new EPPRelatedDomainExtTransferResp();
        theResponse.addExtension(respExt);
        domains = new ArrayList();
        respExt.setDomains(domains);
        domains.add(this.getDomainDataForTransferResp("domain1.com", "reject"));
        domains.add(this.getDomainDataForTransferResp("domain2.com", "reject"));
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPDomainTransferCmd("ABC-12345", "approve", "example.com");
        transfer = new EPPRelatedDomainExtTransfer();
        theCommand.addExtension(transfer);
        domains = new ArrayList();
        transfer.setDomains(domains);
        domains.add(new EPPRelatedDomainExtDomain("domain1.com"));
        domains.add(new EPPRelatedDomainExtDomain("domain2.com"));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theResponse = this.getEPPDomainTransferResp("example.com", "approve");
        respExt = new EPPRelatedDomainExtTransferResp();
        theResponse.addExtension(respExt);
        domains = new ArrayList();
        respExt.setDomains(domains);
        domains.add(this.getDomainDataForTransferResp("domain1.com", "approve"));
        domains.add(this.getDomainDataForTransferResp("domain2.com", "approve"));
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testDomainTransfer");
    }

    private EPPDomainTransferResp getEPPDomainTransferResp(String aDomainName, String aCommandType) {
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getOneYearFutureDate();
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPDomainTransferResp theResponse = new EPPDomainTransferResp(respTransId, aDomainName);
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus(this.getTransferStatus(aCommandType));
        theResponse.setRequestDate(theDate);
        theResponse.setActionDate(theDate);
        theResponse.setExpirationDate(expDate);
        return theResponse;
    }

    private EPPRelatedDomainExtDomainData getDomainDataForTransferResp(String aDomainName, String aCommandType) {
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getOneYearFutureDate();
        EPPRelatedDomainExtDomainData result = new EPPRelatedDomainExtDomainData();
        result.setName(aDomainName);
        result.setRequestClient("ClientX");
        result.setActionClient("ClientY");
        result.setTransferStatus(this.getTransferStatus(aCommandType));
        result.setRequestDate(theDate);
        result.setActionDate(theDate);
        result.setExpirationDate(expDate);
        return result;
    }

    private String getTransferStatus(String aCommandType) {
        if (aCommandType.equals("request") || aCommandType.equals("query")) {
            return "pending";
        }
        if (aCommandType.equals("cancel")) {
            return "clientCancelled";
        }
        if (aCommandType.equals("reject")) {
            return "clientRejected";
        }
        if (aCommandType.equals("approve")) {
            return "clientApproved";
        }
        return "pending";
    }

    private void encodeDecodeInfoResponse() {
        EPPCodecTst.printStart("testDomainInfo");
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd("ABC-12349", "example.com");
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", "xn--test.tld1", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        EPPRelatedDomainExtInfData infData = new EPPRelatedDomainExtInfData();
        ArrayList<EPPRelatedDomainExtGroup> groupList = new ArrayList<EPPRelatedDomainExtGroup>();
        EPPRelatedDomainExtGroup tldGroup = new EPPRelatedDomainExtGroup();
        groupList.add(tldGroup);
        tldGroup.setType("tld");
        infData.setGroup(groupList);
        EPPRelatedDomainExtFields fields = new EPPRelatedDomainExtFields();
        tldGroup.setFields(fields);
        ArrayList<EPPRelatedDomainExtField> fieldsList = new ArrayList<EPPRelatedDomainExtField>();
        fields.setFields(fieldsList);
        fields.setInSync(false);
        EPPRelatedDomainExtField field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(false);
        field.setName("registrar");
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(true);
        field.setName("registrant");
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(false);
        field.setName("ns");
        EPPRelatedDomainExtRegistered registered = new EPPRelatedDomainExtRegistered();
        tldGroup.setRegistered(registered);
        ArrayList<EPPRelatedDomainExtName> regList = new ArrayList<EPPRelatedDomainExtName>();
        registered.setRegisteredDomains(regList);
        EPPRelatedDomainExtName name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test.tld1");
        regList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test.tld2");
        regList.add(name);
        EPPRelatedDomainExtGroup variantGroup = new EPPRelatedDomainExtGroup();
        groupList.add(variantGroup);
        variantGroup.setType("variant");
        infData.setGroup(groupList);
        fields = new EPPRelatedDomainExtFields();
        variantGroup.setFields(fields);
        fieldsList = new ArrayList();
        fields.setFields(fieldsList);
        fields.setInSync(true);
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(true);
        field.setName("registrar");
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(true);
        field.setName("registrant");
        field = new EPPRelatedDomainExtField();
        fieldsList.add(field);
        field.setInSync(true);
        field.setName("ns");
        registered = new EPPRelatedDomainExtRegistered();
        variantGroup.setRegistered(registered);
        regList = new ArrayList();
        registered.setRegisteredDomains(regList);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant1.tld1");
        regList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant1.tld2");
        regList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant1.tld3");
        regList.add(name);
        EPPRelatedDomainExtAvailable avail = new EPPRelatedDomainExtAvailable();
        ArrayList<EPPRelatedDomainExtName> availDomainsList = new ArrayList<EPPRelatedDomainExtName>();
        avail.setAvailableDomains(availDomainsList);
        variantGroup.setAvailable(avail);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant2.tld1");
        availDomainsList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant2.tld2");
        availDomainsList.add(name);
        name = new EPPRelatedDomainExtName();
        name.setDomainName("xn--test-variant2.tld2");
        availDomainsList.add(name);
        theResponse.addExtension(infData);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private Date getTodaysUTCDateAtMidnight() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getFiveYearsFutureDate() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(1, 5);
        return cal.getTime();
    }

    private Date getOneYearFutureDate() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(1, 1);
        return cal.getTime();
    }
}

