/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.relateddomainext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRelatedDomainExtField
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRelatedDomainExtField.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final long serialVersionUID = 8458235783317620385L;
    static final String ELM_FIELD_NAME = "relDom:field";
    private static final String ELM_FIELD_NAME_ATTR = "name";
    private static final String ELM_IN_SYNC_ATTR = "inSync";
    private String name;
    private boolean inSync;

    public EPPRelatedDomainExtField() {
    }

    public EPPRelatedDomainExtField(String aFieldName, String aInSync) {
        this.name = aFieldName;
        this.inSync = aInSync.equalsIgnoreCase("true") || aInSync.equals("1");
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRelatedDomainExtField clone = null;
        clone = (EPPRelatedDomainExtField)super.clone();
        return clone;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.name = aElement.getAttribute(ELM_FIELD_NAME_ATTR);
        this.inSync = EPPUtil.decodeBooleanAttr(aElement, ELM_IN_SYNC_ATTR);
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/relatedDomain-1.0", ELM_FIELD_NAME);
        if (this.name == null) {
            throw new EPPEncodeException("EPPRelatedDomainExtField: name should not be null");
        }
        root.setAttribute(ELM_FIELD_NAME_ATTR, this.name);
        String inSyncVal = this.inSync ? "true" : "false";
        root.setAttribute(ELM_IN_SYNC_ATTR, inSyncVal);
        return root;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EPPRelatedDomainExtField)) {
            return false;
        }
        EPPRelatedDomainExtField other = (EPPRelatedDomainExtField)obj;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPRelatedDomainExtField.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.inSync, other.inSync)) {
            cat.error((Object)"EPPRelatedDomainExtField.equals(): inSync not equal");
            return false;
        }
        return true;
    }

    public boolean getInSync() {
        return this.inSync;
    }

    public String getName() {
        return this.name;
    }

    public void setInSync(boolean aInSync) {
        this.inSync = aInSync;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

