/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryPhase
implements EPPCodecComponent {
    private static final long serialVersionUID = 5493994152033865390L;
    private static Logger cat = Logger.getLogger(EPPRegistryPhase.class);
    public static final String ELM_LOCALNAME = "phase";
    public static final String ELM_NAME = "registry:phase";
    public static final String ELM_START_DATE = "startDate";
    public static final String ELM_END_DATE = "endDate";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_MODE = "mode";
    public static final String PHASE_PRE_DELEGATION = "pre-delegation";
    public static final String PHASE_PRE_LAUNCH = "pre-launch";
    public static final String PHASE_SUNRISE = "sunrise";
    public static final String PHASE_LANDRUSH = "landrush";
    public static final String PHASE_CLAIMS = "claims";
    public static final String PHASE_OPEN = "open";
    public static final String PHASE_CUSTOM = "custom";
    public static final String MODE_FCFS = "fcfs";
    public static final String MODE_PENDING_REGISTRATION = "pending-registration";
    public static final String MODE_PENDING_APPLICATION = "pending-application";
    private String type = null;
    private String mode = "fcfs";
    private String name = null;
    private Date startDate = null;
    private Date endDate = null;
    public static List VALID_PHASES = new ArrayList();
    public static List VALID_MODES = new ArrayList();

    public EPPRegistryPhase() {
    }

    public EPPRegistryPhase(String type, Date startDate, Date endDate) {
        this();
        this.type = type;
        this.startDate = startDate;
        this.endDate = endDate;
        this.name = null;
    }

    public EPPRegistryPhase(String type, String name, Date startDate, Date endDate) {
        this(type, startDate, endDate);
        this.name = name;
    }

    public EPPRegistryPhase(String type, String name, String mode, Date startDate, Date endDate) {
        this(type, name, startDate, endDate);
        this.mode = mode;
    }

    public EPPRegistryPhase(String type, Date startDate) {
        this(type, startDate, null);
    }

    public EPPRegistryPhase(String type, String name, Date startDate) {
        this(type, name, startDate, null);
    }

    public EPPRegistryPhase(String type, String name, String mode, Date startDate) {
        this(type, name, mode, startDate, null);
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryPhase.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeTimeInstant(aDocument, root, this.startDate, "http://www.verisign.com/epp/registry-1.0", "registry:startDate");
        if (this.endDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.endDate, "http://www.verisign.com/epp/registry-1.0", "registry:endDate");
        }
        root.setAttribute(ATTR_TYPE, this.type);
        if (this.mode == null || this.mode.trim().length() == 0) {
            this.mode = MODE_FCFS;
        }
        root.setAttribute(ATTR_MODE, this.mode);
        if (this.name != null && this.name.trim().length() > 0) {
            root.setAttribute(ATTR_NAME, this.name);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.type = aElement.getAttribute(ATTR_TYPE);
        this.name = aElement.getAttribute(ATTR_NAME);
        this.mode = aElement.getAttribute(ATTR_MODE);
        if (this.mode == null) {
            this.mode = MODE_FCFS;
        }
        this.startDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_START_DATE);
        this.endDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_END_DATE);
    }

    public Object clone() throws CloneNotSupportedException {
        return (EPPRegistryPhase)super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryPhase)) {
            return false;
        }
        EPPRegistryPhase theComp = (EPPRegistryPhase)aObject;
        if (!this.type.equals(theComp.type)) {
            cat.error((Object)"EPPRegistryPhase.equals(): type not equal");
            return false;
        }
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null || theComp.name.trim().length() == 0)) {
            cat.error((Object)"EPPRegistryPhase.equals(): name not equal");
            return false;
        }
        if (!this.startDate.equals(theComp.startDate)) {
            cat.error((Object)"EPPRegistryPhase.equals(): startDate not equal");
            return false;
        }
        if (!(this.endDate != null ? this.endDate.equals(theComp.endDate) : theComp.endDate == null)) {
            cat.error((Object)"EPPRegistryPhase.equals(): endDate not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.type == null || !VALID_PHASES.contains(this.type)) {
            throw new EPPCodecException("type is required. Valid values are: pre-delegation/pre-launch/sunrise/landrush/claims/open/custom");
        }
        if (PHASE_CUSTOM.equals(this.type) && (this.name == null || this.name.trim().length() == 0)) {
            throw new EPPCodecException("when type is custom, name attribute is required");
        }
        if (this.startDate == null) {
            throw new EPPCodecException("startDate attribute is not set");
        }
        if (!VALID_MODES.contains(this.mode)) {
            throw new EPPCodecException("invalid mode, valide values: fcfs/pending-registration/pending-application");
        }
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    static {
        VALID_PHASES.add(PHASE_PRE_DELEGATION);
        VALID_PHASES.add(PHASE_SUNRISE);
        VALID_PHASES.add(PHASE_LANDRUSH);
        VALID_PHASES.add(PHASE_CLAIMS);
        VALID_PHASES.add(PHASE_PRE_LAUNCH);
        VALID_PHASES.add(PHASE_OPEN);
        VALID_PHASES.add(PHASE_CUSTOM);
        VALID_MODES.add(MODE_FCFS);
        VALID_MODES.add(MODE_PENDING_REGISTRATION);
        VALID_MODES.add(MODE_PENDING_APPLICATION);
    }
}

