/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryCustomData;
import com.verisign.epp.codec.registry.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.EPPRegistryRegex;
import com.verisign.epp.codec.registry.EPPRegistrySupportedStatus;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryHost
implements EPPCodecComponent {
    private static final long serialVersionUID = 3439673342895779324L;
    public static final String ELM_NAME = "registry:host";
    public static final String ELM_REGEX = "registry:nameRegex";
    public static final String ELM_MAX_CHECK = "registry:maxCheckHost";
    public static final String ELM_CUSTOM_DATA = "registry:customData";
    public static final String ELM_AUTH_INFO_REGEX = "registry:authInfoRegex";
    private EPPRegistryInternalHost internal = null;
    private EPPRegistryExternalHost external = null;
    private List nameRegex = new ArrayList();
    private Integer maxCheckHost = null;
    private EPPRegistrySupportedStatus supportedStatus = null;
    private EPPRegistryCustomData customData = null;

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryHost.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.internal);
        EPPUtil.encodeComp(aDocument, root, this.external);
        if (this.nameRegex != null && this.nameRegex.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.nameRegex);
        }
        EPPUtil.encodeString(aDocument, root, this.maxCheckHost.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_MAX_CHECK);
        if (this.supportedStatus != null) {
            EPPUtil.encodeComp(aDocument, root, this.supportedStatus);
        }
        if (this.customData != null) {
            EPPUtil.encodeComp(aDocument, root, this.customData);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.internal = (EPPRegistryInternalHost)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:internal", EPPRegistryInternalHost.class);
        this.external = (EPPRegistryExternalHost)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:external", EPPRegistryExternalHost.class);
        this.setNameRegex(EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGEX, EPPRegistryRegex.class));
        this.maxCheckHost = EPPUtil.decodeInteger(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_MAX_CHECK);
        this.supportedStatus = (EPPRegistrySupportedStatus)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:supportedStatus", EPPRegistrySupportedStatus.class);
        this.customData = (EPPRegistryCustomData)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_CUSTOM_DATA, EPPRegistryCustomData.class);
    }

    void validateState() throws EPPCodecException {
        if (this.internal == null) {
            throw new EPPCodecException("internal required element is not set");
        }
        if (this.external == null) {
            throw new EPPCodecException("external required element is not set");
        }
        if (this.maxCheckHost == null || this.maxCheckHost <= 0) {
            throw new EPPCodecException("maxCheckHost is required and should be greater than 0");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRegistryHost clone = (EPPRegistryHost)super.clone();
        if (this.internal != null) {
            clone.internal = (EPPRegistryInternalHost)this.internal.clone();
        }
        if (this.external != null) {
            clone.external = (EPPRegistryExternalHost)this.external.clone();
        }
        if (this.nameRegex != null) {
            clone.nameRegex = (List)((ArrayList)this.nameRegex).clone();
        }
        if (this.supportedStatus != null) {
            clone.supportedStatus = (EPPRegistrySupportedStatus)this.supportedStatus.clone();
        }
        if (this.customData != null) {
            clone.customData = (EPPRegistryCustomData)this.customData.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryHost)) {
            return false;
        }
        EPPRegistryHost theComp = (EPPRegistryHost)aObject;
        if (!(this.internal != null ? this.internal.equals(theComp.internal) : theComp.internal == null)) {
            return false;
        }
        if (!(this.external != null ? this.external.equals(theComp.external) : theComp.external == null)) {
            return false;
        }
        if (!(this.nameRegex != null ? EPPUtil.equalLists(this.nameRegex, theComp.nameRegex) : theComp.nameRegex == null)) {
            return false;
        }
        if (!(this.maxCheckHost != null ? this.maxCheckHost.equals(theComp.maxCheckHost) : theComp.maxCheckHost == null)) {
            return false;
        }
        if (!(this.supportedStatus != null ? this.supportedStatus.equals(theComp.supportedStatus) : theComp.supportedStatus == null)) {
            return false;
        }
        return this.customData != null ? this.customData.equals(theComp.customData) : theComp.customData == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryInternalHost getInternal() {
        return this.internal;
    }

    public void setInternal(EPPRegistryInternalHost internal) {
        this.internal = internal;
    }

    public EPPRegistryExternalHost getExternal() {
        return this.external;
    }

    public void setExternal(EPPRegistryExternalHost external) {
        this.external = external;
    }

    public List getNameRegex() {
        return this.nameRegex;
    }

    public void setNameRegex(List nameRegex) {
        if (nameRegex != null) {
            for (EPPRegistryRegex regex : nameRegex) {
                if (regex == null) continue;
                regex.setRootName(ELM_REGEX);
            }
        }
        this.nameRegex = nameRegex;
    }

    public void addNameRegex(EPPRegistryRegex regex) {
        if (regex == null) {
            return;
        }
        regex.setRootName(ELM_REGEX);
        if (this.nameRegex == null) {
            this.nameRegex = new ArrayList();
        }
        this.nameRegex.add(regex);
    }

    public Integer getMaxCheckHost() {
        return this.maxCheckHost;
    }

    public void setMaxCheckHost(Integer maxCheckHost) {
        this.maxCheckHost = maxCheckHost;
    }

    public EPPRegistryCustomData getCustomData() {
        return this.customData;
    }

    public void setCustomData(EPPRegistryCustomData customData) {
        this.customData = customData;
    }

    public EPPRegistrySupportedStatus getSupportedStatus() {
        return this.supportedStatus;
    }

    public void setSupportedStatus(EPPRegistrySupportedStatus supportedStatus) {
        this.supportedStatus = supportedStatus;
    }
}

