/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchCodeMark;
import com.verisign.epp.codec.launch.EPPLaunchNotice;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.codec.signedMark.EPPSignedMark;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchCreate
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchCreate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String TYPE_APPLICATION = "application";
    public static final String TYPE_REGISTRATION = "registration";
    public static final String ELM_LOCALNAME = "create";
    public static final String ELM_NAME = "launch:create";
    private static final String ATTR_TYPE = "type";
    EPPLaunchPhase phase;
    List<EPPSignedMark> signedMarks;
    List<EPPLaunchCodeMark> codeMarks;
    EPPLaunchNotice notice;
    String type;

    public EPPLaunchCreate() {
    }

    public EPPLaunchCreate(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public EPPLaunchCreate(EPPLaunchPhase aPhase, String aType) {
        this.phase = aPhase;
        this.type = aType;
    }

    public EPPLaunchCreate(EPPLaunchPhase aPhase, EPPSignedMark aSignedMark) {
        this.phase = aPhase;
        this.setSignedMark(aSignedMark);
    }

    public EPPLaunchCreate(EPPLaunchPhase aPhase, EPPSignedMark aSignedMark, String aType) {
        this.phase = aPhase;
        this.setSignedMark(aSignedMark);
        this.type = aType;
    }

    public EPPLaunchCreate(EPPLaunchPhase aPhase, EPPLaunchCodeMark aCodeMark) {
        this.phase = aPhase;
        this.setCodeMark(aCodeMark);
    }

    public EPPLaunchCreate(EPPLaunchPhase aPhase, EPPLaunchCodeMark aCodeMark, String aType) {
        this.phase = aPhase;
        this.setCodeMark(aCodeMark);
        this.type = aType;
    }

    public EPPLaunchCreate(EPPLaunchPhase aPhase, EPPLaunchNotice aNotice) {
        this.phase = aPhase;
        this.notice = aNotice;
    }

    public EPPLaunchCreate(EPPLaunchPhase aPhase, EPPLaunchNotice aNotice, String aType) {
        this.phase = aPhase;
        this.notice = aNotice;
        this.type = aType;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public EPPLaunchPhase getPhase() {
        return this.phase;
    }

    public void setPhase(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public void setPhase(String aPhaseString) {
        this.phase = new EPPLaunchPhase(aPhaseString);
    }

    public boolean hasSignedMarks() {
        return this.signedMarks != null;
    }

    public List<EPPSignedMark> getSignedMarks() {
        return this.signedMarks;
    }

    public void setSignedMarks(List<EPPSignedMark> aSignedMarks) {
        this.signedMarks = aSignedMarks;
    }

    public EPPSignedMark getSignedMark() {
        if (this.signedMarks != null && this.signedMarks.size() > 0) {
            return this.signedMarks.get(0);
        }
        return null;
    }

    public void setSignedMark(EPPSignedMark aSignedMark) {
        this.signedMarks = new ArrayList<EPPSignedMark>();
        this.signedMarks.add(aSignedMark);
    }

    public void addSignedMark(EPPSignedMark aSignedMark) {
        if (this.signedMarks == null) {
            this.signedMarks = new ArrayList<EPPSignedMark>();
        }
        this.signedMarks.add(aSignedMark);
    }

    public boolean hasCodeMarks() {
        return this.codeMarks != null;
    }

    public List<EPPLaunchCodeMark> getCodeMarks() {
        return this.codeMarks;
    }

    public void setCodeMarks(List<EPPLaunchCodeMark> aCodeMarks) {
        this.codeMarks = aCodeMarks;
    }

    public EPPLaunchCodeMark getCodeMark() {
        if (this.codeMarks != null && this.codeMarks.size() > 0) {
            return this.codeMarks.get(0);
        }
        return null;
    }

    public void setCodeMark(EPPLaunchCodeMark aCodeMark) {
        this.codeMarks = new ArrayList<EPPLaunchCodeMark>();
        this.codeMarks.add(aCodeMark);
    }

    public void addCodeMark(EPPLaunchCodeMark aCodeMark) {
        if (this.codeMarks == null) {
            this.codeMarks = new ArrayList<EPPLaunchCodeMark>();
        }
        this.codeMarks.add(aCodeMark);
    }

    public boolean hasNotice() {
        return this.notice != null;
    }

    public EPPLaunchNotice getNotice() {
        return this.notice;
    }

    public void setNotice(EPPLaunchNotice aNotice) {
        this.notice = aNotice;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchCreate clone = (EPPLaunchCreate)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchCreate.encode(Document)");
        }
        if (this.phase == null) {
            throw new EPPEncodeException("EPPLaunchCreate phase attribute must be set.");
        }
        boolean extTypeFound = false;
        if (this.signedMarks != null && this.codeMarks != null) {
            throw new EPPEncodeException("EPPLaunchCreate more than one type of extension defined (signedMark and codeMark).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        if (this.type != null) {
            if (!this.type.equals(TYPE_APPLICATION) && !this.type.equals(TYPE_REGISTRATION)) {
                throw new EPPEncodeException("EPPLaunchCreate type attribute with invalid value of: " + this.type);
            }
            root.setAttribute(ATTR_TYPE, this.type);
        }
        EPPUtil.encodeComp(aDocument, root, this.phase);
        EPPUtil.encodeCompList(aDocument, root, this.signedMarks);
        EPPUtil.encodeCompList(aDocument, root, this.codeMarks);
        EPPUtil.encodeComp(aDocument, root, this.notice);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.phase = (EPPLaunchPhase)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:phase", EPPLaunchPhase.class);
        if (this.phase == null) {
            throw new EPPDecodeException("EPPLaunchCreate phase element not found.");
        }
        this.type = aElement.getAttribute(ATTR_TYPE);
        if (this.type.isEmpty()) {
            this.type = null;
        }
        if (this.signedMarks == null) {
            this.signedMarks = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:signedMark-1.0", "encodedSignedMark", EPPSignedMark.class);
            if (this.signedMarks != null && this.signedMarks.isEmpty()) {
                this.signedMarks = null;
            }
        }
        if (this.signedMarks == null) {
            this.signedMarks = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:signedMark-1.0", "signedMark", EPPSignedMark.class);
            if (this.signedMarks != null && this.signedMarks.isEmpty()) {
                this.signedMarks = null;
            }
        }
        this.codeMarks = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:codeMark", EPPLaunchCodeMark.class);
        if (this.codeMarks != null && this.codeMarks.isEmpty()) {
            this.codeMarks = null;
        }
        this.notice = (EPPLaunchNotice)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:notice", EPPLaunchNotice.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchCreate)) {
            cat.error((Object)("EPPLaunchCreate.equals(): " + aObject.getClass().getName() + " not EPPLaunchCreate instance"));
            return false;
        }
        EPPLaunchCreate other = (EPPLaunchCreate)aObject;
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error((Object)"EPPLaunchCreate.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.phase, other.phase)) {
            cat.error((Object)"EPPLaunchCreate.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.signedMarks, other.signedMarks)) {
            cat.error((Object)"EPPLaunchCreate.equals(): signedMark not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.codeMarks, other.codeMarks)) {
            cat.error((Object)"EPPLaunchCreate.equals(): codeMark not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.notice, other.notice)) {
            cat.error((Object)"EPPLaunchCreate.equals(): notice not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

