/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.suggestion.EPPSuggestionAnswer;
import com.verisign.epp.codec.suggestion.EPPSuggestionCell;
import com.verisign.epp.codec.suggestion.EPPSuggestionGrid;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoCmd;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoResp;
import com.verisign.epp.codec.suggestion.EPPSuggestionRecord;
import com.verisign.epp.codec.suggestion.EPPSuggestionRow;
import com.verisign.epp.codec.suggestion.EPPSuggestionTable;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.codec.suggestion.util.RandomHelper;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPSuggestionHandler;
import com.verisign.epp.serverstub.SessionData;

public class SuggestionHandler
extends EPPSuggestionHandler {
    private static final String svrTransId = "SRV-43659";

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2002);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected EPPEventResponse doSuggestionInfo(EPPEvent aEvent, Object aData) {
        EPPSuggestionInfoCmd theMessage = (EPPSuggestionInfoCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPSuggestionInfoResp theResponse = new EPPSuggestionInfoResp(theTransId, theMessage.getKey());
        theResponse.setResult(1000);
        if (theMessage.getKey().equalsIgnoreCase("RANDOMIZE")) {
            try {
                theResponse = RandomHelper.getResponse(theMessage.getTransId());
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
        } else if (theMessage.getFilter() == null || theMessage.getFilter().isTable()) {
            EPPSuggestionTable theTable = new EPPSuggestionTable();
            try {
                theTable.addRow(new EPPSuggestionRow("SOCCERTEAM.COM", 1000, "registered"));
                theTable.addRow(new EPPSuggestionRow("SOCCERTEAM.CC", 930, "available"));
                theTable.addRow(new EPPSuggestionRow("SOCCERGROUP.NET", 720, "available"));
                theTable.addRow(new EPPSuggestionRow("FOOTBALLGROUP.NET", 710, "available"));
                theTable.addRow(new EPPSuggestionRow("SOCCERSPIRIT.NET", 710, "available"));
                theTable.addRow(new EPPSuggestionRow("SOCCERSQUAD.NET", 700, "available"));
                theTable.addRow(new EPPSuggestionRow("THESOCCERTEAM.NET", 690, "available"));
                theTable.addRow(new EPPSuggestionRow("SOCCERTEAMUP.COM", 680, "available"));
                theTable.addRow(new EPPSuggestionRow("FOOTBALLTEAMUP.COM", 670, "available"));
                theTable.addRow(new EPPSuggestionRow("TEAMTEAMUP.COM", 670, "available"));
                theTable.addRow(new EPPSuggestionRow("SOCCERGANG.COM", 660, "available"));
                theTable.addRow(new EPPSuggestionRow("SOCCERWORK.COM", 660, "available"));
                theTable.addRow(new EPPSuggestionRow("SOCCERTEAMUP.NET", 660, "available"));
                theTable.addRow(new EPPSuggestionRow("SOCCERTEAMS.CC", 660, "available"));
                theTable.addRow(new EPPSuggestionRow("FREESOCCERTEAM.COM", 650, "available"));
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            theResponse.setAnswer(new EPPSuggestionAnswer(theTable));
        } else {
            EPPSuggestionGrid theGrid = new EPPSuggestionGrid();
            EPPSuggestionRecord theRecord = null;
            try {
                theRecord = new EPPSuggestionRecord("SOCCERTEAM");
                theRecord.addCell(new EPPSuggestionCell("COM", 1000, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 975, "registered"));
                theRecord.addCell(new EPPSuggestionCell("TV", 966, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("SOCCERGROUP");
                theRecord.addCell(new EPPSuggestionCell("COM", 675, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 702, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 640, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("FOOTBALLGROUP");
                theRecord.addCell(new EPPSuggestionCell("COM", 667, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 694, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 632, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("SOCCERSPIRIT");
                theRecord.addCell(new EPPSuggestionCell("COM", 667, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 694, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 632, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("THESOCCERTEAM");
                theRecord.addCell(new EPPSuggestionCell("COM", 665, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 693, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 630, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("SOCCERSQUAD");
                theRecord.addCell(new EPPSuggestionCell("COM", 659, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 687, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 624, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("BALLWORK");
                theRecord.addCell(new EPPSuggestionCell("COM", 651, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 679, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 617, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("TEAMUNIT");
                theRecord.addCell(new EPPSuggestionCell("COM", 651, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 679, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 617, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("FOOTBALLTEAMS");
                theRecord.addCell(new EPPSuggestionCell("COM", 711, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 686, "registered"));
                theRecord.addCell(new EPPSuggestionCell("TV", 677, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("SOCCERTEAMUP");
                theRecord.addCell(new EPPSuggestionCell("COM", 664, "available"));
                theRecord.addCell(new EPPSuggestionCell("NET", 639, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 614, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("TEAMGANG");
                theRecord.addCell(new EPPSuggestionCell("COM", 636, "available"));
                theRecord.addCell(new EPPSuggestionCell("NET", 664, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 601, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("SOCCERWORK");
                theRecord.addCell(new EPPSuggestionCell("COM", 695, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 670, "registered"));
                theRecord.addCell(new EPPSuggestionCell("TV", 662, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("FOOTBALLTEAMUP");
                theRecord.addCell(new EPPSuggestionCell("COM", 656, "available"));
                theRecord.addCell(new EPPSuggestionCell("NET", 632, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 607, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("FOOTBALLWORK");
                theRecord.addCell(new EPPSuggestionCell("COM", 656, "available"));
                theRecord.addCell(new EPPSuggestionCell("NET", 632, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 607, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("SOCCERUNIT");
                theRecord.addCell(new EPPSuggestionCell("COM", 656, "available"));
                theRecord.addCell(new EPPSuggestionCell("NET", 632, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 607, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("RUGBYPOOL");
                theRecord.addCell(new EPPSuggestionCell("COM", 628, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 656, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 593, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("FREESOCCERTEAM");
                theRecord.addCell(new EPPSuggestionCell("COM", 655, "available"));
                theRecord.addCell(new EPPSuggestionCell("NET", 630, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 605, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("SOCCERTEAMONLINE");
                theRecord.addCell(new EPPSuggestionCell("COM", 655, "available"));
                theRecord.addCell(new EPPSuggestionCell("NET", 630, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 605, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("WEBSOCCERTEAM");
                theRecord.addCell(new EPPSuggestionCell("COM", 655, "available"));
                theRecord.addCell(new EPPSuggestionCell("NET", 630, "available"));
                theRecord.addCell(new EPPSuggestionCell("TV", 605, "available"));
                theGrid.addRecord(theRecord);
                theRecord = new EPPSuggestionRecord("MYSOCCERTEAM");
                theRecord.addCell(new EPPSuggestionCell("COM", 686, "registered"));
                theRecord.addCell(new EPPSuggestionCell("NET", 661, "registered"));
                theRecord.addCell(new EPPSuggestionCell("TV", 652, "available"));
                theGrid.addRecord(theRecord);
            }
            catch (InvalidValueException e) {
                e.printStackTrace();
            }
            theResponse.setAnswer(new EPPSuggestionAnswer(theGrid));
        }
        theResponse.setLanguage(theMessage.getLanguage());
        return new EPPEventResponse(theResponse);
    }
}

