/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPDcp;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPPurpose;
import com.verisign.epp.codec.gen.EPPRecipient;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPStatement;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPDispatcher;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.transport.ServerEventHandler;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class ClientConnectionHandler
implements ServerEventHandler,
Cloneable {
    private static Logger cat = Logger.getLogger((String)ClientConnectionHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final int TIMEOUT_MINUTES = 3;
    private boolean bRunning = true;
    private int SessionCommandCount = 0;
    private SessionData thisSession = new SessionData();
    private GregorianCalendar idleTimeOutTime = new GregorianCalendar();

    public ClientConnectionHandler() {
        this.idleTimeOutTime.add(12, 3);
    }

    public Object clone() throws CloneNotSupportedException {
        ClientConnectionHandler theCopy = (ClientConnectionHandler)super.clone();
        theCopy.thisSession = (SessionData)this.thisSession.clone();
        theCopy.idleTimeOutTime = (GregorianCalendar)this.idleTimeOutTime.clone();
        return theCopy;
    }

    public void handleConnection(InputStream newInputStream, OutputStream newOutputStream) {
        cat.debug((Object)("Server accepted new connection. Thread id is: " + Thread.currentThread().hashCode()));
        EPPGreeting greeting = new EPPGreeting();
        int threadId = Thread.currentThread().hashCode();
        greeting.setServer(EPPEnv.getGreetingServerName());
        cat.debug((Object)("Server name = " + greeting.getServer()));
        EPPDcp theDCP = new EPPDcp();
        theDCP.setAccess((short)0);
        EPPStatement theStatement = new EPPStatement();
        EPPPurpose thePurpose = new EPPPurpose();
        thePurpose.setAdmin(true);
        thePurpose.setProv(true);
        theStatement.setPurpose(thePurpose);
        EPPRecipient theRecipient = new EPPRecipient();
        theRecipient.addOurs(null);
        theRecipient.setPublic(true);
        theStatement.setRecipient(theRecipient);
        theStatement.setRetention((short)4);
        theDCP.addStatement(theStatement);
        cat.debug((Object)("Adding DCP to Greeting: " + theDCP));
        greeting.setDcp(theDCP);
        this.thisSession.setGreeting(greeting);
        this.idleTimeOutTime = new GregorianCalendar();
        this.idleTimeOutTime.add(12, 3);
        EPPDispatcher theDispatcher = EPPDispatcher.getInstance();
        theDispatcher.processConnection(newInputStream, newOutputStream, this.thisSession);
        while (this.bRunning) {
            try {
                theDispatcher.processMessage(newInputStream, newOutputStream, this.thisSession);
                ++this.SessionCommandCount;
                this.resetIdleTimeOut();
                this.bRunning = !this.thisSession.hasLogoutOccured();
            }
            catch (EPPEventException e) {
                cat.error((Object)"EPP Event Exception", (Throwable)e);
                this.sendErrorResponse(2400, "Internal Server Error, EPP Event Exception" + e.getMessage(), newOutputStream, this.thisSession);
            }
            catch (EPPAssemblerException ex) {
                if (ex.equals(EPPAssemblerException.FATAL)) {
                    cat.fatal((Object)"Fatal EPPAssemblerException caught stopping client thread", (Throwable)ex);
                    this.sendErrorResponse(2400, "Internal Server Error, EPPAssemblerException: " + ex.getMessage(), newOutputStream, this.thisSession);
                    this.bRunning = false;
                    continue;
                }
                if (ex.equals(EPPAssemblerException.XML)) {
                    cat.error((Object)"EPPAssemblerException.XML, sending COMMAND_SYNTAX_ERROR response to client");
                    this.sendErrorResponse(2001, "XML Schema Validation Error, " + ex.getMessage(), newOutputStream, this.thisSession);
                    continue;
                }
                if (ex.equals(EPPAssemblerException.MISSINGPARAMETER)) {
                    cat.error((Object)"EPPAssemblerException.MISSINGPARAMETER, sending MISSINGPARAMETER response to client");
                    this.sendErrorResponse(2003, "Command processing error, , " + ex.getMessage(), newOutputStream, this.thisSession);
                    continue;
                }
                if (ex.equals(EPPAssemblerException.COMMANDNOTFOUND)) {
                    cat.error((Object)"EPPAssemblerException.COMMANDNOTFOUND, sending UNIMPLEMENTED_COMMAND response to client");
                    this.sendErrorResponse(2101, "Command not found, " + ex.getMessage(), newOutputStream, this.thisSession);
                    continue;
                }
                if (ex.equals(EPPAssemblerException.EXTENSIONNOTFOUND)) {
                    cat.error((Object)"EPPAssemblerException.EXTENSIONNOTFOUND, sending UNIMPLEMENTED_EXTENSION response to client");
                    this.sendErrorResponse(2103, "Extension not found, " + ex.getMessage(), newOutputStream, this.thisSession);
                    continue;
                }
                if (ex.equals(EPPAssemblerException.CLOSECON)) {
                    cat.error((Object)"EPPAssemblerException.CLOSECON caught, stopping thread");
                    this.bRunning = false;
                    continue;
                }
                if (ex.equals(EPPAssemblerException.INTRUPTEDIO)) {
                    cat.debug((Object)"EPPAssemblerException.INTRUPTEDIO caught, no command received");
                    continue;
                }
                cat.error((Object)"Unknown EPPAssemblerException type");
                this.sendErrorResponse(2400, "Internal Server Error, Unknown EPPAssemblerException" + ex.getMessage(), newOutputStream, this.thisSession);
            }
        }
        cat.debug((Object)("Server closed connection. Thread id is: " + Thread.currentThread().hashCode()));
    }

    private void sendErrorResponse(int aCode, String aDescription, OutputStream out, SessionData aSessionData) {
        cat.debug((Object)"<<<<<<<<<<<<<<<<<<<<<<  Enter sendErrorResponse()>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        cat.debug((Object)("Sending error response to client, code = " + aCode + ", description = " + aDescription));
        EPPResult theResult = new EPPResult(aCode);
        theResult.addExtValueReason(aDescription);
        EPPTransId theTransId = new EPPTransId("svrError1");
        EPPResponse response = new EPPResponse(theTransId, theResult);
        try {
            EPPDispatcher.getInstance().send(response, out);
            out.flush();
        }
        catch (Exception e) {
            cat.debug((Object)".sendErrorResponse() Error sending error response to client: ");
        }
        cat.debug((Object)".sendErrorResponse() Return");
    }

    public void close() {
        this.bRunning = false;
    }

    protected void resetIdleTimeOut() {
        this.idleTimeOutTime.setTime(new Date());
        this.idleTimeOutTime.add(12, 3);
    }
}

