/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool;

import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.pool.EPPPooledSession;
import com.verisign.epp.pool.EPPSessionPoolException;
import com.verisign.epp.pool.EPPSessionPoolableFactory;
import com.verisign.epp.pool.EPPSystemSessionPool;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EnvException;
import com.verisign.epp.util.Environment;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSessionPool {
    public static final long DEFAULT_ABSOLUTE_TIMEOUT = 86400000L;
    public static final long DEFAULT_IDLE_TIMEOUT = 600000L;
    public static final long DEFAULT_MAX_WAIT = 60000L;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = 60000L;
    public static final int DEFAULT_MAX_IDLE = 10;
    public static final int DEFAULT_MAX_ACTIVE = 10;
    public static final int DEFAULT_MIN_IDLE = 0;
    private static final boolean DEFAULT_INIT_MAX_ACTIVE = false;
    private static final int DEFAULT_BORROW_RETRIES = 0;
    private static final String PROP_PREFIX = "EPP.SessionPool";
    private static Logger log = Logger.getLogger((String)EPPSessionPool.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private GenericObjectPool pool = null;
    private Map systemPools = new HashMap();
    protected static EPPSessionPool instance = new EPPSessionPool();
    private GenericObjectPool.Config config = new GenericObjectPool.Config();
    private EPPSessionPoolableFactory factory = null;
    private boolean initMaxActive = false;
    private int borrowRetries = 0;
    private String clientId;
    private String password;
    private long idleTimeout;
    private long absoluteTimeout;
    private String serverName;
    private Integer serverPort;
    private String clientHost = null;
    public static final String DEFAULT = "default";

    protected EPPSessionPool() {
    }

    public static EPPSessionPool getInstance() {
        return instance;
    }

    public void init(EPPSessionPoolableFactory aFactory, GenericObjectPool.Config aConfig) {
        this.pool = new GenericObjectPool((PoolableObjectFactory)aFactory, aConfig);
    }

    public void init() throws EPPSessionPoolException {
        try {
            String theValue = this.getProperty("systemPools");
            if (theValue == null) {
                log.info((Object)"Initializing a single session pool");
                this.initSinglePool();
            } else {
                log.info((Object)("Initializing system session pools with systems = " + theValue));
                this.initSystemPools(theValue);
            }
        }
        catch (EnvException ex) {
            throw new EPPSessionPoolException("init(): EnvException: " + ex);
        }
    }

    public void close() {
        log.info((Object)"close(): closing pool");
        if (this.pool != null) {
            this.pool.clear();
            try {
                this.pool.close();
            }
            catch (Exception ex) {
                log.error((Object)("EPPSessionPool.close(): Exception closing default pool <" + this.pool + ">: " + ex));
            }
        }
        if (this.systemPools != null) {
            Set theSystemKeys = this.systemPools.keySet();
            for (String theCurrKey : theSystemKeys) {
                EPPSystemSessionPool theCurrPool = (EPPSystemSessionPool)this.systemPools.get(theCurrKey);
                theCurrPool.close();
            }
        }
        log.info((Object)"close(): pool closed");
    }

    private void initSystemPools(String aPoolsProp) throws EPPSessionPoolException {
        log.debug((Object)("initSystemPools: enter, aPoolProp = " + aPoolsProp));
        StringTokenizer thePools = new StringTokenizer(aPoolsProp, ",");
        while (thePools.hasMoreTokens()) {
            String theSystem = thePools.nextToken();
            if (theSystem.equals(DEFAULT)) {
                log.info((Object)"initSystemPools: Initializing the default pool");
                this.initSinglePool();
                continue;
            }
            log.info((Object)("initSystemPools: Initializing " + theSystem + " system pool"));
            EPPSystemSessionPool theSessionPool = new EPPSystemSessionPool(theSystem);
            theSessionPool.init();
            this.systemPools.put(theSystem, theSessionPool);
        }
        log.debug((Object)"initSystemPools: exit");
    }

    private void initSinglePool() throws EPPSessionPoolException {
        log.debug((Object)"initSinglePool: enter");
        try {
            this.clientId = this.getProperty("clientId");
            if (this.clientId == null) {
                log.error((Object)"EPPSessionPool.initSinglePool(): clientId not defined");
                throw new EPPSessionPoolException("clientId not defined");
            }
            this.password = this.getProperty("password");
            if (this.password == null) {
                log.error((Object)"EPPSessionPool.initSinglePool(): password not defined");
                throw new EPPSessionPoolException("password not defined");
            }
            String theValue = this.getProperty("absoluteTimeout");
            this.absoluteTimeout = theValue != null ? Long.parseLong(theValue) : 86400000L;
            log.info((Object)("init(): absolute timeout = " + this.absoluteTimeout + " ms"));
            theValue = this.getProperty("idleTimeout");
            this.idleTimeout = theValue != null ? Long.parseLong(theValue) : 600000L;
            log.info((Object)("init(): idle timeout = " + this.idleTimeout + " ms"));
            theValue = this.getProperty("poolableClassName");
            if (theValue == null) {
                log.error((Object)"EPPSessionPool.initSinglePool(): EPP.SessionPool.poolableClassName not defined");
                throw new EPPSessionPoolException("EPP.SessionPool.poolableClassName not defined");
            }
            log.info((Object)("init(): poolable class name = " + theValue));
            try {
                this.factory = (EPPSessionPoolableFactory)Class.forName(theValue).newInstance();
            }
            catch (Exception ex) {
                log.error((Object)("EPPSessionPool.initSinglePool(): Exception creating instance of class " + theValue + ": " + ex));
                throw new EPPSessionPoolException("Exception creating instance of class " + theValue + ": " + ex);
            }
            this.config.minEvictableIdleTimeMillis = 0L;
            theValue = this.getProperty("maxIdle");
            this.config.maxIdle = theValue != null ? Integer.parseInt(theValue) : 10;
            log.info((Object)("initSinglePool(): max idle = " + this.config.maxIdle));
            theValue = this.getProperty("maxActive");
            this.config.maxActive = theValue != null ? Integer.parseInt(theValue) : 10;
            log.info((Object)("initSinglePool(): max active = " + this.config.maxActive));
            theValue = this.getProperty("initMaxActive");
            this.initMaxActive = theValue != null ? Boolean.valueOf(theValue) : false;
            log.info((Object)("initSinglePool(): init max active = " + this.initMaxActive));
            theValue = this.getProperty("borrowRetries");
            this.borrowRetries = theValue != null ? Integer.parseInt(theValue) : 0;
            log.info((Object)("initSinglePool(): borrow retries = " + this.borrowRetries));
            theValue = this.getProperty("maxWait");
            this.config.maxWait = theValue != null ? (long)Integer.parseInt(theValue) : 60000L;
            log.info((Object)("initSinglePool(): max wait = " + this.config.maxWait));
            theValue = this.getProperty("minIdle");
            this.config.minIdle = theValue != null ? Integer.parseInt(theValue) : 0;
            log.info((Object)("initSinglePool(): min idle = " + this.config.minIdle));
            this.config.numTestsPerEvictionRun = -1;
            this.config.testOnBorrow = false;
            this.config.testOnReturn = false;
            this.config.testWhileIdle = true;
            theValue = this.getProperty("timeBetweenEvictionRunsMillis");
            this.config.timeBetweenEvictionRunsMillis = theValue != null ? Long.parseLong(theValue) : 60000L;
            log.info((Object)("initSinglePool(): time between eviction runs = " + this.config.timeBetweenEvictionRunsMillis + " ms"));
            this.config.whenExhaustedAction = 1;
            this.serverName = EPPEnv.getServerName();
            log.info((Object)("initSinglePool(): serverName = " + this.serverName));
            theValue = Environment.getEnv("EPP.ServerPort");
            if (theValue != null) {
                this.serverPort = new Integer(theValue);
            }
            log.info((Object)("initSinglePool(): serverPort = " + this.serverPort));
            this.clientHost = EPPEnv.getClientHost();
            log.info((Object)("initSinglePool(): clientHost = " + this.clientHost));
        }
        catch (EPPEnvException ex) {
            log.error((Object)("EPPSessionPool.initSinglePool(): EPPEnvException referencing Environment property: " + ex));
            throw new EPPSessionPoolException("EPPEnvException referencing Environment property: " + ex);
        }
        catch (EnvException ex) {
            log.error((Object)("EPPSessionPool.initSinglePool(): EnvException referencing Environment property: " + ex));
            throw new EPPSessionPoolException("EnvException referencing Environment property: " + ex);
        }
        this.factory.setAbsoluteTimeout(this.absoluteTimeout);
        this.factory.setIdleTimeout(this.idleTimeout);
        this.factory.setClientId(this.clientId);
        this.factory.setPassword(this.password);
        this.factory.setServerName(this.serverName);
        this.factory.setServerPort(this.serverPort);
        this.factory.setClientHost(this.clientHost);
        this.init(this.factory, this.config);
        if (this.initMaxActive && this.config.maxActive > 0) {
            int i;
            log.info((Object)("initSinglePool(): Pre-initialize maxActive (" + this.config.maxActive + ") sessions"));
            EPPSession[] theSessions = new EPPSession[this.config.maxActive];
            for (i = 0; i < this.config.maxActive; ++i) {
                try {
                    theSessions[i] = this.borrowObject();
                    log.info((Object)("initSinglePool(): Pre-initialized session #" + (i + 1)));
                    continue;
                }
                catch (EPPSessionPoolException ex) {
                    log.error((Object)("initSinglePool(): Failure to pre-initialize session #" + (i + 1) + ": " + ex));
                }
            }
            for (i = 0; i < this.config.maxActive; ++i) {
                if (theSessions[i] == null) continue;
                this.returnObject(theSessions[i]);
                theSessions[i] = null;
            }
        }
        log.debug((Object)"initSinglePool: exit");
    }

    public EPPSession borrowObject() throws EPPSessionPoolException {
        if (this.pool == null) {
            log.error((Object)"borrowObject(): pool is null");
            throw new EPPSessionPoolException("EPPSessionPool: pool is null");
        }
        EPPSession theSession = null;
        for (int retries = 0; theSession == null && retries <= this.borrowRetries; ++retries) {
            try {
                theSession = (EPPSession)this.pool.borrowObject();
                log.debug((Object)("borrowObject(): Session = " + theSession + ", Active = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle()));
                continue;
            }
            catch (Exception ex) {
                if (retries >= this.borrowRetries) {
                    log.error((Object)("borrowObject(): Final exception on borrow session after " + retries + " retries: " + ex));
                    throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
                }
                log.debug((Object)("borrowObject(): Exception on borrow session after " + retries + " retries: " + ex));
            }
        }
        return theSession;
    }

    public EPPSession borrowObject(String aSystem) throws EPPSessionPoolException {
        if (aSystem != null && aSystem.equals(DEFAULT)) {
            return this.borrowObject();
        }
        EPPSystemSessionPool thePool = this.getSystemSessionPool(aSystem);
        EPPSession theSession = null;
        try {
            theSession = thePool.borrowObject();
            log.debug((Object)("borrowObject(" + aSystem + "): Session = " + theSession + ", Active = " + thePool.getGenericObjectPool().getNumActive() + ", Idle = " + thePool.getGenericObjectPool().getNumIdle()));
        }
        catch (Exception ex) {
            log.error((Object)("borrowObject(" + aSystem + "): Caught Exception: " + ex));
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
        return theSession;
    }

    public void invalidateObject(EPPSession aSession) throws EPPSessionPoolException {
        if (aSession == null) {
            log.error((Object)("invalidateObject(" + aSession + "): session is null"));
            throw new EPPSessionPoolException("EPPSessionPool: session is null");
        }
        if (this.pool == null) {
            log.error((Object)("invalidateObject(" + aSession + "): pool is null"));
            throw new EPPSessionPoolException("EPPSessionPool: pool is null");
        }
        try {
            this.pool.invalidateObject((Object)aSession);
            log.debug((Object)("invalidateObject(" + aSession + "): Active = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle()));
        }
        catch (Exception ex) {
            log.error((Object)("invalidateObject(" + aSession + "): Caught Exception: " + ex));
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public void invalidateObject(String aSystem, EPPSession aSession) throws EPPSessionPoolException {
        if (aSession == null) {
            log.error((Object)("invalidateObject(" + aSystem + ", " + aSession + "): session is null"));
            throw new EPPSessionPoolException("EPPSessionPool: session is null");
        }
        if (aSystem != null && aSystem.equals(DEFAULT)) {
            this.invalidateObject(aSession);
            return;
        }
        EPPSystemSessionPool thePool = this.getSystemSessionPool(aSystem);
        try {
            thePool.invalidateObject(aSession);
            log.debug((Object)("invalidateObject(" + aSystem + ", " + aSession + "): Active = " + thePool.getGenericObjectPool().getNumActive() + ", Idle = " + thePool.getGenericObjectPool().getNumIdle()));
        }
        catch (Exception ex) {
            log.error((Object)("invalidateObject(" + aSystem + ", " + aSession + "): Caught Exception: " + ex));
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public void returnObject(EPPSession aSession) throws EPPSessionPoolException {
        if (aSession == null) {
            log.error((Object)("returnObject(" + aSession + "): session is null"));
            throw new EPPSessionPoolException("EPPSessionPool: session is null");
        }
        if (this.pool == null) {
            log.error((Object)("returnObject(" + aSession + "): pool is null"));
            throw new EPPSessionPoolException("EPPSessionPool: pool is null");
        }
        this.touchSession(aSession);
        try {
            this.pool.returnObject((Object)aSession);
            log.debug((Object)("returnObject(" + aSession + "): Active = " + this.pool.getNumActive() + ", Idle = " + this.pool.getNumIdle()));
        }
        catch (Exception ex) {
            log.error((Object)("returnObject(" + aSession + "): Caught Exception: " + ex));
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public void returnObject(String aSystem, EPPSession aSession) throws EPPSessionPoolException {
        if (aSession == null) {
            log.error((Object)("returnObject(" + aSystem + ", " + aSession + "): session is null"));
            throw new EPPSessionPoolException("EPPSessionPool: session is null");
        }
        if (aSystem != null && aSystem.equals(DEFAULT)) {
            this.returnObject(aSession);
            return;
        }
        EPPSystemSessionPool thePool = this.getSystemSessionPool(aSystem);
        this.touchSession(aSession);
        try {
            thePool.returnObject(aSession);
            log.debug((Object)("returnObject(" + aSystem + ", " + aSession + "): Active = " + thePool.getGenericObjectPool().getNumActive() + ", Idle = " + thePool.getGenericObjectPool().getNumIdle()));
        }
        catch (Exception ex) {
            log.error((Object)("returnObject(" + aSystem + ", " + aSession + "): Caught Exception: " + ex));
            throw new EPPSessionPoolException("EPPSessionPool: Exception " + ex);
        }
    }

    public GenericObjectPool getGenericObjectPool() {
        return this.pool;
    }

    public EPPSystemSessionPool getSystemSessionPool(String aSystem) throws EPPSessionPoolException {
        EPPSystemSessionPool theSystemPool = (EPPSystemSessionPool)this.systemPools.get(aSystem);
        if (theSystemPool == null) {
            log.error((Object)("getGenericObjectPool(): Could not find system pool " + aSystem));
            throw new EPPSessionPoolException("Could not find system pool " + aSystem);
        }
        return theSystemPool;
    }

    public GenericObjectPool getGenericObjectPool(String aSystem) throws EPPSessionPoolException {
        EPPSystemSessionPool theSystemPool = this.getSystemSessionPool(aSystem);
        if (theSystemPool.getGenericObjectPool() == null) {
            log.error((Object)("getGenericObjectPool(): GenericObjectPool is null for system pool " + aSystem));
            throw new EPPSessionPoolException("GenericObjectPool is null for system pool " + aSystem);
        }
        return theSystemPool.getGenericObjectPool();
    }

    public long getAbsoluteTimeout() {
        return this.absoluteTimeout;
    }

    public String getClientId() {
        return this.clientId;
    }

    public GenericObjectPool.Config getConfig() {
        return this.config;
    }

    public EPPSessionPoolableFactory getFactory() {
        return this.factory;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String aServerName) {
        this.serverName = aServerName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer aServerPort) {
        this.serverPort = aServerPort;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String aClientHost) {
        this.clientHost = aClientHost;
    }

    private String getProperty(String aProperty) throws EnvException {
        return Environment.getProperty("EPP.SessionPool." + aProperty);
    }

    private void touchSession(EPPSession aSession) throws EPPSessionPoolException {
        if (!(aSession instanceof EPPPooledSession)) {
            log.error((Object)("touchSession(" + aSession + "): Session class " + aSession.getClass().getName() + " does not implement EPPPooledSession"));
            throw new EPPSessionPoolException("EPPSessionPool: Session class " + aSession.getClass().getName() + " does not implement EPPPooledSession");
        }
        ((EPPPooledSession)((Object)aSession)).touch();
    }
}

