/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.namestore.interfaces;

import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCheckResp;
import com.verisign.epp.codec.contact.EPPContactCheckResult;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactDiscloseAddress;
import com.verisign.epp.codec.contact.EPPContactDiscloseName;
import com.verisign.epp.codec.contact.EPPContactDiscloseOrg;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.namestore.interfaces.NSContact;
import com.verisign.epp.pool.EPPSessionPool;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.InvalidateSessionException;
import com.verisign.epp.util.TestThread;
import com.verisign.epp.util.TestUtil;
import java.util.Random;
import java.util.Vector;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class NSContactTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)NSContactTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static EPPSessionPool sessionPool = null;
    private Random rd = new Random(System.currentTimeMillis());

    public NSContactTst(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContactCreate() {
        NSContactTst.printStart("testContactCreate");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSContact theContact = new NSContact(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                String theContactName = this.makeContactName();
                System.out.println("testContactCreate: Create " + theContactName);
                theContact.setTransId("ABC-12345-XYZ");
                theContact.setAuthorizationId("ClientXYZ");
                theContact.addContactId(theContactName);
                theContact.setVoicePhone("+1.7035555555");
                theContact.setVoiceExt("123");
                theContact.setFaxNumber("+1.7035555556");
                theContact.setFaxExt("456");
                theContact.setEmail("jdoe@example.com");
                Vector<String> streets = new Vector<String>();
                streets.addElement("123 Example Dr.");
                streets.addElement("Suite 100");
                streets.addElement("This is third line");
                EPPContactAddress address = new EPPContactAddress();
                address.setStreets(streets);
                address.setCity("Dulles");
                address.setStateProvince("VA");
                address.setPostalCode("20166-6503");
                address.setCountry("US");
                EPPContactPostalDefinition name = new EPPContactPostalDefinition("loc");
                name.setName("John Doe");
                name.setOrg("Example Inc.");
                name.setAddress(address);
                theContact.addPostalInfo(name);
                EPPContactAddress Intaddress = new EPPContactAddress();
                Intaddress.setStreets(streets);
                Intaddress.setCity("Dulles");
                Intaddress.setStateProvince("VA");
                Intaddress.setPostalCode("20166-6503");
                Intaddress.setCountry("US");
                EPPContactPostalDefinition Intname = new EPPContactPostalDefinition("int");
                Intname.setName("John Doe");
                Intname.setOrg("Example Inc.");
                Intname.setAddress(Intaddress);
                theContact.addPostalInfo(Intname);
                Vector<EPPContactDiscloseName> names = new Vector<EPPContactDiscloseName>();
                names.addElement(new EPPContactDiscloseName("int"));
                Vector<EPPContactDiscloseOrg> orgs = new Vector<EPPContactDiscloseOrg>();
                orgs.addElement(new EPPContactDiscloseOrg("loc"));
                orgs.addElement(new EPPContactDiscloseOrg("int"));
                Vector<EPPContactDiscloseAddress> addresses = new Vector<EPPContactDiscloseAddress>();
                addresses.addElement(new EPPContactDiscloseAddress("loc"));
                addresses.addElement(new EPPContactDiscloseAddress("int"));
                EPPContactDisclose disclose = new EPPContactDisclose();
                disclose.setFlag("0");
                disclose.setNames(names);
                disclose.setOrgs(orgs);
                disclose.setAddresses(addresses);
                disclose.setVoice("");
                disclose.setFax("");
                disclose.setEmail("");
                theContact.setDisclose(disclose);
                theResponse = theContact.sendCreate();
                System.out.println("testContactCreate: Response = [" + theResponse + "]\n\n");
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSContactTst.printEnd("testContactCreate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContactCheck() {
        NSContactTst.printStart("testContactCheck");
        EPPSession theSession = null;
        EPPContactCheckResp theResponse = null;
        try {
            theSession = this.borrowSession();
            NSContact theContact = new NSContact(theSession);
            try {
                System.out.println("\n----------------------------------------------------------------");
                String theContactName = this.makeContactName();
                System.out.println("testContactCheck: Check single contact id (" + theContactName + ")");
                theContact.setTransId("ABC-12345-XYZ");
                theContact.addContactId(theContactName);
                theContact.setSubProductID("dotCOM");
                theResponse = theContact.sendCheck();
                System.out.println("Response Type = " + theResponse.getType());
                System.out.println("Response.TransId.ServerTransId = " + theResponse.getTransId().getServerTransId());
                System.out.println("Response.TransId.ServerTransId = " + theResponse.getTransId().getClientTransId());
                System.out.println("\ntestContactCheck: Response = [" + theResponse + "]");
                for (int i = 0; i < theResponse.getCheckResults().size(); ++i) {
                    EPPContactCheckResult currResult = (EPPContactCheckResult)theResponse.getCheckResults().elementAt(i);
                    if (currResult.isAvailable()) {
                        System.out.println("testContactCheck: Contact " + currResult.getId() + " is available");
                        continue;
                    }
                    System.out.println("testContactCheck: Contact " + currResult.getId() + " is not available");
                }
                this.handleResponse(theResponse);
            }
            catch (Exception e) {
                TestUtil.handleException(theSession, e);
            }
            try {
                int i;
                System.out.println("\n----------------------------------------------------------------");
                System.out.println("testContactCheck: Check multiple contact names (ns1.example.com, ns2.example.com, ns3.example.com)");
                theContact.setTransId("ABC-12345-XYZ");
                for (i = 0; i <= 10; ++i) {
                    theContact.addContactId(this.makeContactName());
                }
                theContact.setSubProductID("dotCOM");
                theResponse = theContact.sendCheck();
                System.out.println("\ntestContactCheck: Response = [" + theResponse + "]");
                System.out.println("Client Transaction Id = " + theResponse.getTransId().getClientTransId());
                System.out.println("Server Transaction Id = " + theResponse.getTransId().getServerTransId());
                for (i = 0; i < theResponse.getCheckResults().size(); ++i) {
                    EPPContactCheckResult currResult = (EPPContactCheckResult)theResponse.getCheckResults().elementAt(i);
                    if (currResult.isAvailable()) {
                        System.out.println("testContactCheck: Contact " + currResult.getId() + " is available");
                        continue;
                    }
                    System.out.println("testContactCheck: Contact " + currResult.getId() + " is not available");
                }
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException e) {
                TestUtil.handleException(theSession, e);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSContactTst.printEnd("testContactCheck");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContactInfo() {
        NSContactTst.printStart("testContactInfo");
        EPPSession theSession = null;
        EPPContactInfoResp theResponse = null;
        try {
            theSession = this.borrowSession();
            NSContact theContact = new NSContact(theSession);
            try {
                System.out.println("\ntestContactInfo: Contact info");
                theContact.setTransId("ABC-12345-XYZ");
                theContact.addContactId(this.makeContactName());
                theContact.setSubProductID("dotCOM");
                theResponse = theContact.sendInfo();
                System.out.println("testContactInfo: Response = [" + theResponse + "]\n\n");
                System.out.println("testContactInfo: id = " + theResponse.getId());
                Vector postalContacts = null;
                if (theResponse.getPostalInfo().size() > 0) {
                    postalContacts = theResponse.getPostalInfo();
                    for (int j = 0; j < postalContacts.size(); ++j) {
                        System.out.println("testContactInfo:\t\tname = " + ((EPPContactPostalDefinition)postalContacts.elementAt(j)).getName());
                        System.out.println("testContactInfo:\t\torganization = " + ((EPPContactPostalDefinition)postalContacts.elementAt(j)).getOrg());
                        EPPContactAddress address = ((EPPContactPostalDefinition)postalContacts.elementAt(j)).getAddress();
                        for (int i = 0; i < address.getStreets().size(); ++i) {
                            System.out.println("testContactInfo:\t\tstreet" + (i + 1) + " = " + address.getStreets().elementAt(i));
                        }
                        System.out.println("testContactInfo:\t\tcity = " + address.getCity());
                        System.out.println("testContactInfo:\t\tstate province = " + address.getStateProvince());
                        System.out.println("testContactInfo:\t\tpostal code = " + address.getPostalCode());
                        System.out.println("testContactInfo:\t\tcountry = " + address.getCountry());
                    }
                }
                System.out.println("testContactInfo:\temail = " + theResponse.getEmail());
                System.out.println("testContactInfo:\tvoice = " + theResponse.getVoice());
                System.out.println("testContactInfo:\tvoice ext = " + theResponse.getVoiceExt());
                System.out.println("testContactInfo:\tfax = " + theResponse.getFax());
                System.out.println("testContactInfo:\tfax ext = " + theResponse.getFaxExt());
                System.out.println("testContactInfo: client id = " + theResponse.getClientId());
                System.out.println("testContactInfo: created by = " + theResponse.getCreatedBy());
                System.out.println("testContactInfo: create date = " + theResponse.getCreatedDate());
                if (theResponse.getFax() != null) {
                    System.out.println("testContactInfo:\tfax = " + theResponse.getFax());
                }
                if (theResponse.getVoice() != null) {
                    System.out.println("testContactInfo:\tVoice = " + theResponse.getVoice());
                }
                if (theResponse.getLastUpdatedBy() != null) {
                    System.out.println("testContactInfo: last updated by = " + theResponse.getLastUpdatedBy());
                }
                if (theResponse.getLastUpdatedDate() != null) {
                    System.out.println("testContactInfo: last updated date = " + theResponse.getLastUpdatedDate());
                }
                if (theResponse.getLastTransferDate() != null) {
                    System.out.println("testContactInfo: last updated date = " + theResponse.getLastTransferDate());
                }
                if (theResponse.getAuthInfo() != null) {
                    System.out.println("testContactInfo: authorization info = " + theResponse.getAuthInfo().getPassword());
                }
                if (theResponse.getDisclose() != null) {
                    System.out.println("testContactInfo: disclose info = " + theResponse.getDisclose());
                }
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSContactTst.printEnd("testContactInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContactDelete() {
        NSContactTst.printStart("testContactDelete");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSContact theContact = new NSContact(theSession);
            try {
                System.out.println("\ntestContactDelete: Contact delete");
                theContact.setTransId("ABC-12345-XYZ");
                theContact.addContactId(this.makeContactName());
                theContact.setSubProductID("dotCOM");
                theResponse = theContact.sendDelete();
                System.out.println("testContactDelete: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSContactTst.printEnd("testContactDelete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContactUpdate() {
        NSContactTst.printStart("testContactUpdate");
        EPPSession theSession = null;
        EPPResponse theResponse = null;
        try {
            theSession = this.borrowSession();
            NSContact theContact = new NSContact(theSession);
            try {
                theContact.setTransId("ABC-12345-XYZ");
                String theContactName = this.makeContactName();
                System.out.println("\ncontactUpdate: Contact " + theContactName + " update");
                theContact.addContactId(theContactName);
                theContact.setSubProductID("dotCOM");
                Vector<String> streets = new Vector<String>();
                streets.addElement("123 Example Dr.");
                streets.addElement("Suite 100");
                streets.addElement("This is third line");
                EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
                EPPContactPostalDefinition postal = new EPPContactPostalDefinition("Joe Brown", "Example Corp.", "loc", address);
                theContact.addStatus("pendingDelete");
                theContact.addPostalInfo(postal);
                theContact.setVoicePhone("+1.7035555555");
                theContact.setVoiceExt("456");
                theContact.setFaxNumber("+1.7035555555");
                theContact.setFaxExt("789");
                theContact.setAuthorizationId("ClientXYZ");
                Vector<EPPContactDiscloseName> names = new Vector<EPPContactDiscloseName>();
                names.addElement(new EPPContactDiscloseName("int"));
                Vector<EPPContactDiscloseOrg> orgs = new Vector<EPPContactDiscloseOrg>();
                orgs.addElement(new EPPContactDiscloseOrg("loc"));
                orgs.addElement(new EPPContactDiscloseOrg("int"));
                Vector<EPPContactDiscloseAddress> addresses = new Vector<EPPContactDiscloseAddress>();
                addresses.addElement(new EPPContactDiscloseAddress("loc"));
                addresses.addElement(new EPPContactDiscloseAddress("int"));
                EPPContactDisclose disclose = new EPPContactDisclose();
                disclose.setFlag("0");
                disclose.setNames(names);
                disclose.setOrgs(orgs);
                disclose.setAddresses(addresses);
                disclose.setVoice("");
                disclose.setFax("");
                disclose.setEmail("");
                theContact.setDisclose(disclose);
                theResponse = theContact.sendUpdate();
                System.out.println("contactUpdate: Response = [" + theResponse + "]\n\n");
                this.handleResponse(theResponse);
            }
            catch (EPPCommandException ex) {
                TestUtil.handleException(theSession, ex);
            }
        }
        catch (InvalidateSessionException ex) {
            this.invalidateSession(theSession);
            theSession = null;
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSContactTst.printEnd("testContactUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEndSession() {
        NSContactTst.printStart("testEndSession");
        EPPSession theSession = null;
        try {
            theSession = this.borrowSession();
            sessionPool.invalidateObject(theSession);
            theSession = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("testEndSession(): Exception invalidating session: " + ex));
        }
        finally {
            if (theSession != null) {
                this.returnSession(theSession);
            }
        }
        NSContactTst.printEnd("testEndSession");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        return new NSContactTstSetup((Test)new TestSuite(NSContactTst.class));
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("NSContactTst Thread " + i, NSContactTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)NSContactTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private EPPSession borrowSession() {
        EPPSession theSession = null;
        try {
            theSession = sessionPool.borrowObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("borrowSession(): Exception borrowing session: " + ex));
        }
        return theSession;
    }

    private void returnSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.returnObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("returnSession(): Exception returning session: " + ex));
        }
    }

    private void invalidateSession(EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.invalidateObject(aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("invalidateSession(): Exception invalidating session: " + ex));
        }
    }

    private void handleResponse(EPPResponse aResponse) {
        for (int i = 0; i < aResponse.getResults().size(); ++i) {
            EPPResult theResult = (EPPResult)aResponse.getResults().elementAt(i);
            System.out.println("Result Code    : " + theResult.getCode());
            System.out.println("Result Message : " + theResult.getMessage());
            System.out.println("Result Lang    : " + theResult.getLang());
            if (theResult.isSuccess()) {
                System.out.println("Command Passed ");
            } else {
                System.out.println("Command Failed ");
            }
            if (theResult.getAllValues() == null) continue;
            for (int k = 0; k < theResult.getAllValues().size(); ++k) {
                System.out.println("Result Values  : " + theResult.getAllValues().elementAt(k));
            }
        }
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private static class NSContactTstSetup
    extends TestSetup {
        public NSContactTstSetup(Test aTest) {
            super(aTest);
        }

        protected void setUp() throws Exception {
            super.setUp();
            String theConfigFileName = System.getProperty("EPP.ConfigFile");
            if (theConfigFileName != null) {
                configFileName = theConfigFileName;
            }
            try {
                app.initialize(configFileName);
            }
            catch (EPPCommandException e) {
                e.printStackTrace();
                Assert.fail((String)("Error initializing the EPP Application: " + e));
            }
            try {
                sessionPool = EPPSessionPool.getInstance();
                sessionPool.init();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)("Error initializing the session pool: " + ex));
            }
        }

        protected void tearDown() throws Exception {
            super.tearDown();
            EPPSessionPool.getInstance().close();
        }
    }
}

