/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.secdnsext.v10;

import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtCreate;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtInfData;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtKeyData;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtUpdate;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPSecDNSDomainTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPSecDNSDomainTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPDomain domain = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPSecDNSDomainTst(String name) {
        super(name);
    }

    public void testDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("EPPSecDNSDomainTst Test Suite");
            this.domainCreate();
            this.domainInfo();
            this.domainUpdateSecDNSUpdateAdd();
            this.domainUpdateSecDNSUpdateChg();
            this.domainUpdateSecDNSUpdateRem();
            this.printEnd("EPPSecDNSDomainTst Test Suite");
            ++this.iteration;
        }
    }

    public void domainInfo() {
        this.printStart("EPPSecDNSDomainTst domainInfo");
        try {
            System.out.println("\ndomainInfo: Domain info");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            EPPDomainInfoResp response = this.domain.sendInfo();
            System.out.println("domainInfo: Response = [" + response + "]\n\n");
            System.out.println("domainInfo: name = " + response.getName());
            System.out.println("domainInfo: client id = " + response.getClientId());
            System.out.println("domainInfo: created by = " + response.getCreatedBy());
            System.out.println("domainInfo: create date = " + response.getCreatedDate());
            System.out.println("domainInfo: expiration date = " + response.getExpirationDate());
            if (response.hasExtension(EPPSecDNSExtInfData.class)) {
                EPPSecDNSExtInfData infData = (EPPSecDNSExtInfData)response.getExtension(EPPSecDNSExtInfData.class);
                List dsDataVec = infData.getDsData();
                EPPSecDNSExtDsData dsData2 = null;
                if (dsDataVec == null) {
                    System.out.println("domainInfo: secDNS:infData dsDataVec = " + dsDataVec);
                } else {
                    int i = 0;
                    for (EPPSecDNSExtDsData dsData2 : dsDataVec) {
                        System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyTag = " + dsData2.getKeyTag());
                        System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/alg = " + dsData2.getAlg());
                        System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/digestType = " + dsData2.getDigestType());
                        System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/digest = " + dsData2.getDigest());
                        System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/maxSigLife = " + dsData2.getMaxSigLife());
                        EPPSecDNSExtKeyData keyData = dsData2.getKeyData();
                        if (keyData == null) {
                            System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData = " + keyData);
                        } else {
                            System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData/flags = " + keyData.getFlags());
                            System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData/protocol = " + keyData.getProtocol());
                            System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData/alg = " + keyData.getAlg());
                            System.out.println("domainInfo: secDNS:infData/dsData[" + i + "]/keyData/pubKey = " + keyData.getPubKey());
                        }
                        ++i;
                    }
                }
            } else {
                System.out.println("domainInfo: no EPPSecDNSExtInfData extension");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("EPPSecDNSDomainTst domainInfo");
    }

    public void domainCreate() {
        this.printStart("EPPSecDNSDomainTst domainInfo");
        try {
            System.out.println("\n----------------------------------------------------------------");
            this.domain.setTransId("ABC-12345-XYZ");
            String theDomainName = this.makeDomainName();
            System.out.println("domainCreate: Create " + theDomainName + " with all optional attributes");
            this.domain.addDomainName(theDomainName);
            for (int i = 0; i <= 20; ++i) {
                this.domain.addHostName(this.makeHostName(theDomainName));
            }
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.addContact("SH0000", "admin");
                this.domain.addContact("SH0000", "tech");
                this.domain.addContact("SH0000", "billing");
            }
            this.domain.setPeriodLength(10);
            this.domain.setPeriodUnit("y");
            this.domain.setAuthString("ClientX");
            EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
            keyData.setFlags(257);
            keyData.setProtocol(3);
            keyData.setAlg(5);
            keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
            EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
            EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
            dsData.setKeyTag(34095);
            dsData.setAlg(5);
            dsData.setDigestType(1);
            dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
            dsData.setMaxSigLife(604800);
            dsData.setKeyData(keyData);
            EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", 604800, keyData2);
            EPPSecDNSExtCreate create = new EPPSecDNSExtCreate();
            Vector<EPPSecDNSExtDsData> dsDataVec = new Vector<EPPSecDNSExtDsData>();
            dsDataVec.add(dsData);
            create.setDsData(dsDataVec);
            create.appendDsData(dsData2);
            this.domain.addExtension(create);
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("domainCreate: Response = [" + response + "]\n\n");
            System.out.println("domainCreate: name = " + response.getName());
            System.out.println("domainCreate: expiration date = " + response.getExpirationDate());
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
    }

    public void domainUpdateSecDNSUpdateAdd() {
        this.printStart("domainUpdateSecDNSUpdateAdd");
        try {
            this.domain.setTransId("ABC-12345-XYZ");
            String myDomainName = this.makeDomainName();
            this.domain.addDomainName(myDomainName);
            EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
            keyData.setFlags(257);
            keyData.setProtocol(3);
            keyData.setAlg(5);
            keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
            EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
            EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
            dsData.setKeyTag(34095);
            dsData.setAlg(5);
            dsData.setDigestType(1);
            dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
            dsData.setMaxSigLife(604800);
            dsData.setKeyData(keyData);
            EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", 604800, keyData2);
            EPPSecDNSExtUpdate update = new EPPSecDNSExtUpdate();
            Vector<EPPSecDNSExtDsData> dsDataVec = new Vector<EPPSecDNSExtDsData>();
            dsDataVec.add(dsData);
            update.setAdd(dsDataVec);
            update.appendAdd(dsData2);
            this.domain.addExtension(update);
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainUpdateSecDNSUpdateAdd: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainUpdateSecDNSUpdateAdd");
    }

    public void domainUpdateSecDNSUpdateChg() {
        this.printStart("domainUpdateSecDNSUpdateChg");
        try {
            this.domain.setTransId("ABC-12345-XYZ");
            String myDomainName = this.makeDomainName();
            this.domain.addDomainName(myDomainName);
            EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
            keyData.setFlags(257);
            keyData.setProtocol(3);
            keyData.setAlg(5);
            keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
            EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
            EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
            dsData.setKeyTag(34095);
            dsData.setAlg(5);
            dsData.setDigestType(1);
            dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
            dsData.setMaxSigLife(604800);
            dsData.setKeyData(keyData);
            EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", 604800, keyData2);
            EPPSecDNSExtUpdate update = new EPPSecDNSExtUpdate();
            Vector<EPPSecDNSExtDsData> dsDataVec = new Vector<EPPSecDNSExtDsData>();
            dsDataVec.add(dsData);
            update.setChg(dsDataVec);
            update.appendChg(dsData2);
            this.domain.addExtension(update);
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainUpdateSecDNSUpdateChg: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainUpdateSecDNSUpdateChg");
    }

    public void domainUpdateSecDNSUpdateRem() {
        this.printStart("domainUpdateSecDNSUpdateRem");
        try {
            this.domain.setTransId("ABC-12345-XYZ");
            String myDomainName = this.makeDomainName();
            this.domain.addDomainName(myDomainName);
            Integer keyTag = new Integer(34095);
            EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData(keyTag);
            Integer keyTag2 = new Integer(10563);
            EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(keyTag2);
            EPPSecDNSExtUpdate update = new EPPSecDNSExtUpdate();
            Vector<Integer> keyTagVec = new Vector<Integer>();
            keyTagVec.add(keyTag);
            keyTagVec.add(keyTag2);
            update.setRem(keyTagVec);
            update.appendRem(keyTag);
            update.appendRem(keyTag2);
            update.appendRem(dsData);
            update.appendRem(dsData2.getKeyTag());
            this.domain.addExtension(update);
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainUpdateSecDNSUpdateRem: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainUpdateSecDNSUpdateRem");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPSecDNSDomainTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPSecDNSDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSecDNSDomainTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread().getName() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(5) + ".tv");
    }

    public String makeIP() {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10) + "." + String.valueOf(tm + (long)this.rd.nextInt(50)).substring(10));
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeContactName() {
        long tm = System.currentTimeMillis();
        return new String("Con" + String.valueOf(tm + (long)this.rd.nextInt(5)).substring(7));
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

