/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAuthInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreate;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreateResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDelete;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDeleteResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomain;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtPeriod;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenew;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenewResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransfer;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransferResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtUpdate;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPRelatedDomainTst
extends TestCase {
    private EPPDomain domain = null;
    private EPPSession session = null;
    private int iteration = 0;
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private final Random rd = new Random(System.currentTimeMillis());
    private static final Logger cat = Logger.getLogger((String)EPPRelatedDomainTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPRelatedDomainTst(String aName) {
        super(aName);
    }

    public void testRelatedDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.domainInfo();
            this.domainCreate();
            this.domainUpdate();
            this.domainDelete();
            this.domainRenew();
            this.domainTransfer();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void domainInfo() {
        this.printStart("relatedDomainInfo ");
        try {
            System.out.println("\ntestDomainInfo: Domain info of xn--test.tld1");
            this.domain.addDomainName("xn--test.tld1");
            this.domain.setTransId("ABC-12349");
            this.domain.setHosts("del");
            this.domain.setAuthString("2fooBAR");
            this.domain.addExtension(new EPPRelatedDomainExtInfo());
            EPPDomainInfoResp response = this.domain.sendInfo();
            System.out.println("testDomainInfo: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPRelatedDomainExtInfData.class)) {
                EPPRelatedDomainExtInfData relatedDomainInfData = (EPPRelatedDomainExtInfData)response.getExtension(EPPRelatedDomainExtInfData.class);
                System.out.println("EPPRelatedDomainExtInfData = [" + relatedDomainInfData + "]\n\n");
            } else {
                Assert.fail((String)"EPPRelatedDomainExtInfData extension not included for domain info of full-info-owned.com");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("EPPRelatedDomainTst relatedDomainInfo");
    }

    public void domainCreate() {
        this.printStart("relatedDomainCreate ");
        try {
            System.out.println("\ntestDomainCreate: Domain create of example.com and related domains");
            this.domain.addDomainName("example.com");
            this.domain.setTransId("ABC-12349");
            this.domain.setAuthString("2fooBAR");
            EPPRelatedDomainExtCreate create = new EPPRelatedDomainExtCreate();
            this.domain.addExtension(create);
            ArrayList<EPPRelatedDomainExtDomain> domains = new ArrayList<EPPRelatedDomainExtDomain>();
            EPPRelatedDomainExtAuthInfo authInfo = new EPPRelatedDomainExtAuthInfo("relDom123!");
            EPPRelatedDomainExtPeriod period = new EPPRelatedDomainExtPeriod(5);
            EPPRelatedDomainExtDomain domain = new EPPRelatedDomainExtDomain("domain1.com", authInfo, period);
            domains.add(domain);
            domain = new EPPRelatedDomainExtDomain("domain2.com", authInfo, period);
            domains.add(domain);
            domain = new EPPRelatedDomainExtDomain("xn--idn.com", authInfo, period, "CHI");
            domains.add(domain);
            create.setDomains(domains);
            EPPDomainCreateResp response = this.domain.sendCreate();
            System.out.println("testDomainCreate: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPRelatedDomainExtCreateResp.class)) {
                EPPRelatedDomainExtCreateResp relatedDomainCreData = (EPPRelatedDomainExtCreateResp)response.getExtension(EPPRelatedDomainExtCreateResp.class);
                System.out.println("EPPRelatedDomainExtCreateResp = [" + relatedDomainCreData + "]\n\n");
            } else {
                Assert.fail((String)"EPPRelatedDomainExtCreateResp extension not included for domain-create with related domains.");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("relatedDomainCreate");
    }

    public void domainDelete() {
        this.printStart("relatedDomainDelete ");
        try {
            System.out.println("\ntestDomainDelete: Domain delete of example.com and related domains");
            this.domain.addDomainName("example.com");
            this.domain.setTransId("ABC-12349");
            EPPRelatedDomainExtDelete delete = new EPPRelatedDomainExtDelete();
            this.domain.addExtension(delete);
            ArrayList<String> domains = new ArrayList<String>();
            domains.add("domain1.com");
            domains.add("domain2.com");
            delete.setDomains(domains);
            EPPResponse response = this.domain.sendDelete();
            System.out.println("testDomainDelete: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPRelatedDomainExtDeleteResp.class)) {
                EPPRelatedDomainExtDeleteResp relatedDomainCreData = (EPPRelatedDomainExtDeleteResp)response.getExtension(EPPRelatedDomainExtDeleteResp.class);
                System.out.println("EPPRelatedDomainExtDeleteResp = [" + relatedDomainCreData + "]\n\n");
            } else {
                Assert.fail((String)"EPPRelatedDomainExtDeleteResp extension not included for domain-delete with related domains.");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("relatedDomainDelete");
    }

    public void domainTransfer() {
        this.printStart("relatedDomainTransfer ");
        try {
            System.out.println("\ntestDomainTransferRequest: Domain transfer of example.com and related domains");
            this.setDomainTransferAttributes();
            this.domain.setTransferOpCode("request");
            EPPDomainTransferResp response = this.domain.sendTransfer();
            System.out.println("testDomainTransferRequest: Response = [" + response + "]\n\n");
            this.assertTransferExtRespExists(response);
            System.out.println("\ntestDomainTransferApprove: Domain transfer of example.com and related domains");
            this.setDomainTransferAttributes();
            this.domain.setTransferOpCode("approve");
            response = this.domain.sendTransfer();
            System.out.println("testDomainTransferApprove: Response = [" + response + "]\n\n");
            this.assertTransferExtRespExists(response);
            System.out.println("\ntestDomainTransferReject: Domain transfer of example.com and related domains");
            this.setDomainTransferAttributes();
            this.domain.setTransferOpCode("reject");
            response = this.domain.sendTransfer();
            System.out.println("testDomainTransferReject: Response = [" + response + "]\n\n");
            this.assertTransferExtRespExists(response);
            System.out.println("\ntestDomainTransferCancel: Domain transfer of example.com and related domains");
            this.setDomainTransferAttributes();
            this.domain.setTransferOpCode("cancel");
            response = this.domain.sendTransfer();
            System.out.println("testDomainTransferCancel: Response = [" + response + "]\n\n");
            this.assertTransferExtRespExists(response);
            System.out.println("\ntestDomainTransferQuery: Domain transfer of example.com and related domains");
            this.setDomainTransferAttributes();
            this.domain.setTransferOpCode("query");
            response = this.domain.sendTransfer();
            System.out.println("testDomainTransferQuery: Response = [" + response + "]\n\n");
            this.assertTransferExtRespExists(response);
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("relatedDomainTransfer");
    }

    private void setDomainTransferAttributes() {
        this.domain.setTransId("ABC-12345");
        this.domain.setAuthString("ClientX");
        this.domain.addDomainName("example.com");
        this.domain.setPeriodLength(1);
        this.domain.setPeriodUnit("y");
        EPPRelatedDomainExtTransfer transfer = new EPPRelatedDomainExtTransfer();
        this.domain.addExtension(transfer);
        EPPRelatedDomainExtAuthInfo authInfo = new EPPRelatedDomainExtAuthInfo("relDom123!");
        EPPRelatedDomainExtPeriod period = new EPPRelatedDomainExtPeriod(1);
        EPPRelatedDomainExtDomain domain = new EPPRelatedDomainExtDomain("domain1.com", authInfo, period);
        ArrayList<EPPRelatedDomainExtDomain> domains = new ArrayList<EPPRelatedDomainExtDomain>();
        domains.add(domain);
        domain = new EPPRelatedDomainExtDomain("domain2.com", authInfo);
        domains.add(domain);
        transfer.setDomains(domains);
    }

    private void assertTransferExtRespExists(EPPResponse response) {
        if (response.hasExtension(EPPRelatedDomainExtTransferResp.class)) {
            EPPRelatedDomainExtTransferResp relatedDomainCreData = (EPPRelatedDomainExtTransferResp)response.getExtension(EPPRelatedDomainExtTransferResp.class);
            System.out.println("EPPRelatedDomainExtTransferResp = [" + relatedDomainCreData + "]\n\n");
        } else {
            Assert.fail((String)"EPPRelatedDomainExtTransferResp extension not included for domain-transfer with related domains.");
        }
    }

    public void domainRenew() {
        this.printStart("domainRenew");
        try {
            System.out.println("\ndomainRenew: Domain renew");
            this.domain.setTransId("ABC-12345-XYZ");
            this.domain.addDomainName(this.makeDomainName());
            this.domain.setExpirationDate(new GregorianCalendar(2004, 2, 3).getTime());
            this.domain.setPeriodLength(10);
            this.domain.setPeriodUnit("y");
            EPPRelatedDomainExtRenew renew = new EPPRelatedDomainExtRenew();
            this.domain.addExtension(renew);
            EPPRelatedDomainExtAuthInfo authInfo = new EPPRelatedDomainExtAuthInfo("relDom123!");
            EPPRelatedDomainExtPeriod period = new EPPRelatedDomainExtPeriod(5);
            EPPRelatedDomainExtDomain extDomain = new EPPRelatedDomainExtDomain("domain1.com", new Date(), period);
            ArrayList<EPPRelatedDomainExtDomain> domains = new ArrayList<EPPRelatedDomainExtDomain>();
            domains.add(extDomain);
            extDomain = new EPPRelatedDomainExtDomain("domain2.com", new Date(), period);
            domains.add(extDomain);
            renew.setDomains(domains);
            EPPDomainRenewResp response = this.domain.sendRenew();
            System.out.println("testDomainRenew: Response = [" + response + "]\n\n");
            if (response.hasExtension(EPPRelatedDomainExtRenewResp.class)) {
                EPPRelatedDomainExtRenewResp relatedDomainCreData = (EPPRelatedDomainExtRenewResp)response.getExtension(EPPRelatedDomainExtRenewResp.class);
                System.out.println("EPPRelatedDomainExtRenewResp = [" + relatedDomainCreData + "]\n\n");
            } else {
                Assert.fail((String)"EPPRelatedDomainExtRenewResp extension not included for domain-renew with related domains.");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainRenew");
    }

    public void domainUpdate() {
        this.printStart("domainUpdate");
        try {
            System.out.println("\ndomainUpdate: Domain update");
            this.domain.setTransId("ABC-12345-XYZ");
            String theDomainName = this.makeDomainName();
            this.domain.addDomainName(theDomainName);
            EPPRelatedDomainExtUpdate update = new EPPRelatedDomainExtUpdate();
            this.domain.addExtension(update);
            ArrayList<String> domains = new ArrayList<String>();
            domains.add("domain1.com");
            domains.add("domain2.com");
            update.setDomains(domains);
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.setUpdateAttrib(1, "SH0000", "billing", 1);
            }
            this.domain.setUpdateAttrib(0, this.makeHostName(theDomainName), 1);
            this.domain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 1);
            this.domain.setUpdateAttrib(0, this.makeHostName(theDomainName), 2);
            this.domain.setUpdateAttrib(2, new EPPDomainStatus("clientHold"), 2);
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                this.domain.setUpdateAttrib(1, "SH0000", "billing", 2);
            }
            EPPResponse response = this.domain.sendUpdate();
            System.out.println("domainUpdate: Response = [" + response + "]\n\n");
            for (int i = 0; i < response.getResults().size(); ++i) {
                EPPResult myResult = (EPPResult)response.getResults().elementAt(i);
                System.out.println("Result Code    : " + myResult.getCode());
                System.out.println("Result Message : " + myResult.getMessage());
                System.out.println("Result Lang    : " + myResult.getLang());
                if (myResult.isSuccess()) {
                    System.out.println("Command Passed ");
                } else {
                    System.out.println("Command Failed ");
                }
                if (myResult.getAllValues() == null) continue;
                for (int k = 0; k < myResult.getAllValues().size(); ++k) {
                    System.out.println("Result Values  : " + myResult.getAllValues().elementAt(k));
                }
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("domainUpdate");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse domainResponse = this.session.getResponse();
            if (domainResponse != null && !domainResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + domainResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse domainResponse = this.session.getResponse();
            if (domainResponse != null && !domainResponse.isSuccess()) {
                Assert.fail((String)("Server Error : " + domainResponse));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.newInstance();
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
            this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
            this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.domain = new EPPDomain(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPRelatedDomainTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse domainResponse = this.session.getResponse();
        aException.printStackTrace();
        if (domainResponse != null && !domainResponse.isSuccess()) {
            Assert.fail((String)("Server Error : " + domainResponse));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPRelatedDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPRelatedDomainTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    public String makeDomainName() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + ".second.name");
    }

    public String makeHostName(String newDomainName) {
        long tm = System.currentTimeMillis();
        return new String(String.valueOf(tm + (long)this.rd.nextInt(10)).substring(10) + "." + newDomainName);
    }

    public String makeEmail() {
        long tm = System.currentTimeMillis();
        return new String(Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10) + "@second.name");
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }
}

