/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.suggestion;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.suggestion.EPPSuggestionRelated;
import com.verisign.epp.codec.suggestion.util.ExceptionUtil;
import com.verisign.epp.codec.suggestion.util.InvalidValueException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPPSuggestionToken
implements EPPCodecComponent {
    private static final long serialVersionUID = 6914427963136166599L;
    private static final Logger LOGGER = Logger.getLogger((String)EPPSuggestionToken.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final String ATT_NAME = "name";
    static final String ELM_NAME = "suggestion:token";
    private String name = null;
    private List<EPPSuggestionRelated> related = null;

    public EPPSuggestionToken() {
    }

    public EPPSuggestionToken(String aName) {
        this.setName(aName);
    }

    public EPPSuggestionToken(Element aElement) throws EPPDecodeException {
        this.decode(aElement);
    }

    public String getName() {
        return this.name;
    }

    public List<EPPSuggestionRelated> getRelatedList() {
        return this.related;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void addRelated(EPPSuggestionRelated aRelated) throws InvalidValueException {
        if (aRelated == null) {
            throw new InvalidValueException((Object)"Cannot add a null related");
        }
        if (this.related == null) {
            this.resetRelatedList();
        }
        this.related.add(aRelated);
    }

    public void resetRelatedList() {
        this.related = new ArrayList<EPPSuggestionRelated>();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return (EPPSuggestionToken)super.clone();
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = aElement.getAttribute(ATT_NAME);
        if (this.name == null) {
            ExceptionUtil.missingDuringDecode(ATT_NAME);
        }
        NodeList nodes = aElement.getChildNodes();
        Node node = null;
        this.resetRelatedList();
        int size = nodes.getLength();
        for (int i = 0; i < size; ++i) {
            node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            this.related.add(new EPPSuggestionRelated((Element)node));
        }
        if (this.related.size() == 0) {
            this.related = null;
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.verisign-grs.com/epp/suggestion-1.1", ELM_NAME);
        if (this.name == null) {
            ExceptionUtil.missingDuringEncode(ATT_NAME);
        }
        root.setAttribute(ATT_NAME, this.name);
        if (this.related != null) {
            EPPUtil.encodeCompList(aDocument, root, this.related);
        }
        return root;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            EPPSuggestionToken other = (EPPSuggestionToken)o;
            if (!EqualityUtil.equals(this.name, other.name)) {
                LOGGER.error((Object)"EPPSuggestionToken.equals(): name not equal");
                return false;
            }
            if (!EqualityUtil.equals(this.related, other.related)) {
                LOGGER.error((Object)"EPPSuggestionToken.equals(): related not equal");
                return false;
            }
            return true;
        }
        return false;
    }
}

