/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.signedMark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.codec.signedMark.EPPIssuer;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPSignedMark
implements EPPCodecComponent {
    public static final String NS = "urn:ietf:params:xml:ns:signedMark-1.0";
    public static final String NS_PREFIX = "signedMark";
    public static final String NS_SCHEMA = "urn:ietf:params:xml:ns:signedMark-1.0 signedMark-1.0.xsd";
    private static Logger cat = Logger.getLogger((String)EPPSignedMark.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_SIGNED_MARK_LOCALNAME = "signedMark";
    public static final String ELM_SIGNED_MARK_NAME = "signedMark:signedMark";
    public static final String ELM_ENCODED_SIGNED_MARK_LOCALNAME = "encodedSignedMark";
    public static final String ELM_ENCODED_SIGNED_MARK_NAME = "signedMark:encodedSignedMark";
    private static final String ELM_ID = "id";
    private static final String ELM_NOT_BEFORE = "notBefore";
    private static final String ELM_NOT_AFTER = "notAfter";
    private static final String ATTR_ID = "id";
    private static final String ATTR_ID_VALUE = "signedMark";
    private String localName = "signedMark";
    private String id;
    private EPPIssuer issuer;
    private Date notBefore;
    private Date notAfter;
    private EPPMark mark;
    private transient XMLSignature signature;
    private Element signatureElement;
    private static XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM");

    public EPPSignedMark() {
    }

    public EPPSignedMark(String aId, EPPIssuer aIssuer, Date aNotBefore, Date aNotAfter, EPPMark aMark) {
        this.id = aId;
        this.issuer = aIssuer;
        this.notBefore = aNotBefore;
        this.notAfter = aNotAfter;
        this.mark = aMark;
    }

    public EPPSignedMark(String aId, EPPIssuer aIssuer, Date aNotBefore, Date aNotAfter, EPPMark aMark, boolean aBase64Encoded) {
        this.id = aId;
        this.issuer = aIssuer;
        this.notBefore = aNotBefore;
        this.notAfter = aNotAfter;
        this.mark = aMark;
        this.setBase64Encode(aBase64Encoded);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSignedMark clone = (EPPSignedMark)super.clone();
        if (this.issuer != null) {
            clone.issuer = (EPPIssuer)this.issuer.clone();
        }
        if (this.mark != null) {
            clone.mark = (EPPMark)this.mark.clone();
        }
        return clone;
    }

    public void sign(PrivateKey aPrivateKey) throws EPPException {
        cat.debug((Object)"EPPSignedMark.sign(PrivateKey): enter");
        this.sign(aPrivateKey, null);
        cat.debug((Object)"EPPSignedMark.sign(PrivateKey): exit");
    }

    public void sign(PrivateKey aPrivateKey, Certificate[] aCertChain) throws EPPException {
        cat.debug((Object)"EPPSignedMark.sign(PrivateKey, Certificate[]): enter");
        if (aPrivateKey == null) {
            throw new EPPException("EPPSignedMark.sign(PrivateKey, Certificate[]): null aPrivateKey parameter");
        }
        DocumentImpl document = new DocumentImpl();
        boolean origBase64Encoded = this.isBase64Encode();
        this.setBase64Encode(false);
        Element root = this.encode((Document)document);
        document.appendChild(root);
        this.setBase64Encode(origBase64Encoded);
        try {
            DigestMethod digestMethod = sigFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
            ArrayList<Transform> transforms = new ArrayList<Transform>();
            transforms.add(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
            Reference xmlSigRef = sigFactory.newReference("#signedMark", digestMethod, transforms, null, null);
            SignedInfo signedInfo = sigFactory.newSignedInfo(sigFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), sigFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null), Collections.singletonList(xmlSigRef));
            KeyInfo keyInfo = null;
            if (aCertChain != null) {
                cat.debug((Object)"EPPSignedMark.sign(PrivateKey, Certificate[]): certificate chain passed");
                KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
                ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                for (Certificate cert : aCertChain) {
                    if (cert == null || !(cert instanceof X509Certificate)) {
                        throw new EPPException("EPPSignedMark.sign(PrivateKey, Certificate[]): Null or invalid certificate type");
                    }
                    certChain.add((X509Certificate)cert);
                    cat.debug((Object)("EPPSignedMark.sign(PrivateKey, Certificate[]): Added certificate [" + cert + "] to X509Certificate list"));
                }
                ArrayList<X509Data> certDataList = new ArrayList<X509Data>();
                certDataList.add(keyInfoFactory.newX509Data(certChain));
                keyInfo = keyInfoFactory.newKeyInfo(certDataList);
            } else {
                cat.debug((Object)"EPPSignedMark.sign(PrivateKey, Certificate[]): null certificate chain passed, no certificates added");
            }
            DOMSignContext signContext = new DOMSignContext(aPrivateKey, (Node)root);
            signContext.setDefaultNamespacePrefix("dsig");
            this.signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
            this.signature.sign(signContext);
            this.signatureElement = EPPUtil.getElementByTagNameNS(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            cat.error((Object)("Error signing the EPPSignedMark: " + ex));
            throw new EPPException("EPPSignedMark.sign(PrivateKey, Certificate[]): Error signing the EPPSignedMark");
        }
        cat.debug((Object)"EPPSignedMark.sign(PrivateKey, Certificate[]): exit");
    }

    public boolean validate(PKIXParameters aPKIXParameters) {
        return this.validate(aPKIXParameters, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(PKIXParameters aPKIXParameters, boolean aSynchronizePKIXParameters) {
        cat.debug((Object)"validate(PKIXParameters): enter");
        boolean valid = false;
        try {
            Element sigElm = this.findSignatureElement();
            DOMStructure domStructure = new DOMStructure(sigElm);
            this.signature = sigFactory.unmarshalXMLSignature(domStructure);
            if (this.signature.getKeyInfo() == null) {
                throw new Exception("No key info found in Signature");
            }
            ArrayList<X509Certificate> certificates = null;
            List<XMLStructure> keyContent = this.signature.getKeyInfo().getContent();
            for (XMLStructure currInfo : keyContent) {
                if (currInfo instanceof X509Data) {
                    List<?> x509Data = ((X509Data)currInfo).getContent();
                    if (x509Data == null) continue;
                    for (Object currX509Data : x509Data) {
                        if (!(currX509Data instanceof X509Certificate)) continue;
                        if (certificates == null) {
                            certificates = new ArrayList<X509Certificate>();
                        }
                        X509Certificate x509Cert = (X509Certificate)currX509Data;
                        x509Cert.checkValidity();
                        cat.debug((Object)("validate(PKIXParameters): Found X509Certificate [" + x509Cert + "]"));
                        certificates.add(x509Cert);
                    }
                }
                if (certificates == null || certificates.isEmpty()) {
                    throw new Exception("No certificates found in Signature");
                }
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                CertPath certPath = certFactory.generateCertPath((List<? extends Certificate>)certificates);
                CertPathValidator pathValidator = CertPathValidator.getInstance("PKIX");
                if (aSynchronizePKIXParameters) {
                    PKIXParameters pKIXParameters = aPKIXParameters;
                    synchronized (pKIXParameters) {
                        pathValidator.validate(certPath, aPKIXParameters);
                        continue;
                    }
                }
                pathValidator.validate(certPath, aPKIXParameters);
            }
            X509Certificate cert = (X509Certificate)certificates.get(0);
            cat.debug((Object)("validate(PKIXParameters): Getting public key from top certificate [" + cert + "]"));
            PublicKey publicKey = cert.getPublicKey();
            valid = this.validate(sigElm, publicKey);
        }
        catch (Exception ex) {
            cat.error((Object)("validate(PKIXParameters): Error validating the EPPSignedMark: " + ex));
            valid = false;
        }
        cat.debug((Object)("validate(PKIXParameters): exit, valid = " + valid));
        return valid;
    }

    public boolean validate(PublicKey aPublicKey) {
        cat.debug((Object)"validate(PublicKey): enter");
        boolean valid = false;
        try {
            Element sigElm = this.findSignatureElement();
            valid = this.validate(sigElm, aPublicKey);
        }
        catch (Exception ex) {
            cat.error((Object)("validate(PublicKey): Error validating the EPPSignedMark: " + ex));
            valid = false;
        }
        cat.debug((Object)("validate(PublicKey): exit, valid = " + valid));
        return valid;
    }

    public byte[] encode() throws EPPEncodeException {
        cat.debug((Object)"EPPSignedMark.encode(): enter");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            DocumentImpl doc = new DocumentImpl();
            Element root = this.encode((Document)doc);
            doc.appendChild(root);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.transform(new DOMSource(root), new StreamResult(os));
        }
        catch (EPPEncodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            cat.error((Object)("Error encoding signed mark to byte[]: " + ex));
            throw new EPPEncodeException("Error encoding signed mark to byte[]");
        }
        cat.debug((Object)"EPPSignedMark.encode(): exit");
        return os.toByteArray();
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        cat.debug((Object)"EPPSignedMark.encode(Document): enter");
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPSignedMark.encode(Document)");
        }
        Element root = aDocument.createElementNS(NS, "signedMark:" + this.localName);
        if (this.localName.equals(ELM_ENCODED_SIGNED_MARK_LOCALNAME)) {
            this.localName = "signedMark";
            byte[] signedMarkXml = this.encode();
            this.localName = ELM_ENCODED_SIGNED_MARK_LOCALNAME;
            String base64EncodedText = new String(Base64.encodeBase64((byte[])signedMarkXml, (boolean)true));
            Text currVal = aDocument.createTextNode(base64EncodedText);
            root.appendChild(currVal);
            cat.debug((Object)"EPPSignedMark.encode(Document): exit - encoded");
            return root;
        }
        if (this.id == null) {
            throw new EPPEncodeException("Signed mark id is required.");
        }
        if (this.issuer == null) {
            throw new EPPEncodeException("Signed mark issuer is required.");
        }
        if (this.notBefore == null) {
            throw new EPPEncodeException("Signed mark notBefore is required.");
        }
        if (this.notAfter == null) {
            throw new EPPEncodeException("Signed mark notAfter is required.");
        }
        if (this.mark == null) {
            throw new EPPEncodeException("Signed mark mark is required.");
        }
        root.setAttribute("id", "signedMark");
        root.setIdAttribute("id", true);
        EPPUtil.encodeString(aDocument, root, this.id, NS, "signedMark:id");
        EPPUtil.encodeComp(aDocument, root, this.issuer);
        EPPUtil.encodeTimeInstant(aDocument, root, this.notBefore, NS, "signedMark:notBefore");
        EPPUtil.encodeTimeInstant(aDocument, root, this.notAfter, NS, "signedMark:notAfter");
        EPPUtil.encodeComp(aDocument, root, this.mark);
        if (this.signatureElement != null) {
            this.signatureElement = (Element)aDocument.importNode(this.signatureElement, true);
            root.appendChild(this.signatureElement);
        }
        cat.debug((Object)"EPPSignedMark.encode(Document): exit - normal");
        return root;
    }

    public void decode(byte[] aSignedMarkArray) throws EPPDecodeException {
        cat.debug((Object)"EPPSignedMark.decode(byte[]): enter");
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(aSignedMarkArray);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            this.decode(doc.getDocumentElement());
        }
        catch (Exception ex) {
            throw new EPPDecodeException("Error decoding signed mark array: " + ex);
        }
        cat.debug((Object)"EPPSignedMark.decode(byte[]): exit");
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        cat.debug((Object)"EPPSignedMark.decode(Element): enter");
        this.localName = aElement.getLocalName();
        if (this.localName.equals(ELM_ENCODED_SIGNED_MARK_LOCALNAME)) {
            String base64SignedMark = EPPUtil.getTextContent(aElement);
            byte[] signedMarkXML = Base64.decodeBase64((String)base64SignedMark);
            this.localName = "signedMark";
            this.decode(signedMarkXML);
            this.localName = ELM_ENCODED_SIGNED_MARK_LOCALNAME;
            cat.debug((Object)"EPPSignedMark.decode(Element): exit - encoded");
            return;
        }
        this.id = EPPUtil.decodeString(aElement, NS, "id");
        this.issuer = (EPPIssuer)EPPUtil.decodeComp(aElement, NS, "issuerInfo", EPPIssuer.class);
        this.notBefore = EPPUtil.decodeTimeInstant(aElement, NS, ELM_NOT_BEFORE);
        this.notAfter = EPPUtil.decodeTimeInstant(aElement, NS, ELM_NOT_AFTER);
        this.mark = (EPPMark)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:mark-1.0", "mark", EPPMark.class);
        this.signatureElement = EPPUtil.getElementByTagNameNS(aElement, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (this.signatureElement != null) {
            DOMStructure structure = new DOMStructure(this.signatureElement);
            try {
                this.signature = sigFactory.unmarshalXMLSignature(structure);
            }
            catch (MarshalException ex) {
                throw new EPPDecodeException("Error decoding the XML Signature: " + ex);
            }
        }
        cat.debug((Object)"EPPSignedMark.decode(Element): exit - normal");
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSignedMark)) {
            cat.error((Object)"EPPSignedMark.equals(): aObject is not an EPPSignedMark");
            return false;
        }
        EPPSignedMark other = (EPPSignedMark)aObject;
        if (!EqualityUtil.equals(this.id, other.id)) {
            cat.error((Object)"EPPSignedMark.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.issuer, other.issuer)) {
            cat.error((Object)"EPPSignedMark.equals(): issuer not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.notBefore, other.notBefore)) {
            cat.error((Object)"EPPSignedMark.equals(): notBefore not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.notAfter, other.notAfter)) {
            cat.error((Object)"EPPSignedMark.equals(): notAfter not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.mark, other.mark)) {
            cat.error((Object)"EPPSignedMark.equals(): mark not equal");
            return false;
        }
        return true;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String aLocalName) {
        this.localName = aLocalName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public EPPIssuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(EPPIssuer aIssuer) {
        this.issuer = aIssuer;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date aNotBefore) {
        this.notBefore = aNotBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(Date aNotAfter) {
        this.notAfter = aNotAfter;
    }

    public EPPMark getMark() {
        return this.mark;
    }

    public void setMark(EPPMark aMark) {
        this.mark = aMark;
    }

    public XMLSignature getSignature() {
        return this.signature;
    }

    public Element getSignatureElement() {
        return this.signatureElement;
    }

    public boolean isBase64Encode() {
        return this.localName.equals(ELM_ENCODED_SIGNED_MARK_LOCALNAME);
    }

    public void setBase64Encode(boolean aBase64Encode) {
        this.localName = aBase64Encode ? ELM_ENCODED_SIGNED_MARK_LOCALNAME : "signedMark";
    }

    private Element findSignatureElement() throws EPPException {
        cat.debug((Object)"EPPSignedMark.findSignatureElement(): exit");
        Element sigElm = null;
        try {
            DocumentImpl document = new DocumentImpl();
            boolean origBase64Encoded = this.isBase64Encode();
            this.setBase64Encode(false);
            Element root = this.encode((Document)document);
            document.appendChild(root);
            this.setBase64Encode(origBase64Encoded);
            sigElm = EPPUtil.getElementByTagNameNS(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        }
        catch (Exception ex) {
            cat.error((Object)"EPPSignedMark.findSignatureElement(): During processing to find Signature element");
            throw new EPPException("Cannot find Signature element during processing");
        }
        if (sigElm == null) {
            cat.error((Object)"EPPSignedMark.findSignatureElement(): Cannot find Signature element");
            throw new EPPException("Cannot find Signature element");
        }
        cat.debug((Object)"EPPSignedMark.findSignatureElement(): exit");
        return sigElm;
    }

    private boolean validate(Element aSigElm, PublicKey aPublicKey) {
        cat.debug((Object)"validate(Element, PublicKey): enter");
        boolean valid = false;
        try {
            DOMValidateContext valContext = new DOMValidateContext(aPublicKey, (Node)aSigElm);
            this.signature = sigFactory.unmarshalXMLSignature(valContext);
            if (this.signature.validate(valContext)) {
                valid = true;
            } else {
                valid = false;
                cat.error((Object)("validate(Element, PublicKey): validation status = " + this.signature.getSignatureValue().validate(valContext)));
                Iterator<Reference> i = this.signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    cat.error((Object)("validate(Element, PublicKey): ref[" + j + "] validity status = " + i.next().validate(valContext)));
                    ++j;
                }
            }
        }
        catch (Exception ex) {
            cat.error((Object)("validate(Element, PublicKey): Error validating the EPPSignedMark: " + ex));
            valid = false;
        }
        cat.debug((Object)("validate(Element, PublicKey): exit, valid = " + valid));
        return valid;
    }
}

